-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local m = {}

local function check_user_privilege(user_privilege, target_privilege)
    for _, value in ipairs(user_privilege) do
        if target_privilege == value then
            return
        end
    end
    error(base_messages.InsufficientPrivilege())
end

function m.permission_verify(user_privilege)
    check_user_privilege(user_privilege, 'BasicSetting')
    return true
end

return m
