-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local m = {}

local boot_option = {
    ["None"] = 0,
    ["Base Board PXE Boot"] = 1,
    ["HDD Boot"] = 2
}

local boot_effective = {
    ["One-time"] = 0,
    ["Permanent"] = 1
}

function m.check_dpu_boot_parameters(req_option, req_effective)
    -- 不影响其他patch方法，启动方式和持久方式均未传入时，返回false不抛错
    if req_option == nil and req_effective == nil then
        return false
    end
    -- 如果传入了启动相关参数，则option和effective必须同时传入，否则抛错
    if req_option == nil and req_effective ~= nil then
        local err = base_messages.PropertyMissing('BootOption/BootEffective')
        err.RelatedProperties = {'#/Oem/{{OemIdentifier}}/BootEffective'}
        error(err)
    end
    if req_option ~= nil and req_effective == nil then
        local err = base_messages.PropertyMissing('BootOption/BootEffective')
        err.RelatedProperties = {'#/Oem/{{OemIdentifier}}/BootOption'}
        error(err)
    end
    return true
end

function m.get_boot_option(req_option)
    if req_option and boot_option[req_option] then
        return boot_option[req_option]
    end
end

function m.get_boot_effective(req_effective)
    if req_effective and boot_effective[req_effective] then
        return boot_effective[req_effective]
    end
end

return m
