-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
-- Description: 获取BMC的状态

-- 部件资源树的接口
local COMPONENT_INTF <const> = "bmc.kepler.Systems.Component"

local health_str_map = {}
health_str_map[0] = "OK"
health_str_map[1] = "Warning"
health_str_map[2] = "Warning"
health_str_map[3] = "Critical"

local severity_str_map = {}
severity_str_map[0] = "Informational"
severity_str_map[1] = "Minor"
severity_str_map[2] = "Major"
severity_str_map[3] = "Critical"

local m = {}

function m.get(path)
    local component_bmc
    if type(path) == 'string' and #path > 0 then
        component_bmc = mdb.get_object(bus, path, COMPONENT_INTF)
    end
    if not component_bmc then
        return nil
    end

    local health = component_bmc.Health

    local status = {
        Health = health_str_map[health],
        Severity = severity_str_map[health]
    }

    return status
end

return m
