-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local option = string.upper(Input)
local service_map = {
    ["SSH"] = "SSH",
    ["SNMP"] = "SNMP",
    ["KVM"] = "KVMIP",
    ["VNC"] = "VNC",
    ["VMM"] = "VirtualMedia",
    ["VIDEO"] = "Video",
    ["RMCP+"] = "RMCPPlus",
    ["HTTP"] = "HTTP",
    ["HTTPS"] = "HTTPS",
    ["RMCP"] = "RMCP",
    ["SSDP"] = "SSDP"
}

if service_map[option] then
    return {true, service_map[option]}
end

return {false, "InvalidService"}