-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local v1 = ReqBody.value1
local v2 =  ReqBody.value2
local v3 =  ReqBody.value3
local MAX_SUBJECT_INDEX = 65535

-- 无参数输入
if type(v1) ~= 'string' then
    return {}
end

-- 第一个参数为stopall不能输入下一个参数
if v1 == 'stopall' then
    if type(v2) == 'string' then
        return {}
    end
else -- 末尾参数必须为以下的三种
    if type(v3) == 'string' and v3 ~= 'stop' and v3 ~= 'assert' and v3 ~= 'deassert' then
        return {}
    end
    if type(v3) ~= 'string' and v2 ~= 'stop' and v2 ~= 'assert' and v2 ~= 'deassert' then
        return {}
    end
end

-- 事件码特定的事件主体subjectindex有效性判断
if type(v3) == 'string' then
    -- 有效范围为1-65535
    local subject_idx = math.tointeger(v2)
    if not subject_idx or v2 ~= tostring(subject_idx) or subject_idx <= 0 or subject_idx > MAX_SUBJECT_INDEX then
        return {}
    end
    -- eventcode为0xFFFFFFFF以及0x**FFFFFF时，subjectindex不能输入，否则命令有误
    if v1 == '0xFFFFFFFF' or v1 ==  '0x00FFFFFF' then
        return {}
    end
end

-- 以下合法参数返回
if v1 == 'stopall' and type(v2) ~= 'string' then
    return {'0xFFFFFFFF', 0, 0, 0}
elseif v2 == 'stop' and type(v3) ~= 'string' then
    return {v1, 0, 0 ,0}
elseif v2 == 'assert' and type(v3) ~= 'string' then
    return {v1, 1, 0, 1}
elseif v2 == 'deassert' and type(v3) ~= 'string' then
    return {v1, 1, 0, 0}
elseif v3 == 'stop' then
    return {v1 , 0, v2, 0}
elseif v3 == 'assert' then
    return {v1, 1, v2, 1}
elseif v3 == 'deassert' then
    return {v1, 1, v2, 0}
else
    return {}
end