-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local min_fan_slot = 0xff
local max_fan_slot = 0

local min_fan_level = ProcessingFlow[2].Destination.LevelPercentRange[1]
local max_fan_level = 100
for  _, cooling_fan in pairs(Input) do
    min_fan_slot = cooling_fan.FanId < min_fan_slot and cooling_fan.FanId or min_fan_slot
    max_fan_slot = cooling_fan.FanId > max_fan_slot and cooling_fan.FanId or max_fan_slot
end

local fan_level = ReqBody.value
local fan_id = ReqBody.fanid and ReqBody.fanid or 0xff -- 不输入则默认全部风扇

-- 入参检查
if not fan_level or fan_level < 0 then
    return {1, min_fan_slot, max_fan_slot}
end
if fan_id and fan_id < 0 then
    return {1, min_fan_slot, max_fan_slot}
end
-- 风扇控制模式检查
if ProcessingFlow[2].Destination.CtrlMode == 'Auto' then
    return {2, fan_id, fan_level, min_fan_slot, max_fan_slot}
end

if not (fan_id == 0xff or (fan_id >= min_fan_slot and fan_id <= max_fan_slot)) then
    return {1, min_fan_slot, max_fan_slot}
end
if fan_level < min_fan_level then
    return {3, min_fan_level}
end
if fan_level > max_fan_level then
    return {4}
end
return {true, fan_id, fan_level, ProcessingFlow[2].Destination.TimeOut}
