-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local level = ReqBody.level
local device_id = not ReqBody.id and 0xff or ReqBody.id
local fan_t, pump_t = {}, {} -- 风扇和泵的配置表

local PumpSupported = false -- 是否支持泵转速的设置
if type(ProcessingFlow[4].Destination.CtrlMode) == 'string' then
    PumpSupported = true
    pump_t.max_id = #ProcessingFlow[2].Destination.PumpList
    pump_t.min_level = ProcessingFlow[4].Destination.LevelPercentRange[1]
    pump_t.max_level = ProcessingFlow[4].Destination.LevelPercentRange[2]
    pump_t.ctrl_mode = ProcessingFlow[4].Destination.CtrlMode
    pump_t.timeout = ProcessingFlow[4].Destination.TimeOut
end
fan_t.max_id = #ProcessingFlow[1].Destination.FanList
fan_t.min_level = ProcessingFlow[3].Destination.LevelPercentRange[1]
fan_t.max_level = ProcessingFlow[3].Destination.LevelPercentRange[2]
fan_t.ctrl_mode = ProcessingFlow[3].Destination.CtrlMode
fan_t.timeout = ProcessingFlow[3].Destination.TimeOut
if ReqBody.devicetype == 'pump' then
    -- 当不存在泵的配置对象，退出并输出输出提示信息
    if not PumpSupported then
        return {'PumpNotSupported', PumpSupported, fan_t, pump_t}
    end
end
-- 未输入散热设备类型和转速比，退出并输出提示信息
if not ReqBody.devicetype or not ReqBody.level then
    return {'RequiredPropertyNotInput', PumpSupported, fan_t, pump_t}
end
-- 散热设备类型当前仅支持风扇和泵
if ReqBody.devicetype ~= 'fan' and ReqBody.devicetype ~= 'pump' then
    return {'RequiredPropertyNotInput', PumpSupported, fan_t, pump_t}
end

local function check_id_and_level(id, device_level, device_t)
    -- 当前模式为自动, 仅手动模式支持下发
    if device_t.ctrl_mode == 'Auto' then
        return 'CtrlModeIsAuto'
    end
    -- 散热设备的id超出可设置范围
    if id ~= 0xff and (id < 1 or id > device_t.max_id) then
        return 'IdOutOfRange'
    end
    -- 转速超出可设置范围
    if device_level < device_t.min_level or device_level > device_t.max_level then
        return 'LevelOutOfRange'
    end
    return true
end
local rsp = {}
-- 输入为风扇，对输入的id和level进行范围校验
if ReqBody.devicetype == 'fan' then
    rsp[1] = check_id_and_level(device_id, level, fan_t)
    if rsp[1] == true then
        rsp[2] = device_id
        rsp[3] = level
        rsp[4] = fan_t.timeout
        return rsp
    end
    rsp[2] = PumpSupported
    rsp[3] = fan_t
    rsp[4] = pump_t
    rsp[5] = fan_t.timeout
end

-- 输入为泵，对输入的id和level进行范围校验
if ReqBody.devicetype == 'pump' then
    rsp[1] = check_id_and_level(device_id, level, pump_t)
    if rsp[1] == true then
        rsp[2] = device_id
        rsp[3] = level
        rsp[4] = pump_t.timeout
        return rsp
    end
    rsp[2] = PumpSupported
    rsp[3] = fan_t
    rsp[4] = pump_t
    rsp[5] = pump_t.timeout
end

return rsp