-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local utils_vos = require 'utils.vos'
local cli_utils = require 'cli.utils'
local m = {}

local g_area_list = {
    "Africa",
    "America",
    "Antarctica",
    "Arctic",
    "Asia",
    "Atlantic",
    "Australia",
    "Brazil",
    "Canada",
    "Chile",
    "Europe",
    "Indian",
    "Mexico",
    "Pacific",
    "US"
}

local g_state_list = {
    "Argentina",
    "Indiana",
    "Kentucky",
    "North_Dakota"
}

local DIR_PATH <const> = "/usr/share/zoneinfo/" -- zoneinfo目录路径

local function foreach_city(area_path, area_name, city_match_list, tz)
    local city_list = cli_utils.get_dir_files(area_path)
    for _, city_name in pairs(city_list) do
        if (string.lower(area_name) .. '/' .. string.lower(city_name)) == tz then -- 如果完全一致，直接退出，将tz传递给业务
            return true
        end
        table.insert(city_match_list, city_name) -- 匹配失败则继续完善时区列表
    end
    if area_name ~= "America" then
        return false
    end

    for _, state_name in pairs(g_state_list) do
        local state_path = string.format('%s/%s', area_path, state_name)
        if utils_vos.get_file_accessible(state_path) ~= true then     -- 如果州目录不存在
            goto continue
        end
        city_list = cli_utils.get_dir_files(state_path)
        for _, city_name in pairs(city_list) do
            local timezone = string.format('America/%s/%s', state_name, city_name)
            if string.lower(timezone) == tz then     -- 如果完全一致，直接退出，将tz传递给业务
                return true
            end
            table.insert(city_match_list, state_name .. '/' .. city_name)     -- 匹配失败则继续完善时区列表
        end
        ::continue::
    end

    return false
end

-- true 地区时区匹配成功, list[0].v == true 地区匹配成功，否则返回地区列表
local function weak_match_timezone(tz)
    tz = string.lower(tz) -- 地区/城市的模式字符全小写
    local area_match_list = {}
    if utils_vos.get_file_accessible(DIR_PATH) ~= true then -- 判断目录是否存在
        return {}
    end
    for _, area_name in pairs(g_area_list) do
        local area_path = DIR_PATH .. area_name
        if utils_vos.get_file_accessible(area_path) ~= true then -- 如果地区目录不存在
            goto continue
        end
        local area_len = string.len(area_name)
        local tz_area_len = string.sub(tz, 1, area_len + 1)
        local city_match_list = {}
        table.insert(area_match_list, area_name)
        city_match_list[1] = area_name
        city_match_list[2] = false
        local area_name_lower = string.lower(area_name)
        -- 如果输入就是区名或区名后跟的是/
        if tz == area_name_lower or tz_area_len == area_name_lower .. '/' then
            city_match_list[2] = true
        end

        local ret = foreach_city(area_path, area_name, city_match_list, tz)
        if ret then
            return true
        end

        if city_match_list[2] then -- 如果area匹配成功但是city匹配失败，那么直接返回
            return city_match_list
        end
        ::continue::
    end
    return area_match_list -- 如果没有匹配成功，返回时区列表，用于回显模板打印提示信息
end

function m.timezone_check(tz)
    local timezone_sub = string.upper(string.sub(tz, 1, 3))
    local timezone_idx1 = string.sub(tz, 1, 1)
    if timezone_idx1 == '-' or timezone_idx1 == '+' or (timezone_idx1 >= '0' and timezone_idx1 <= '9') then
        return true
    elseif timezone_sub == 'UTC' or timezone_sub == 'GMT' then
        return true
    else
        return weak_match_timezone(tz)
    end
end

function m.timezone_configurable_check(date, flag)
    if not flag then
        return 'not support'
    end

    return date
end

return m
