-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local utils = require 'mc.utils'
local m = {}

function m.get_timestamp()
    local timestamp = mdb.get_object(bus, '/bmc/kepler/Managers/1/Configurations',
        'bmc.kepler.Managers.Configurations').FactoryRestorePointTimestamp
    if timestamp and timestamp ~= '' then
        local time = utils.split(timestamp, ' ')
        local statements = string.format("\nThe restore point was set at %s on %s.", time[2], time[1])
        return statements
    end
    return ''
end

return m
