-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local m = {}


function m.get_port_list(members)
    local objs = {}
    for _, path in pairs(members) do
        local obj = mdb.get_object(bus, path, 'bmc.kepler.Managers.EthernetInterfaces.MgmtPort')
        objs[#objs + 1] = {}
        objs[#objs].Type = obj.Type
        objs[#objs].EthId = obj.EthId
        objs[#objs].DevicePortId = obj.DevicePortId
        objs[#objs].LinkStatus = obj.LinkStatus
    end

    return objs
end
return m
