-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local m = {}

function m.get_frudata_list(list)
    local multi_host_obj = mdb.get_object(bus, '/bmc/kepler/Managers/1/Multihost', 'bmc.kepler.Managers.Multihost')
    if multi_host_obj.HostType ~= 'Multihost' then
        return {}
    end

    local host_table = {}
    for _, value in pairs(list) do
        local host_id = tonumber(string.match(value,'/(%d+)/')) or 0
        -- 公共FRU的host id为0，不记录
        -- 除BCU外都是公共FRU
        if host_id ~= 0 then
            local obj = mdb.get_object(bus, value, 'bmc.kepler.Systems.FruData.Overview')
            if obj.FruType == '36' then
                host_table[tostring(obj.FruId)] = host_id
            end
        end
    end
    return host_table
end

return m
