#!/usr/bin/env python
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.

import os
import shutil
import json
import sys
import copy
from conanbase import ConanBase

class AppConan(ConanBase):
    def build(self):
        if self.settings.build_type == "Release":
            self.run("rm -rf ./interface_config/cli/ipmcset/dft.json")
            self.run("rm -rf ./interface_config/cli/ipmcget/dft.json")
        super(AppConan, self).build()
        
        print(os.getcwd())
        sys.path.append(os.getcwd())
        from mapper_check import MapperCheck
        MapperCheck.check()
        

    def package(self):
        super(AppConan, self).package()
        self.copy("permissions.ini",src="dist/")
        sys.path.append(self.build_folder)
        from  custom import mapping_config_patch
        
        # 各个接口的Script和Plugins配置文件需要保持文本形式，避免探测关联属性失败以及映射器批量替换字段失败
        interface = {"redfish", "web_backend", "cli", "snmp"}
        for intf in interface:
            lua_dir = os.path.join(self.build_folder, "interface_config/" + intf)
            lua_package_dir = os.path.join(self.package_folder, "opt/bmc/apps/" + intf + "/interface_config")
            for root, dirs, files in os.walk(lua_dir):
                for file in files:
                    if file.endswith(".lua") and not os.path.islink(file):
                        file_path = os.path.join(root, file)
                        file_package_path = file_path.replace(lua_dir, lua_package_dir)
                        shutil.copy2(file_path, file_package_path)
            config_path = os.path.join(self.build_folder, 'interface_config', intf)
            patch_path = os.path.join(self.build_folder, 'oem', str(self.options.oem), intf)
            if not os.path.isdir(patch_path):
                continue
            map_patch = mapping_config_patch.MappingConfigPatch(self, patch_path, config_path)
            map_patch.run()
        
        # 压缩json文件
        config_dir = os.path.join(self.build_folder, "interface_config")
        for root, dirs, files in os.walk(config_dir):
            for file in files:
                if file.endswith(".json") and not os.path.islink(file):
                    file_path = os.path.join(root, file)
                    with open(file_path, mode='rb') as fp:
                        data = json.load(fp)
                    content = json.dumps(data, separators=(',', ':'))
                    with open(file_path, mode='wb') as fd:
                        fd.write(content.encode('utf-8'))
                    for interface_type in ["web_backend", "redfish", "snmp", "cli"]:
                        if "interface_config/" + interface_type in file_path:
                            json_dir = os.path.join(self.build_folder, "interface_config", interface_type)
                            json_package_dir = os.path.join(self.package_folder, "opt/bmc/apps", interface_type, "interface_config")
                    file_package_path = file_path.replace(json_dir, json_package_dir)                    
                    result =os.path.split(file_package_path)
                    if not os.path.exists(result[0]):
                        os.mkdir(result[0])
                    shutil.copy2(file_path, file_package_path)

    def package_info(self):
        pass