```
                _                                _
 _ __ __ _  ___| | ___ __ ___   ___  _   _ _ __ | |_
| '__/ _` |/ __| |/ / '_ ` _ \ / _ \| | | | '_ \| __|
| | | (_| | (__|   <| | | | | | (_) | |_| | | | | |_
|_|  \__,_|\___|_|\_\_| |_| |_|\___/ \__,_|_| |_|\__|

```
# rackmount
## 一、仓库介绍
为满足系列化机型的差异处理和伙伴开放场景的使用，需要将系统配置按管理模型进行划分，每种形态单独仓库管理，存放该形态的基础配置。
本仓库描述的是**机架形态**配置数据（rackmount）的基础配置，包含的配置有：北向接口映射配置、南向设备树配置等。
北向接口配置的构建打包方式可参考wiki[映射器配置的机型可灵活拓展](https://openubmc.cn/docs/zh/development/api/rackmount.html#%E4%B9%9D%E3%80%81%E6%8E%A5%E5%8F%A3%E6%98%A0%E5%B0%84%E9%85%8D%E7%BD%AE%E5%A4%9A%E5%B1%82%E7%BA%A7%E5%AE%9A%E5%88%B6)

## 二、目录层级划分
```
.
└── interface_config                        # 北向接口映射器配置
    ├── cli                                 # 命令行接口配置
    │   ├── echoes                          # 回显模板
    │   ├── ipmcget                         # ipmcget命令映射配置
    │   ├── ipmcset                         # ipmcset命令映射配置
    │   ├── plugins                         # 插件
    │   └── script                          # 脚本
    ├── redfish                             # redfish接口映射配置
    │   ├── mapping_config                  # 映射配置
    │   ├── plugins                         # 插件
    │   ├── script                          # 脚本
    │   └── static_resource                 # 静态文件
    ├── snmp                                # snmp接口映射配置
    │   ├── mapping_config                  # 映射配置
    │   ├── plugins                         # 插件
    │   └── script                          # 脚本
    └── web_backend                         # web_backend接口映射配置
        ├── mapping_config                  # 映射配置
        ├── plugins                         # 插件
        └── script                          # 脚本
```

## 三、重大变更
- 2024/11/19 1.60.80 映射器配置整改
配套版本：
    - rackmount：1.60.80
    - Kunpeng-products：1.30.13
    - Ascend-products：1.50.4
    - Customer-CMCC：0.0.7
    - Customer-ByteDance：1.60.9
    - Customer-Baidu：1.60.6

## 四、其他
### CHANGELOG日志记录说明
1. 每个子系统的日志记录到对应的子系统日志文件中，子系统日志文件名为：CHANGELOG_子系统名称.md；
2. 日志记录模板如下所示：
```json
## [x.x.x] - 202x-xx-xx
###  Added/Fixed/Changed
- 修改的描述信息1
- 修改的描述信息2

```

