local lu = require 'luaunit'
local c_psu_object = require 'device.psu'
local client = require 'power_mgmt.client'

local RET_OK <const> = 0
local RET_ERR <const> = -1

local common_ret = RET_ERR

TestPsu = {}

function TestPsu:test_psu_firmware_register()
    function client:PFirmwareInventoryFirmwareInventoryAdd(ctx, FirmwareInfoTable, ...)
        if FirmwareInfoTable.Id == 'EXU_PSU1' then
            common_ret = RET_OK
        end
    end

    c_psu_object.DeviceLocator = 'PowerConverter1'
    c_psu_object.Position = 'EXU'
    c_psu_object.Model = 'qb900'
    c_psu_object.Manufacturer = 'huawei'
    c_psu_object:register_fw_info()
    lu.assertEquals(common_ret, RET_OK)
end
