-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local utils = require 'power_mgmt_utils'
local power_upgrade = (require 'power_upgrade').get_instance()
local file_sec = require 'utils.file'
local utils_core = require 'utils.core'
local c_psu_object = require 'device.psu'
local c_power_configuration = require 'device.power_configuration'
local signal = require 'signal'
local client = require 'power_mgmt.client'

TestPowerUpgrade = {}
utils.cfgs.cfgs = {{component_idex = 2}}
utils.secure_tar_unzip = function () return true end

c_power_configuration.collection.find = function ()end

local f_log = file_sec.open_s('/root/test_upgrade', 'w+')
utils.close(f_log, pcall(f_log.write, f_log, 'xxx'))

client.PFileFileChown = function() return true end
client.UpdateServiceUpdateServicePrepareReply = function () end
client.UpdateServiceUpdateServiceProcessReply = function () end
client.UpdateServiceUpdateServiceFinishReply = function () end

function TestPowerUpgrade:test_prepare()
    pcall(function ()
        power_upgrade.prepare_upgrade(1, 'Power', '/root/test_upgrade')
    end)
end

function TestPowerUpgrade:test_procesee()
    local ok = pcall(function ()
        power_upgrade.process_upgrade(nil, 1, 'Power', '/root/test_upgrade')
    end)
    lu.assertTrue(ok)
end

function TestPowerUpgrade:test_finish()
    pcall(function ()
        power_upgrade.finish_upgrade(1, 'Power')
    end)
end

function TestPowerUpgrade:test_upgrade_check()
    local ok = pcall(function ()
        power_upgrade.upgrade_power_process(1, 'Power', '/root/test_upgrade', 0)
    end)
    lu.assertTrue(ok)
    ok = pcall(function ()
        c_psu_object:power_upgrade()
    end)
    lu.assertTrue(ok)
end

function TestPowerUpgrade:test_signal()
    local ok = pcall(function ()
        signal.upgrade_prepare_callback()
    end)
    lu.assertTrue(ok)

    ok = pcall(function ()
        signal.upgrade_process_callback()
    end)
    lu.assertTrue(ok)

    ok = pcall(function ()
        signal.upgrade_finish_callback()
    end)
    lu.assertTrue(ok)
end