-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_psu_object = require 'device.psu'
local log_service = require 'log_service'
local file_sec = require 'utils.file'
local utils = require 'mc.utils'

local psu = {
    set_work_mode = function()end,
    IsUpgrading = false,
    Protocol = 'pmbus',
    is_healthy = function() return true end,
    power_upgrade = function() return 201 end,
    get_all_prop_names = function (self)
        local prop_names = {}
        for key, value in pairs(self) do
            local value_type = type(value)
            if value_type == 'string' or value_type == 'number' or
                value_type == 'boolean' or value_type == 'table' then
                table.insert(prop_names, key)
            end
        end
        return prop_names
    end
}
psu.__index = psu
c_psu_object.collection.objects = {
    setmetatable({
        SlotNumber = 1, ps_id = 1, ObjectName = 'PSU1', tb = {test = 1},
        power_upgrade = function() return 203 end
    }, {__index = psu}),
    setmetatable({SlotNumber = 2, ps_id = 2, ObjectName = 'PSU1'}, {__index = psu})
}

TestLogService = {}

function TestLogService:test_log_dump()
    local path = './'
    local ok = pcall(function ()
        log_service:dump_psu_info(path)
    end)
    lu.assertTrue(ok)
end
