-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
require 'skynet.manager'
local log = require 'mc.logging'
local BmcApp = require 'power_mgmt_app'

local CMD = {}

function CMD.exit()
    log:info('power_mgmt service exit')
end

log:info('--------------power_mgmt--------------')
skynet.start(function()
    skynet.uniqueservice('sd_bus')
    skynet.register('.power_mgmt')
    local app = BmcApp.new()
    local ok, handler = pcall(require, 'manufacture_app')
    if ok then
        local manufacture = handler.new(app)
        manufacture:init()
    end
    skynet.dispatch('lua', function(_, _, cmd, ...)
        local f = assert(CMD[cmd])
        skynet.ret(skynet.pack(f(...)))
    end)
end)
