-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local singleton = require 'mc.singleton'
require 'power_mgmt.client'
local class = require 'mc.class'
local mdb = require 'mc.mdb'
local log = require 'mc.logging'

local handler = class()

function handler:ctor(bus)
    self.bus = bus
    self.init_ok_flag = false
end

function handler:get_power_state()
    local path = "/bmc/kepler/Systems/1/FruCtrl"
    local interface = "bmc.kepler.Systems.FruCtrl"
    local ok, obj_list = pcall(mdb.get_sub_objects, self.bus, path, interface)
    if not ok or not next(obj_list) then
        log:debug("get fructrl object failed")
        return nil
    end
    for _, obj in pairs(obj_list) do
        return obj.PowerState
    end
end

function handler:get_init_ok_flag()
    return self.init_ok_flag
end

function handler:set_init_ok_flag(flag)
    self.init_ok_flag = flag
end

return singleton(handler)
