-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local class = require "mc.class"
local base_messages = require 'messages.base'

local customize_config = {}
local service_map = {}

-- 对象管理器, 同一个类可能有多个对象
local objects_manager = class()

function objects_manager:ctor(class_name, json_data)
    self.class_name = class_name
    self.object_list_json = json_data
end

function objects_manager:import_one_object(ctx, obj_json)
    local service = service_map[self.class_name]
    if not service then
        log:error("[power_mgmt]import power_mgmt json: class name(%s) no exist", self.class_name)
        error(base_messages.InternalError())
    end
    service:import(ctx, obj_json)
end

-- 属性导入
function objects_manager:import(ctx)
    local object_list_json = self.object_list_json
    if #object_list_json == 0 then
        self:import_one_object(ctx, object_list_json)
        return
    end
    for _, v in pairs(object_list_json) do
        self:import_one_object(ctx, v)
    end
end

-- 解析出对象列表
local function parse_object_list(obj_list_data)
    if not obj_list_data then
        return {}
    end
    local objects_manager_list = {}
    for k, v in pairs(obj_list_data) do
        local obj = objects_manager.new(k, v)
        table.insert(objects_manager_list, obj)
    end
    return objects_manager_list
end

-- 注册目标类所在的业务
function customize_config.register_config_dealer(class_name, service)
    service_map[class_name] = service
end

function customize_config.config_import_data(config)
    parse_object_list(config)
end

function customize_config.config_export_data(config)
end

return customize_config
