-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

local db_selector = {}

---@class SystemPowerTable: Table
---@field Id FieldBase
---@field PsuFruConfig FieldBase

---@class Power_mgmtDBDatabasePoweroff
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field SystemPower SystemPowerTable

local Power_mgmtDBDatabasePoweroff = {}
Power_mgmtDBDatabasePoweroff.__index = Power_mgmtDBDatabasePoweroff

function Power_mgmtDBDatabasePoweroff.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.SystemPower = db:Table('t_syspower_cfg', {
        Id = Col.TextField():cid(1):primary_key():default('\'SystemPower\''),
        PsuFruConfig = Col.IntegerField():cid(2):null():max_length(32):default(0)
    }):create_if_not_exist(datas and datas['t_syspower_cfg'])

    obj.tables = db.tables
    return setmetatable(obj, Power_mgmtDBDatabasePoweroff)
end

function Power_mgmtDBDatabasePoweroff:select(table, ...)
    return self.db:select(table, ...)
end

function Power_mgmtDBDatabasePoweroff:update(table, ...)
    return self.db:update(table, ...)
end

function Power_mgmtDBDatabasePoweroff:insert(table, ...)
    return self.db:insert(table, ...)
end

function Power_mgmtDBDatabasePoweroff:delete(table, ...)
    return self.db:delete(table, ...)
end

function Power_mgmtDBDatabasePoweroff:exec(...)
    return self.db:exec(...)
end

db_selector['poweroff'] = Power_mgmtDBDatabasePoweroff.new

local Power_mgmtDBDatabase = {}
Power_mgmtDBDatabase.__index = Power_mgmtDBDatabase

function Power_mgmtDBDatabase.new(path, datas, type)
    return db_selector[type] and db_selector[type](path, datas) or nil
end

return Power_mgmtDBDatabase.new
