-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Temperatures = {}

---@class Temperatures.InnerTemperatureCelsius
---@field InnerTemperatureCelsius number
local TInnerTemperatureCelsius = {}
TInnerTemperatureCelsius.__index = TInnerTemperatureCelsius
TInnerTemperatureCelsius.group = {}

local function TInnerTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TInnerTemperatureCelsius)
end

function TInnerTemperatureCelsius.new(InnerTemperatureCelsius)
    return TInnerTemperatureCelsius_from_obj({InnerTemperatureCelsius = InnerTemperatureCelsius})
end
---@param obj Temperatures.InnerTemperatureCelsius
function TInnerTemperatureCelsius:init_from_obj(obj)
    self.InnerTemperatureCelsius = obj.InnerTemperatureCelsius
end

function TInnerTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInnerTemperatureCelsius.group)
end

TInnerTemperatureCelsius.from_obj = TInnerTemperatureCelsius_from_obj

TInnerTemperatureCelsius.proto_property = {'InnerTemperatureCelsius'}

TInnerTemperatureCelsius.default = {0}

TInnerTemperatureCelsius.struct = {{name = 'InnerTemperatureCelsius', is_array = false, struct = nil}}

function TInnerTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InnerTemperatureCelsius', self.InnerTemperatureCelsius, 'double', true, errs,
        need_convert)

    TInnerTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInnerTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TInnerTemperatureCelsius:unpack(_)
    return self.InnerTemperatureCelsius
end

Temperatures.InnerTemperatureCelsius = TInnerTemperatureCelsius

---@class Temperatures.InletTemperatureCelsius
---@field InletTemperatureCelsius number
local TInletTemperatureCelsius = {}
TInletTemperatureCelsius.__index = TInletTemperatureCelsius
TInletTemperatureCelsius.group = {}

local function TInletTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TInletTemperatureCelsius)
end

function TInletTemperatureCelsius.new(InletTemperatureCelsius)
    return TInletTemperatureCelsius_from_obj({InletTemperatureCelsius = InletTemperatureCelsius})
end
---@param obj Temperatures.InletTemperatureCelsius
function TInletTemperatureCelsius:init_from_obj(obj)
    self.InletTemperatureCelsius = obj.InletTemperatureCelsius
end

function TInletTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInletTemperatureCelsius.group)
end

TInletTemperatureCelsius.from_obj = TInletTemperatureCelsius_from_obj

TInletTemperatureCelsius.proto_property = {'InletTemperatureCelsius'}

TInletTemperatureCelsius.default = {0}

TInletTemperatureCelsius.struct = {{name = 'InletTemperatureCelsius', is_array = false, struct = nil}}

function TInletTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InletTemperatureCelsius', self.InletTemperatureCelsius, 'double', true, errs,
        need_convert)

    TInletTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInletTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TInletTemperatureCelsius:unpack(_)
    return self.InletTemperatureCelsius
end

Temperatures.InletTemperatureCelsius = TInletTemperatureCelsius

---@class Temperatures.SecondaryChipTemperatureCelsius
---@field SecondaryChipTemperatureCelsius number
local TSecondaryChipTemperatureCelsius = {}
TSecondaryChipTemperatureCelsius.__index = TSecondaryChipTemperatureCelsius
TSecondaryChipTemperatureCelsius.group = {}

local function TSecondaryChipTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TSecondaryChipTemperatureCelsius)
end

function TSecondaryChipTemperatureCelsius.new(SecondaryChipTemperatureCelsius)
    return
        TSecondaryChipTemperatureCelsius_from_obj({SecondaryChipTemperatureCelsius = SecondaryChipTemperatureCelsius})
end
---@param obj Temperatures.SecondaryChipTemperatureCelsius
function TSecondaryChipTemperatureCelsius:init_from_obj(obj)
    self.SecondaryChipTemperatureCelsius = obj.SecondaryChipTemperatureCelsius
end

function TSecondaryChipTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSecondaryChipTemperatureCelsius.group)
end

TSecondaryChipTemperatureCelsius.from_obj = TSecondaryChipTemperatureCelsius_from_obj

TSecondaryChipTemperatureCelsius.proto_property = {'SecondaryChipTemperatureCelsius'}

TSecondaryChipTemperatureCelsius.default = {0}

TSecondaryChipTemperatureCelsius.struct = {{name = 'SecondaryChipTemperatureCelsius', is_array = false, struct = nil}}

function TSecondaryChipTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SecondaryChipTemperatureCelsius', self.SecondaryChipTemperatureCelsius, 'double', true,
        errs, need_convert)

    TSecondaryChipTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSecondaryChipTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TSecondaryChipTemperatureCelsius:unpack(_)
    return self.SecondaryChipTemperatureCelsius
end

Temperatures.SecondaryChipTemperatureCelsius = TSecondaryChipTemperatureCelsius

---@class Temperatures.PrimaryChipTemperatureCelsius
---@field PrimaryChipTemperatureCelsius number
local TPrimaryChipTemperatureCelsius = {}
TPrimaryChipTemperatureCelsius.__index = TPrimaryChipTemperatureCelsius
TPrimaryChipTemperatureCelsius.group = {}

local function TPrimaryChipTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TPrimaryChipTemperatureCelsius)
end

function TPrimaryChipTemperatureCelsius.new(PrimaryChipTemperatureCelsius)
    return TPrimaryChipTemperatureCelsius_from_obj({PrimaryChipTemperatureCelsius = PrimaryChipTemperatureCelsius})
end
---@param obj Temperatures.PrimaryChipTemperatureCelsius
function TPrimaryChipTemperatureCelsius:init_from_obj(obj)
    self.PrimaryChipTemperatureCelsius = obj.PrimaryChipTemperatureCelsius
end

function TPrimaryChipTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPrimaryChipTemperatureCelsius.group)
end

TPrimaryChipTemperatureCelsius.from_obj = TPrimaryChipTemperatureCelsius_from_obj

TPrimaryChipTemperatureCelsius.proto_property = {'PrimaryChipTemperatureCelsius'}

TPrimaryChipTemperatureCelsius.default = {0}

TPrimaryChipTemperatureCelsius.struct = {{name = 'PrimaryChipTemperatureCelsius', is_array = false, struct = nil}}

function TPrimaryChipTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PrimaryChipTemperatureCelsius', self.PrimaryChipTemperatureCelsius, 'double', true,
        errs, need_convert)

    TPrimaryChipTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPrimaryChipTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TPrimaryChipTemperatureCelsius:unpack(_)
    return self.PrimaryChipTemperatureCelsius
end

Temperatures.PrimaryChipTemperatureCelsius = TPrimaryChipTemperatureCelsius

---@class Temperatures.EnvTemperatureCelsius
---@field EnvTemperatureCelsius number
local TEnvTemperatureCelsius = {}
TEnvTemperatureCelsius.__index = TEnvTemperatureCelsius
TEnvTemperatureCelsius.group = {}

local function TEnvTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TEnvTemperatureCelsius)
end

function TEnvTemperatureCelsius.new(EnvTemperatureCelsius)
    return TEnvTemperatureCelsius_from_obj({EnvTemperatureCelsius = EnvTemperatureCelsius})
end
---@param obj Temperatures.EnvTemperatureCelsius
function TEnvTemperatureCelsius:init_from_obj(obj)
    self.EnvTemperatureCelsius = obj.EnvTemperatureCelsius
end

function TEnvTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnvTemperatureCelsius.group)
end

TEnvTemperatureCelsius.from_obj = TEnvTemperatureCelsius_from_obj

TEnvTemperatureCelsius.proto_property = {'EnvTemperatureCelsius'}

TEnvTemperatureCelsius.default = {0}

TEnvTemperatureCelsius.struct = {{name = 'EnvTemperatureCelsius', is_array = false, struct = nil}}

function TEnvTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EnvTemperatureCelsius', self.EnvTemperatureCelsius, 'double', true, errs, need_convert)

    TEnvTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnvTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TEnvTemperatureCelsius:unpack(_)
    return self.EnvTemperatureCelsius
end

Temperatures.EnvTemperatureCelsius = TEnvTemperatureCelsius

Temperatures.interface = mdb.register_interface('bmc.kepler.Systems.PowerMgmt.OnePower.Temperatures', {
    EnvTemperatureCelsius = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    PrimaryChipTemperatureCelsius = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    SecondaryChipTemperatureCelsius = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    InletTemperatureCelsius = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    InnerTemperatureCelsius = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false}
}, {}, {})

return Temperatures
