-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Metrics = {}

---@class Metrics.InputFrequencyHz
---@field InputFrequencyHz number
local TInputFrequencyHz = {}
TInputFrequencyHz.__index = TInputFrequencyHz
TInputFrequencyHz.group = {}

local function TInputFrequencyHz_from_obj(obj)
    return setmetatable(obj, TInputFrequencyHz)
end

function TInputFrequencyHz.new(InputFrequencyHz)
    return TInputFrequencyHz_from_obj({InputFrequencyHz = InputFrequencyHz})
end
---@param obj Metrics.InputFrequencyHz
function TInputFrequencyHz:init_from_obj(obj)
    self.InputFrequencyHz = obj.InputFrequencyHz
end

function TInputFrequencyHz:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputFrequencyHz.group)
end

TInputFrequencyHz.from_obj = TInputFrequencyHz_from_obj

TInputFrequencyHz.proto_property = {'InputFrequencyHz'}

TInputFrequencyHz.default = {0}

TInputFrequencyHz.struct = {{name = 'InputFrequencyHz', is_array = false, struct = nil}}

function TInputFrequencyHz:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputFrequencyHz', self.InputFrequencyHz, 'double', true, errs, need_convert)

    TInputFrequencyHz:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputFrequencyHz.proto_property, errs, need_convert)
    return self
end

function TInputFrequencyHz:unpack(_)
    return self.InputFrequencyHz
end

Metrics.InputFrequencyHz = TInputFrequencyHz

---@class Metrics.RatedCurrentAmps
---@field RatedCurrentAmps integer
local TRatedCurrentAmps = {}
TRatedCurrentAmps.__index = TRatedCurrentAmps
TRatedCurrentAmps.group = {}

local function TRatedCurrentAmps_from_obj(obj)
    return setmetatable(obj, TRatedCurrentAmps)
end

function TRatedCurrentAmps.new(RatedCurrentAmps)
    return TRatedCurrentAmps_from_obj({RatedCurrentAmps = RatedCurrentAmps})
end
---@param obj Metrics.RatedCurrentAmps
function TRatedCurrentAmps:init_from_obj(obj)
    self.RatedCurrentAmps = obj.RatedCurrentAmps
end

function TRatedCurrentAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRatedCurrentAmps.group)
end

TRatedCurrentAmps.from_obj = TRatedCurrentAmps_from_obj

TRatedCurrentAmps.proto_property = {'RatedCurrentAmps'}

TRatedCurrentAmps.default = {0}

TRatedCurrentAmps.struct = {{name = 'RatedCurrentAmps', is_array = false, struct = nil}}

function TRatedCurrentAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RatedCurrentAmps', self.RatedCurrentAmps, 'uint16', true, errs, need_convert)

    TRatedCurrentAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRatedCurrentAmps.proto_property, errs, need_convert)
    return self
end

function TRatedCurrentAmps:unpack(_)
    return self.RatedCurrentAmps
end

Metrics.RatedCurrentAmps = TRatedCurrentAmps

---@class Metrics.Rate
---@field Rate integer
local TRate = {}
TRate.__index = TRate
TRate.group = {}

local function TRate_from_obj(obj)
    return setmetatable(obj, TRate)
end

function TRate.new(Rate)
    return TRate_from_obj({Rate = Rate})
end
---@param obj Metrics.Rate
function TRate:init_from_obj(obj)
    self.Rate = obj.Rate
end

function TRate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRate.group)
end

TRate.from_obj = TRate_from_obj

TRate.proto_property = {'Rate'}

TRate.default = {0}

TRate.struct = {{name = 'Rate', is_array = false, struct = nil}}

function TRate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Rate', self.Rate, 'uint16', true, errs, need_convert)

    TRate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRate.proto_property, errs, need_convert)
    return self
end

function TRate:unpack(_)
    return self.Rate
end

Metrics.Rate = TRate

---@class Metrics.OutputCurrentAmps
---@field OutputCurrentAmps number
local TOutputCurrentAmps = {}
TOutputCurrentAmps.__index = TOutputCurrentAmps
TOutputCurrentAmps.group = {}

local function TOutputCurrentAmps_from_obj(obj)
    return setmetatable(obj, TOutputCurrentAmps)
end

function TOutputCurrentAmps.new(OutputCurrentAmps)
    return TOutputCurrentAmps_from_obj({OutputCurrentAmps = OutputCurrentAmps})
end
---@param obj Metrics.OutputCurrentAmps
function TOutputCurrentAmps:init_from_obj(obj)
    self.OutputCurrentAmps = obj.OutputCurrentAmps
end

function TOutputCurrentAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputCurrentAmps.group)
end

TOutputCurrentAmps.from_obj = TOutputCurrentAmps_from_obj

TOutputCurrentAmps.proto_property = {'OutputCurrentAmps'}

TOutputCurrentAmps.default = {0}

TOutputCurrentAmps.struct = {{name = 'OutputCurrentAmps', is_array = false, struct = nil}}

function TOutputCurrentAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputCurrentAmps', self.OutputCurrentAmps, 'double', true, errs, need_convert)

    TOutputCurrentAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputCurrentAmps.proto_property, errs, need_convert)
    return self
end

function TOutputCurrentAmps:unpack(_)
    return self.OutputCurrentAmps
end

Metrics.OutputCurrentAmps = TOutputCurrentAmps

---@class Metrics.InputCurrentAmps
---@field InputCurrentAmps number
local TInputCurrentAmps = {}
TInputCurrentAmps.__index = TInputCurrentAmps
TInputCurrentAmps.group = {}

local function TInputCurrentAmps_from_obj(obj)
    return setmetatable(obj, TInputCurrentAmps)
end

function TInputCurrentAmps.new(InputCurrentAmps)
    return TInputCurrentAmps_from_obj({InputCurrentAmps = InputCurrentAmps})
end
---@param obj Metrics.InputCurrentAmps
function TInputCurrentAmps:init_from_obj(obj)
    self.InputCurrentAmps = obj.InputCurrentAmps
end

function TInputCurrentAmps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputCurrentAmps.group)
end

TInputCurrentAmps.from_obj = TInputCurrentAmps_from_obj

TInputCurrentAmps.proto_property = {'InputCurrentAmps'}

TInputCurrentAmps.default = {0}

TInputCurrentAmps.struct = {{name = 'InputCurrentAmps', is_array = false, struct = nil}}

function TInputCurrentAmps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputCurrentAmps', self.InputCurrentAmps, 'double', true, errs, need_convert)

    TInputCurrentAmps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputCurrentAmps.proto_property, errs, need_convert)
    return self
end

function TInputCurrentAmps:unpack(_)
    return self.InputCurrentAmps
end

Metrics.InputCurrentAmps = TInputCurrentAmps

---@class Metrics.OutputVoltage
---@field OutputVoltage number
local TOutputVoltage = {}
TOutputVoltage.__index = TOutputVoltage
TOutputVoltage.group = {}

local function TOutputVoltage_from_obj(obj)
    return setmetatable(obj, TOutputVoltage)
end

function TOutputVoltage.new(OutputVoltage)
    return TOutputVoltage_from_obj({OutputVoltage = OutputVoltage})
end
---@param obj Metrics.OutputVoltage
function TOutputVoltage:init_from_obj(obj)
    self.OutputVoltage = obj.OutputVoltage
end

function TOutputVoltage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputVoltage.group)
end

TOutputVoltage.from_obj = TOutputVoltage_from_obj

TOutputVoltage.proto_property = {'OutputVoltage'}

TOutputVoltage.default = {0}

TOutputVoltage.struct = {{name = 'OutputVoltage', is_array = false, struct = nil}}

function TOutputVoltage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputVoltage', self.OutputVoltage, 'double', true, errs, need_convert)

    TOutputVoltage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputVoltage.proto_property, errs, need_convert)
    return self
end

function TOutputVoltage:unpack(_)
    return self.OutputVoltage
end

Metrics.OutputVoltage = TOutputVoltage

---@class Metrics.InputVoltage
---@field InputVoltage number
local TInputVoltage = {}
TInputVoltage.__index = TInputVoltage
TInputVoltage.group = {}

local function TInputVoltage_from_obj(obj)
    return setmetatable(obj, TInputVoltage)
end

function TInputVoltage.new(InputVoltage)
    return TInputVoltage_from_obj({InputVoltage = InputVoltage})
end
---@param obj Metrics.InputVoltage
function TInputVoltage:init_from_obj(obj)
    self.InputVoltage = obj.InputVoltage
end

function TInputVoltage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputVoltage.group)
end

TInputVoltage.from_obj = TInputVoltage_from_obj

TInputVoltage.proto_property = {'InputVoltage'}

TInputVoltage.default = {0}

TInputVoltage.struct = {{name = 'InputVoltage', is_array = false, struct = nil}}

function TInputVoltage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputVoltage', self.InputVoltage, 'double', true, errs, need_convert)

    TInputVoltage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputVoltage.proto_property, errs, need_convert)
    return self
end

function TInputVoltage:unpack(_)
    return self.InputVoltage
end

Metrics.InputVoltage = TInputVoltage

---@class Metrics.InputPowerWatts
---@field InputPowerWatts number
local TInputPowerWatts = {}
TInputPowerWatts.__index = TInputPowerWatts
TInputPowerWatts.group = {}

local function TInputPowerWatts_from_obj(obj)
    return setmetatable(obj, TInputPowerWatts)
end

function TInputPowerWatts.new(InputPowerWatts)
    return TInputPowerWatts_from_obj({InputPowerWatts = InputPowerWatts})
end
---@param obj Metrics.InputPowerWatts
function TInputPowerWatts:init_from_obj(obj)
    self.InputPowerWatts = obj.InputPowerWatts
end

function TInputPowerWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputPowerWatts.group)
end

TInputPowerWatts.from_obj = TInputPowerWatts_from_obj

TInputPowerWatts.proto_property = {'InputPowerWatts'}

TInputPowerWatts.default = {0}

TInputPowerWatts.struct = {{name = 'InputPowerWatts', is_array = false, struct = nil}}

function TInputPowerWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputPowerWatts', self.InputPowerWatts, 'double', true, errs, need_convert)

    TInputPowerWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputPowerWatts.proto_property, errs, need_convert)
    return self
end

function TInputPowerWatts:unpack(_)
    return self.InputPowerWatts
end

Metrics.InputPowerWatts = TInputPowerWatts

---@class Metrics.OutputPowerWatts
---@field OutputPowerWatts number
local TOutputPowerWatts = {}
TOutputPowerWatts.__index = TOutputPowerWatts
TOutputPowerWatts.group = {}

local function TOutputPowerWatts_from_obj(obj)
    return setmetatable(obj, TOutputPowerWatts)
end

function TOutputPowerWatts.new(OutputPowerWatts)
    return TOutputPowerWatts_from_obj({OutputPowerWatts = OutputPowerWatts})
end
---@param obj Metrics.OutputPowerWatts
function TOutputPowerWatts:init_from_obj(obj)
    self.OutputPowerWatts = obj.OutputPowerWatts
end

function TOutputPowerWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputPowerWatts.group)
end

TOutputPowerWatts.from_obj = TOutputPowerWatts_from_obj

TOutputPowerWatts.proto_property = {'OutputPowerWatts'}

TOutputPowerWatts.default = {0}

TOutputPowerWatts.struct = {{name = 'OutputPowerWatts', is_array = false, struct = nil}}

function TOutputPowerWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputPowerWatts', self.OutputPowerWatts, 'double', true, errs, need_convert)

    TOutputPowerWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputPowerWatts.proto_property, errs, need_convert)
    return self
end

function TOutputPowerWatts:unpack(_)
    return self.OutputPowerWatts
end

Metrics.OutputPowerWatts = TOutputPowerWatts

Metrics.interface = mdb.register_interface('bmc.kepler.Systems.PowerMgmt.OnePower.Metrics', {
    OutputPowerWatts = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    InputPowerWatts = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    InputVoltage = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    OutputVoltage = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    InputCurrentAmps = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    OutputCurrentAmps = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    Rate = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    RatedCurrentAmps = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    InputFrequencyHz = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false}
}, {}, {})

return Metrics
