-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local FirmwareInventory = {}

---@class FirmwareInventory.Object
---@field key string
---@field value string
local TObject = {}
TObject.__index = TObject
TObject.group = {}

local function TObject_from_obj(obj)
    return setmetatable(obj, TObject)
end

function TObject.new(dict)
    return TObject_from_obj(dict)
end

---@param obj FirmwareInventory.Object
function TObject:init_from_obj(obj)
    self = obj
end

function TObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TObject.group)
end

TObject.from_obj = TObject_from_obj

TObject.proto_property = {}

TObject.default = {}

TObject.struct = {}

function TObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TObject:remove_error_props(errs, self)
    return self
end

function TObject:unpack(_)
    return self
end

FirmwareInventory.Object = TObject

---@class FirmwareInventory.DeleteRsp
local TDeleteRsp = {}
TDeleteRsp.__index = TDeleteRsp
TDeleteRsp.group = {}

local function TDeleteRsp_from_obj(obj)
    return setmetatable(obj, TDeleteRsp)
end

function TDeleteRsp.new()
    return TDeleteRsp_from_obj({})
end
---@param obj FirmwareInventory.DeleteRsp
function TDeleteRsp:init_from_obj(obj)

end

function TDeleteRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteRsp.group)
end

TDeleteRsp.from_obj = TDeleteRsp_from_obj

TDeleteRsp.proto_property = {}

TDeleteRsp.default = {}

TDeleteRsp.struct = {}

function TDeleteRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDeleteRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteRsp.proto_property, errs, need_convert)
    return self
end

function TDeleteRsp:unpack(_)
end

FirmwareInventory.DeleteRsp = TDeleteRsp

---@class FirmwareInventory.DeleteReq
---@field Id string
local TDeleteReq = {}
TDeleteReq.__index = TDeleteReq
TDeleteReq.group = {}

local function TDeleteReq_from_obj(obj)
    return setmetatable(obj, TDeleteReq)
end

function TDeleteReq.new(Id)
    return TDeleteReq_from_obj({Id = Id})
end
---@param obj FirmwareInventory.DeleteReq
function TDeleteReq:init_from_obj(obj)
    self.Id = obj.Id
end

function TDeleteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteReq.group)
end

TDeleteReq.from_obj = TDeleteReq_from_obj

TDeleteReq.proto_property = {'Id'}

TDeleteReq.default = {''}

TDeleteReq.struct = {{name = 'Id', is_array = false, struct = nil}}

function TDeleteReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TDeleteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteReq.proto_property, errs, need_convert)
    return self
end

function TDeleteReq:unpack(_)
    return self.Id
end

FirmwareInventory.DeleteReq = TDeleteReq

---@class FirmwareInventory.AddRsp
local TAddRsp = {}
TAddRsp.__index = TAddRsp
TAddRsp.group = {}

local function TAddRsp_from_obj(obj)
    return setmetatable(obj, TAddRsp)
end

function TAddRsp.new()
    return TAddRsp_from_obj({})
end
---@param obj FirmwareInventory.AddRsp
function TAddRsp:init_from_obj(obj)

end

function TAddRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddRsp.group)
end

TAddRsp.from_obj = TAddRsp_from_obj

TAddRsp.proto_property = {}

TAddRsp.default = {}

TAddRsp.struct = {}

function TAddRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TAddRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddRsp.proto_property, errs, need_convert)
    return self
end

function TAddRsp:unpack(_)
end

FirmwareInventory.AddRsp = TAddRsp

---@class FirmwareInventory.AddReq
---@field FirmwareInfoTable FirmwareInventory.Object
---@field Updateable boolean
---@field Capability integer
---@field MaxPackageSizeMiB integer
local TAddReq = {}
TAddReq.__index = TAddReq
TAddReq.group = {}

local function TAddReq_from_obj(obj)
    return setmetatable(obj, TAddReq)
end

function TAddReq.new(FirmwareInfoTable, Updateable, Capability, MaxPackageSizeMiB)
    return TAddReq_from_obj({
        FirmwareInfoTable = FirmwareInfoTable,
        Updateable = Updateable,
        Capability = Capability,
        MaxPackageSizeMiB = MaxPackageSizeMiB
    })
end
---@param obj FirmwareInventory.AddReq
function TAddReq:init_from_obj(obj)
    self.FirmwareInfoTable = obj.FirmwareInfoTable
    self.Updateable = obj.Updateable
    self.Capability = obj.Capability
    self.MaxPackageSizeMiB = obj.MaxPackageSizeMiB
end

function TAddReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddReq.group)
end

TAddReq.from_obj = TAddReq_from_obj

TAddReq.proto_property = {'FirmwareInfoTable', 'Updateable', 'Capability', 'MaxPackageSizeMiB'}

TAddReq.default = {FirmwareInventory.Object.default, false, 0, 0}

TAddReq.struct = {
    {name = 'FirmwareInfoTable', is_array = false, struct = FirmwareInventory.Object.struct},
    {name = 'Updateable', is_array = false, struct = nil}, {name = 'Capability', is_array = false, struct = nil},
    {name = 'MaxPackageSizeMiB', is_array = false, struct = nil}
}

function TAddReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    FirmwareInventory.Object.new(self.FirmwareInfoTable):validate(prefix, errs, need_convert)

    validate.Optional(prefix .. 'Updateable', self.Updateable, 'bool', false, errs, need_convert)
    validate.Optional(prefix .. 'Capability', self.Capability, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'MaxPackageSizeMiB', self.MaxPackageSizeMiB, 'int32', false, errs, need_convert)

    TAddReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddReq.proto_property, errs, need_convert)
    return self
end

function TAddReq:unpack(_)
    return self.FirmwareInfoTable, self.Updateable, self.Capability, self.MaxPackageSizeMiB
end

FirmwareInventory.AddReq = TAddReq

FirmwareInventory.interface = mdb.register_interface('bmc.kepler.UpdateService.FirmwareInventory', {}, {
    Add = {'a{ss}a{ss}bqi', '', TAddReq, TAddRsp},
    Delete = {'a{ss}s', '', TDeleteReq, TDeleteRsp}
}, {})

return FirmwareInventory
