-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Chassis = {}

---@class Chassis.DeviceMaxCount
---@field DeviceName string
---@field MaximumNum integer
local TDeviceMaxCount = {}
TDeviceMaxCount.__index = TDeviceMaxCount
TDeviceMaxCount.group = {}

local function TDeviceMaxCount_from_obj(obj)
    return setmetatable(obj, TDeviceMaxCount)
end

function TDeviceMaxCount.new(DeviceName, MaximumNum)
    return TDeviceMaxCount_from_obj({DeviceName = DeviceName, MaximumNum = MaximumNum})
end
---@param obj Chassis.DeviceMaxCount
function TDeviceMaxCount:init_from_obj(obj)
    self.DeviceName = obj.DeviceName
    self.MaximumNum = obj.MaximumNum
end

function TDeviceMaxCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceMaxCount.group)
end

TDeviceMaxCount.from_obj = TDeviceMaxCount_from_obj

TDeviceMaxCount.proto_property = {'DeviceName', 'MaximumNum'}

TDeviceMaxCount.default = {'', 0}

TDeviceMaxCount.struct = {
    {name = 'DeviceName', is_array = false, struct = nil}, {name = 'MaximumNum', is_array = false, struct = nil}
}

function TDeviceMaxCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceName', self.DeviceName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'MaximumNum', self.MaximumNum, 'uint8', false, errs, need_convert)

    TDeviceMaxCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceMaxCount.proto_property, errs, need_convert)
    return self
end

function TDeviceMaxCount:unpack(_)
    return self.DeviceName, self.MaximumNum
end

Chassis.DeviceMaxCount = TDeviceMaxCount

---@class Chassis.TopologyConfigId
---@field TopologyConfigId integer
local TTopologyConfigId = {}
TTopologyConfigId.__index = TTopologyConfigId
TTopologyConfigId.group = {}

local function TTopologyConfigId_from_obj(obj)
    return setmetatable(obj, TTopologyConfigId)
end

function TTopologyConfigId.new(TopologyConfigId)
    return TTopologyConfigId_from_obj({TopologyConfigId = TopologyConfigId or 65535})
end
---@param obj Chassis.TopologyConfigId
function TTopologyConfigId:init_from_obj(obj)
    self.TopologyConfigId = obj.TopologyConfigId or 65535
end

function TTopologyConfigId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTopologyConfigId.group)
end

TTopologyConfigId.from_obj = TTopologyConfigId_from_obj

TTopologyConfigId.proto_property = {'TopologyConfigId'}

TTopologyConfigId.default = {0}

TTopologyConfigId.struct = {{name = 'TopologyConfigId', is_array = false, struct = nil}}

function TTopologyConfigId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TopologyConfigId', self.TopologyConfigId, 'uint16', true, errs, need_convert)

    TTopologyConfigId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTopologyConfigId.proto_property, errs, need_convert)
    return self
end

function TTopologyConfigId:unpack(_)
    return self.TopologyConfigId
end

Chassis.TopologyConfigId = TTopologyConfigId

---@class Chassis.DeviceSpecication
---@field DeviceSpecication Chassis.DeviceMaxCount[]
local TDeviceSpecication = {}
TDeviceSpecication.__index = TDeviceSpecication
TDeviceSpecication.group = {}

local function TDeviceSpecication_from_obj(obj)
    obj.DeviceSpecication = utils.from_obj(Chassis.DeviceMaxCount, obj.DeviceSpecication, true)
    return setmetatable(obj, TDeviceSpecication)
end

function TDeviceSpecication.new(DeviceSpecication)
    return TDeviceSpecication_from_obj({DeviceSpecication = DeviceSpecication})
end
---@param obj Chassis.DeviceSpecication
function TDeviceSpecication:init_from_obj(obj)
    self.DeviceSpecication = obj.DeviceSpecication
end

function TDeviceSpecication:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceSpecication.group)
end

TDeviceSpecication.from_obj = TDeviceSpecication_from_obj

TDeviceSpecication.proto_property = {'DeviceSpecication'}

TDeviceSpecication.default = {{}}

TDeviceSpecication.struct = {{name = 'DeviceSpecication', is_array = true, struct = Chassis.DeviceMaxCount.struct}}

function TDeviceSpecication:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.DeviceSpecication) do
        Chassis.DeviceMaxCount.new(v.DeviceName, v.MaximumNum):validate(prefix, errs, need_convert)
    end

    TDeviceSpecication:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceSpecication.proto_property, errs, need_convert)
    return self
end

function TDeviceSpecication:unpack(raw)
    return utils.unpack(raw, self.DeviceSpecication, true)
end

Chassis.DeviceSpecication = TDeviceSpecication

---@class Chassis.Location
---@field Location string
local TLocation = {}
TLocation.__index = TLocation
TLocation.group = {}

local function TLocation_from_obj(obj)
    return setmetatable(obj, TLocation)
end

function TLocation.new(Location)
    return TLocation_from_obj({Location = Location})
end
---@param obj Chassis.Location
function TLocation:init_from_obj(obj)
    self.Location = obj.Location
end

function TLocation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocation.group)
end

TLocation.from_obj = TLocation_from_obj

TLocation.proto_property = {'Location'}

TLocation.default = {''}

TLocation.struct = {{name = 'Location', is_array = false, struct = nil}}

function TLocation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Location', self.Location, 'string', false, errs, need_convert)

    TLocation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocation.proto_property, errs, need_convert)
    return self
end

function TLocation:unpack(_)
    return self.Location
end

Chassis.Location = TLocation

---@class Chassis.ChassisType
---@field ChassisType integer
local TChassisType = {}
TChassisType.__index = TChassisType
TChassisType.group = {}

local function TChassisType_from_obj(obj)
    return setmetatable(obj, TChassisType)
end

function TChassisType.new(ChassisType)
    return TChassisType_from_obj({ChassisType = ChassisType})
end
---@param obj Chassis.ChassisType
function TChassisType:init_from_obj(obj)
    self.ChassisType = obj.ChassisType
end

function TChassisType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChassisType.group)
end

TChassisType.from_obj = TChassisType_from_obj

TChassisType.proto_property = {'ChassisType'}

TChassisType.default = {0}

TChassisType.struct = {{name = 'ChassisType', is_array = false, struct = nil}}

function TChassisType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChassisType', self.ChassisType, 'uint8', true, errs, need_convert)

    TChassisType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChassisType.proto_property, errs, need_convert)
    return self
end

function TChassisType:unpack(_)
    return self.ChassisType
end

Chassis.ChassisType = TChassisType

---@class Chassis.UidButtonLongPressed
---@field UidButtonLongPressed integer
local TUidButtonLongPressed = {}
TUidButtonLongPressed.__index = TUidButtonLongPressed
TUidButtonLongPressed.group = {}

local function TUidButtonLongPressed_from_obj(obj)
    return setmetatable(obj, TUidButtonLongPressed)
end

function TUidButtonLongPressed.new(UidButtonLongPressed)
    return TUidButtonLongPressed_from_obj({UidButtonLongPressed = UidButtonLongPressed})
end
---@param obj Chassis.UidButtonLongPressed
function TUidButtonLongPressed:init_from_obj(obj)
    self.UidButtonLongPressed = obj.UidButtonLongPressed
end

function TUidButtonLongPressed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUidButtonLongPressed.group)
end

TUidButtonLongPressed.from_obj = TUidButtonLongPressed_from_obj

TUidButtonLongPressed.proto_property = {'UidButtonLongPressed'}

TUidButtonLongPressed.default = {0}

TUidButtonLongPressed.struct = {{name = 'UidButtonLongPressed', is_array = false, struct = nil}}

function TUidButtonLongPressed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UidButtonLongPressed', self.UidButtonLongPressed, 'uint8', true, errs, need_convert)

    TUidButtonLongPressed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUidButtonLongPressed.proto_property, errs, need_convert)
    return self
end

function TUidButtonLongPressed:unpack(_)
    return self.UidButtonLongPressed
end

Chassis.UidButtonLongPressed = TUidButtonLongPressed

---@class Chassis.UidButtonPressed
---@field UidButtonPressed integer
local TUidButtonPressed = {}
TUidButtonPressed.__index = TUidButtonPressed
TUidButtonPressed.group = {}

local function TUidButtonPressed_from_obj(obj)
    return setmetatable(obj, TUidButtonPressed)
end

function TUidButtonPressed.new(UidButtonPressed)
    return TUidButtonPressed_from_obj({UidButtonPressed = UidButtonPressed})
end
---@param obj Chassis.UidButtonPressed
function TUidButtonPressed:init_from_obj(obj)
    self.UidButtonPressed = obj.UidButtonPressed
end

function TUidButtonPressed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUidButtonPressed.group)
end

TUidButtonPressed.from_obj = TUidButtonPressed_from_obj

TUidButtonPressed.proto_property = {'UidButtonPressed'}

TUidButtonPressed.default = {0}

TUidButtonPressed.struct = {{name = 'UidButtonPressed', is_array = false, struct = nil}}

function TUidButtonPressed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UidButtonPressed', self.UidButtonPressed, 'uint8', true, errs, need_convert)

    TUidButtonPressed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUidButtonPressed.proto_property, errs, need_convert)
    return self
end

function TUidButtonPressed:unpack(_)
    return self.UidButtonPressed
end

Chassis.UidButtonPressed = TUidButtonPressed

---@class Chassis.IntrusionFlag
---@field IntrusionFlag integer
local TIntrusionFlag = {}
TIntrusionFlag.__index = TIntrusionFlag
TIntrusionFlag.group = {}

local function TIntrusionFlag_from_obj(obj)
    return setmetatable(obj, TIntrusionFlag)
end

function TIntrusionFlag.new(IntrusionFlag)
    return TIntrusionFlag_from_obj({IntrusionFlag = IntrusionFlag})
end
---@param obj Chassis.IntrusionFlag
function TIntrusionFlag:init_from_obj(obj)
    self.IntrusionFlag = obj.IntrusionFlag
end

function TIntrusionFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIntrusionFlag.group)
end

TIntrusionFlag.from_obj = TIntrusionFlag_from_obj

TIntrusionFlag.proto_property = {'IntrusionFlag'}

TIntrusionFlag.default = {0}

TIntrusionFlag.struct = {{name = 'IntrusionFlag', is_array = false, struct = nil}}

function TIntrusionFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IntrusionFlag', self.IntrusionFlag, 'uint8', true, errs, need_convert)

    TIntrusionFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIntrusionFlag.proto_property, errs, need_convert)
    return self
end

function TIntrusionFlag:unpack(_)
    return self.IntrusionFlag
end

Chassis.IntrusionFlag = TIntrusionFlag

---@class Chassis.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj Chassis.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

Chassis.Name = TName

Chassis.interface = mdb.register_interface('bmc.kepler.Chassis', {
    Name = {'s', nil, true, nil, false},
    IntrusionFlag = {'y', nil, true, nil, false},
    UidButtonPressed = {'y', nil, true, nil, false},
    UidButtonLongPressed = {'y', nil, true, nil, false},
    ChassisType = {'y', nil, true, nil, false},
    Location = {'s', nil, false, nil, false},
    DeviceSpecication = {'a(sy)', nil, true, nil, false},
    TopologyConfigId = {'q', {}, true, 65535, false}
}, {}, {})

return Chassis
