--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'power_mgmt.ipmi.ipmi_message'

local CT = enums.ChannelType

local PowerMgmtIpmiCmds = {}

PowerMgmtIpmiCmds.GetPowerSupplyInfo = {
    name = 'GetPowerSupplyInfo',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,1e]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x1e:1/unit:8, PsSelecto]=] ..
        [=[r:1/unit:8, PsParameter:1/unit:8, ReadOffset:1/uni]=] .. [=[t:8, Length:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ EndOfList:1/unit:8, Data/string>>]=],
    req = msg.GetPowerSupplyInfoReq,
    rsp = msg.GetPowerSupplyInfoRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PowerMgmtIpmiCmds.GetPowerSupplyVersion = {
    name = 'GetPowerSupplyVersion',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x90,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,70,01,09]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x70:1/unit:8, 0x01:1/un]=] .. [=[it:8, 0x09:1/unit:8, Reserved:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Data/string>>]=],
    req = msg.GetPowerSupplyVersionReq,
    rsp = msg.GetPowerSupplyVersionRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PowerMgmtIpmiCmds.SetPowerStatus = {
    name = 'SetPowerStatus',
    prio = types.Priority.OEM,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,2D]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x2D:1/unit:8, PsSelecto]=] ..
        [=[r:1/unit:8, PsParameter:1/unit:8, Flag:1/unit:8, O]=] .. [=[ffset:1/unit:8, Length:1/unit:8, Data/string>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetPowerStatusReq,
    rsp = msg.SetPowerStatusRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PowerMgmtIpmiCmds.GetThresholdSensorReadingVoltageInput = {
    name = 'GetThresholdSensorReadingVoltageInput',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,31,02,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x31:1/unit:8, 0x02:1/un]=] .. [=[it:8, 0x01:1/unit:8, DeviceId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reading:4/unit:8, 0x68:1/unit:8>>]=],
    req = msg.GetThresholdSensorReadingVoltageInputReq,
    rsp = msg.GetThresholdSensorReadingVoltageInputRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PowerMgmtIpmiCmds.GetThresholdSensorReadingVoltageOutput = {
    name = 'GetThresholdSensorReadingVoltageOutput',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,31,02,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x31:1/unit:8, 0x02:1/un]=] .. [=[it:8, 0x02:1/unit:8, DeviceId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reading:4/unit:8, 0x68:1/unit:8>>]=],
    req = msg.GetThresholdSensorReadingVoltageOutputReq,
    rsp = msg.GetThresholdSensorReadingVoltageOutputRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PowerMgmtIpmiCmds.GetThresholdSensorReadingCurrentInput = {
    name = 'GetThresholdSensorReadingCurrentInput',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,31,03,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x31:1/unit:8, 0x03:1/un]=] .. [=[it:8, 0x01:1/unit:8, DeviceId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reading:4/unit:8, 0x69:1/unit:8>>]=],
    req = msg.GetThresholdSensorReadingCurrentInputReq,
    rsp = msg.GetThresholdSensorReadingCurrentInputRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PowerMgmtIpmiCmds.GetThresholdSensorReadingCurrentOutput = {
    name = 'GetThresholdSensorReadingCurrentOutput',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,31,03,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x31:1/unit:8, 0x03:1/un]=] .. [=[it:8, 0x02:1/unit:8, DeviceId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reading:4/unit:8, 0x69:1/unit:8>>]=],
    req = msg.GetThresholdSensorReadingCurrentOutputReq,
    rsp = msg.GetThresholdSensorReadingCurrentOutputRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PowerMgmtIpmiCmds.GetThresholdSensorReadingPowerInput = {
    name = 'GetThresholdSensorReadingPowerInput',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,31,08,01]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x31:1/unit:8, 0x08:1/un]=] .. [=[it:8, 0x01:1/unit:8, DeviceId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reading:4/unit:8, 0x06:1/unit:8>>]=],
    req = msg.GetThresholdSensorReadingPowerInputReq,
    rsp = msg.GetThresholdSensorReadingPowerInputRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PowerMgmtIpmiCmds.GetThresholdSensorReadingPowerOutput = {
    name = 'GetThresholdSensorReadingPowerOutput',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,31,08,02]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x31:1/unit:8, 0x08:1/un]=] .. [=[it:8, 0x02:1/unit:8, DeviceId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ Reading:4/unit:8, 0x06:1/unit:8>>]=],
    req = msg.GetThresholdSensorReadingPowerOutputReq,
    rsp = msg.GetThresholdSensorReadingPowerOutputRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

PowerMgmtIpmiCmds.SetPsuFruConfig = {
    name = 'SetPsuFruConfig',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.Operator,
    privilege = privilege.PowerMgmt,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,5a,1d,00,02,00,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x5a:1/unit:8, 0x001d:2/]=] ..
        [=[unit:8, 0x0002:2/unit:8, 0x00:1/unit:8, ConfigValu]=] .. [=[e:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8>]=] .. [=[>]=],
    req = msg.SetPsuFruConfigReq,
    rsp = msg.SetPsuFruConfigRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Forbidden'
}

PowerMgmtIpmiCmds.GetPsuFruConfig = {
    name = 'GetPsuFruConfig',
    prio = types.Priority.Default,
    netfn = 0x30,
    cmd = 0x93,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[*,*,*,5b,1d,00,01,00,00]=],
    decode = [=[<<ManufactureId:3/unit:8, 0x5b:1/unit:8, 0x001d:2/]=] .. [=[unit:8, 0x0001:2/unit:8, 0x00:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, ManufactureId:3/unit:8,]=] .. [=[ ConfigValue:1/unit:8>>]=],
    req = msg.GetPsuFruConfigReq,
    rsp = msg.GetPsuFruConfigRsp,
    manufacturer = {0, 1},
    sysLockedPolicy = 'Allowed'
}

return PowerMgmtIpmiCmds
