--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetPsuFruConfig = {}

---@class PowerMgmtIpmiCmds.SetPsuFruConfigReq
---@field ManufactureId integer
---@field ConfigValue integer
local TSetPsuFruConfigReq = {}
TSetPsuFruConfigReq.__index = TSetPsuFruConfigReq
TSetPsuFruConfigReq.group = {}

local function TSetPsuFruConfigReq_from_obj(obj)
    return setmetatable(obj, TSetPsuFruConfigReq)
end

function TSetPsuFruConfigReq.new(ManufactureId, ConfigValue)
    return TSetPsuFruConfigReq_from_obj({ManufactureId = ManufactureId, ConfigValue = ConfigValue})
end
---@param obj PowerMgmtIpmiCmds.SetPsuFruConfigReq
function TSetPsuFruConfigReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.ConfigValue = obj.ConfigValue
end

function TSetPsuFruConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPsuFruConfigReq.group)
end

TSetPsuFruConfigReq.from_obj = TSetPsuFruConfigReq_from_obj

TSetPsuFruConfigReq.proto_property = {'ManufactureId', 'ConfigValue'}

TSetPsuFruConfigReq.default = {0, 0}

TSetPsuFruConfigReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'ConfigValue', is_array = false, struct = nil}
}

function TSetPsuFruConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'ConfigValue', self.ConfigValue, 'uint8', false, errs, need_convert)

    TSetPsuFruConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPsuFruConfigReq.proto_property, errs, need_convert)
    return self
end

function TSetPsuFruConfigReq:unpack(_)
    return self.ManufactureId, self.ConfigValue
end

SetPsuFruConfig.SetPsuFruConfigReq = TSetPsuFruConfigReq

---@class PowerMgmtIpmiCmds.SetPsuFruConfigRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetPsuFruConfigRsp = {}
TSetPsuFruConfigRsp.__index = TSetPsuFruConfigRsp
TSetPsuFruConfigRsp.group = {}

local function TSetPsuFruConfigRsp_from_obj(obj)
    return setmetatable(obj, TSetPsuFruConfigRsp)
end

function TSetPsuFruConfigRsp.new(CompletionCode, ManufactureId)
    return TSetPsuFruConfigRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj PowerMgmtIpmiCmds.SetPsuFruConfigRsp
function TSetPsuFruConfigRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetPsuFruConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPsuFruConfigRsp.group)
end

TSetPsuFruConfigRsp.from_obj = TSetPsuFruConfigRsp_from_obj

TSetPsuFruConfigRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetPsuFruConfigRsp.default = {0, 0}

TSetPsuFruConfigRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetPsuFruConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetPsuFruConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPsuFruConfigRsp.proto_property, errs, need_convert)
    return self
end

function TSetPsuFruConfigRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetPsuFruConfig.SetPsuFruConfigRsp = TSetPsuFruConfigRsp

return SetPsuFruConfig
