-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPsuSlot = {}

---@class MPsuSlot.FruSource
---@field FruSource integer
local TFruSource = {}
TFruSource.__index = TFruSource
TFruSource.group = {}

local function TFruSource_from_obj(obj)
    return setmetatable(obj, TFruSource)
end

function TFruSource.new(FruSource)
    return TFruSource_from_obj({FruSource = FruSource})
end
---@param obj MPsuSlot.FruSource
function TFruSource:init_from_obj(obj)
    self.FruSource = obj.FruSource
end

function TFruSource:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruSource.group)
end

TFruSource.from_obj = TFruSource_from_obj

TFruSource.proto_property = {'FruSource'}

TFruSource.default = {0}

TFruSource.struct = {{name = 'FruSource', is_array = false, struct = nil}}

function TFruSource:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruSource', self.FruSource, 'uint8', false, errs, need_convert)

    if self.FruSource ~= nil then
        validate.Enum(prefix .. 'FruSource', self.FruSource, '', {0, 1, 2}, errs, need_convert)
    end

    TFruSource:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruSource.proto_property, errs, need_convert)
    return self
end

function TFruSource:unpack(_)
    return self.FruSource
end

MPsuSlot.FruSource = TFruSource

---@class MPsuSlot.OutputState
---@field OutputState integer
local TOutputState = {}
TOutputState.__index = TOutputState
TOutputState.group = {}

local function TOutputState_from_obj(obj)
    return setmetatable(obj, TOutputState)
end

function TOutputState.new(OutputState)
    return TOutputState_from_obj({OutputState = OutputState})
end
---@param obj MPsuSlot.OutputState
function TOutputState:init_from_obj(obj)
    self.OutputState = obj.OutputState
end

function TOutputState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOutputState.group)
end

TOutputState.from_obj = TOutputState_from_obj

TOutputState.proto_property = {'OutputState'}

TOutputState.default = {0}

TOutputState.struct = {{name = 'OutputState', is_array = false, struct = nil}}

function TOutputState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputState', self.OutputState, 'uint8', false, errs, need_convert)

    TOutputState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOutputState.proto_property, errs, need_convert)
    return self
end

function TOutputState:unpack(_)
    return self.OutputState
end

MPsuSlot.OutputState = TOutputState

---@class MPsuSlot.FruChip
---@field FruChip integer[]
local TFruChip = {}
TFruChip.__index = TFruChip
TFruChip.group = {}

local function TFruChip_from_obj(obj)
    return setmetatable(obj, TFruChip)
end

function TFruChip.new(FruChip)
    return TFruChip_from_obj({FruChip = FruChip})
end
---@param obj MPsuSlot.FruChip
function TFruChip:init_from_obj(obj)
    self.FruChip = obj.FruChip
end

function TFruChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruChip.group)
end

TFruChip.from_obj = TFruChip_from_obj

TFruChip.proto_property = {'FruChip'}

TFruChip.default = {{}}

TFruChip.struct = {{name = 'FruChip', is_array = true, struct = nil}}

function TFruChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'FruChip', self.FruChip, 'uint8', false, errs, need_convert)

    TFruChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruChip.proto_property, errs, need_convert)
    return self
end

function TFruChip:unpack(_)
    return self.FruChip
end

MPsuSlot.FruChip = TFruChip

---@class MPsuSlot.PsuChip
---@field PsuChip integer[]
local TPsuChip = {}
TPsuChip.__index = TPsuChip
TPsuChip.group = {}

local function TPsuChip_from_obj(obj)
    return setmetatable(obj, TPsuChip)
end

function TPsuChip.new(PsuChip)
    return TPsuChip_from_obj({PsuChip = PsuChip})
end
---@param obj MPsuSlot.PsuChip
function TPsuChip:init_from_obj(obj)
    self.PsuChip = obj.PsuChip
end

function TPsuChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPsuChip.group)
end

TPsuChip.from_obj = TPsuChip_from_obj

TPsuChip.proto_property = {'PsuChip'}

TPsuChip.default = {{}}

TPsuChip.struct = {{name = 'PsuChip', is_array = true, struct = nil}}

function TPsuChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'PsuChip', self.PsuChip, 'uint8', false, errs, need_convert)

    TPsuChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPsuChip.proto_property, errs, need_convert)
    return self
end

function TPsuChip:unpack(_)
    return self.PsuChip
end

MPsuSlot.PsuChip = TPsuChip

---@class MPsuSlot.I2cChip
---@field I2cChip integer[]
local TI2cChip = {}
TI2cChip.__index = TI2cChip
TI2cChip.group = {}

local function TI2cChip_from_obj(obj)
    return setmetatable(obj, TI2cChip)
end

function TI2cChip.new(I2cChip)
    return TI2cChip_from_obj({I2cChip = I2cChip})
end
---@param obj MPsuSlot.I2cChip
function TI2cChip:init_from_obj(obj)
    self.I2cChip = obj.I2cChip
end

function TI2cChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TI2cChip.group)
end

TI2cChip.from_obj = TI2cChip_from_obj

TI2cChip.proto_property = {'I2cChip'}

TI2cChip.default = {{}}

TI2cChip.struct = {{name = 'I2cChip', is_array = true, struct = nil}}

function TI2cChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'I2cChip', self.I2cChip, 'uint8', false, errs, need_convert)

    TI2cChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TI2cChip.proto_property, errs, need_convert)
    return self
end

function TI2cChip:unpack(_)
    return self.I2cChip
end

MPsuSlot.I2cChip = TI2cChip

---@class MPsuSlot.Presence
---@field Presence integer
local TPresence = {}
TPresence.__index = TPresence
TPresence.group = {}

local function TPresence_from_obj(obj)
    return setmetatable(obj, TPresence)
end

function TPresence.new(Presence)
    return TPresence_from_obj({Presence = Presence or 255})
end
---@param obj MPsuSlot.Presence
function TPresence:init_from_obj(obj)
    self.Presence = obj.Presence or 255
end

function TPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPresence.group)
end

TPresence.from_obj = TPresence_from_obj

TPresence.proto_property = {'Presence'}

TPresence.default = {0}

TPresence.struct = {{name = 'Presence', is_array = false, struct = nil}}

function TPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Presence', self.Presence, 'uint8', false, errs, need_convert)

    TPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPresence.proto_property, errs, need_convert)
    return self
end

function TPresence:unpack(_)
    return self.Presence
end

MPsuSlot.Presence = TPresence

---@class MPsuSlot.FruI2cAddr
---@field FruI2cAddr integer
local TFruI2cAddr = {}
TFruI2cAddr.__index = TFruI2cAddr
TFruI2cAddr.group = {}

local function TFruI2cAddr_from_obj(obj)
    return setmetatable(obj, TFruI2cAddr)
end

function TFruI2cAddr.new(FruI2cAddr)
    return TFruI2cAddr_from_obj({FruI2cAddr = FruI2cAddr})
end
---@param obj MPsuSlot.FruI2cAddr
function TFruI2cAddr:init_from_obj(obj)
    self.FruI2cAddr = obj.FruI2cAddr
end

function TFruI2cAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruI2cAddr.group)
end

TFruI2cAddr.from_obj = TFruI2cAddr_from_obj

TFruI2cAddr.proto_property = {'FruI2cAddr'}

TFruI2cAddr.default = {0}

TFruI2cAddr.struct = {{name = 'FruI2cAddr', is_array = false, struct = nil}}

function TFruI2cAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruI2cAddr', self.FruI2cAddr, 'uint8', false, errs, need_convert)

    TFruI2cAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruI2cAddr.proto_property, errs, need_convert)
    return self
end

function TFruI2cAddr:unpack(_)
    return self.FruI2cAddr
end

MPsuSlot.FruI2cAddr = TFruI2cAddr

---@class MPsuSlot.SlotI2cAddr
---@field SlotI2cAddr integer
local TSlotI2cAddr = {}
TSlotI2cAddr.__index = TSlotI2cAddr
TSlotI2cAddr.group = {}

local function TSlotI2cAddr_from_obj(obj)
    return setmetatable(obj, TSlotI2cAddr)
end

function TSlotI2cAddr.new(SlotI2cAddr)
    return TSlotI2cAddr_from_obj({SlotI2cAddr = SlotI2cAddr})
end
---@param obj MPsuSlot.SlotI2cAddr
function TSlotI2cAddr:init_from_obj(obj)
    self.SlotI2cAddr = obj.SlotI2cAddr
end

function TSlotI2cAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotI2cAddr.group)
end

TSlotI2cAddr.from_obj = TSlotI2cAddr_from_obj

TSlotI2cAddr.proto_property = {'SlotI2cAddr'}

TSlotI2cAddr.default = {0}

TSlotI2cAddr.struct = {{name = 'SlotI2cAddr', is_array = false, struct = nil}}

function TSlotI2cAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotI2cAddr', self.SlotI2cAddr, 'uint8', false, errs, need_convert)

    TSlotI2cAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotI2cAddr.proto_property, errs, need_convert)
    return self
end

function TSlotI2cAddr:unpack(_)
    return self.SlotI2cAddr
end

MPsuSlot.SlotI2cAddr = TSlotI2cAddr

---@class MPsuSlot.SlotNumber
---@field SlotNumber integer
local TSlotNumber = {}
TSlotNumber.__index = TSlotNumber
TSlotNumber.group = {}

local function TSlotNumber_from_obj(obj)
    return setmetatable(obj, TSlotNumber)
end

function TSlotNumber.new(SlotNumber)
    return TSlotNumber_from_obj({SlotNumber = SlotNumber})
end
---@param obj MPsuSlot.SlotNumber
function TSlotNumber:init_from_obj(obj)
    self.SlotNumber = obj.SlotNumber
end

function TSlotNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotNumber.group)
end

TSlotNumber.from_obj = TSlotNumber_from_obj

TSlotNumber.proto_property = {'SlotNumber'}

TSlotNumber.default = {0}

TSlotNumber.struct = {{name = 'SlotNumber', is_array = false, struct = nil}}

function TSlotNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SlotNumber', self.SlotNumber, 'uint8', false, errs, need_convert)

    TSlotNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotNumber.proto_property, errs, need_convert)
    return self
end

function TSlotNumber:unpack(_)
    return self.SlotNumber
end

MPsuSlot.SlotNumber = TSlotNumber

return MPsuSlot
