-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPowerConfiguration = {}

---@class MPowerConfiguration.SinglePsuSupport
---@field SinglePsuSupport integer
local TSinglePsuSupport = {}
TSinglePsuSupport.__index = TSinglePsuSupport
TSinglePsuSupport.group = {}

local function TSinglePsuSupport_from_obj(obj)
    return setmetatable(obj, TSinglePsuSupport)
end

function TSinglePsuSupport.new(SinglePsuSupport)
    return TSinglePsuSupport_from_obj({SinglePsuSupport = SinglePsuSupport or 0})
end
---@param obj MPowerConfiguration.SinglePsuSupport
function TSinglePsuSupport:init_from_obj(obj)
    self.SinglePsuSupport = obj.SinglePsuSupport or 0
end

function TSinglePsuSupport:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSinglePsuSupport.group)
end

TSinglePsuSupport.from_obj = TSinglePsuSupport_from_obj

TSinglePsuSupport.proto_property = {'SinglePsuSupport'}

TSinglePsuSupport.default = {0}

TSinglePsuSupport.struct = {{name = 'SinglePsuSupport', is_array = false, struct = nil}}

function TSinglePsuSupport:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SinglePsuSupport', self.SinglePsuSupport, 'uint8', false, errs, need_convert)

    TSinglePsuSupport:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSinglePsuSupport.proto_property, errs, need_convert)
    return self
end

function TSinglePsuSupport:unpack(_)
    return self.SinglePsuSupport
end

MPowerConfiguration.SinglePsuSupport = TSinglePsuSupport

return MPowerConfiguration
