-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local one_power_class_types = require 'class.types.OnePower'
local power_converter_class_types = require 'class.types.PowerConverter'
local psu_slot_class_types = require 'class.types.PsuSlot'
local aclost_record_table_class_types = require 'class.types.AclostRecordTable'
local power_configuration_class_types = require 'class.types.PowerConfiguration'
local system_power_class_types = require 'class.types.SystemPower'
local power_supplies_intf_types = require 'power_mgmt.json_types.PowerSupplies'
local properties_intf_types = require 'power_mgmt.json_types.Properties'
local one_power_intf_types = require 'power_mgmt.json_types.OnePower'
local metrics_intf_types = require 'power_mgmt.json_types.Metrics'
local temperatures_intf_types = require 'power_mgmt.json_types.Temperatures'
local status_intf_types = require 'power_mgmt.json_types.Status'
local metric_intf_types = require 'power_mgmt.json_types.Metric'
local black_box_intf_types = require 'power_mgmt.json_types.BlackBox'
local manufacture_intf_types = require 'power_mgmt.json_types.Manufacture'

local PowerSupplies = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupplies'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupplies'] = {
            ['SetPsusFanMinPWM'] = {
                ['privilege'] = {'PowerMgmt'},
                ['description'] = '设置所有psu风扇最低转速（如果设置的最低转速高于电源风扇控制的转速时才生效）',
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '所有psu风扇的转速百分比',
                        ['param'] = 'FanMinPWM'
                    }
                },
                ['rsp'] = {}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/PowerSubsystem/PowerSupplies'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupplies'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['methods'] = {['SetPsusFanMinPWM'] = privilege.PowerMgmt}},
            ['interface_types'] = power_supplies_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local OnePower = {
    ['table_name'] = 't_onepower',
    ['prop_configs'] = {
        ['PhysicalInterface'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = one_power_class_types.PhysicalInterface
        },
        ['RefFrudata'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.FrudataService.Frudata',
            ['validator'] = one_power_class_types.RefFrudata
        },
        ['UnsupportedProperties'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String[]',
            ['validator'] = one_power_class_types.UnsupportedProperties
        },
        ['AlarmStatus'] = {['usage'] = {}, ['baseType'] = 'U32', ['validator'] = one_power_class_types.AlarmStatus},
        ['PreAlarmStatus'] = {
            ['usage'] = {},
            ['baseType'] = 'U32',
            ['validator'] = one_power_class_types.PreAlarmStatus
        },
        ['RefSMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = one_power_class_types.RefSMCChip
        }
    },
    ['default_props'] = {
        ['PhysicalInterface'] = one_power_class_types.PhysicalInterface.default[1],
        ['RefFrudata'] = one_power_class_types.RefFrudata.default[1],
        ['UnsupportedProperties'] = one_power_class_types.UnsupportedProperties.default[1],
        ['AlarmStatus'] = one_power_class_types.AlarmStatus.default[1],
        ['PreAlarmStatus'] = one_power_class_types.PreAlarmStatus.default[1],
        ['RefSMCChip'] = one_power_class_types.RefSMCChip.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.PowerMgmt.OnePower'] = {
            ['SlotNumber'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '槽位号',
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['validator'] = one_power_intf_types.SlotNumber
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '厂商',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Manufacturer
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '电源型号',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Model
            },
            ['PowerSupplyType'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '电源模块的供电类型，0:DC; 1:AC; 2: ACorDC; 3: Unknown',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.PowerSupplyType
            },
            ['Presence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '在位状态',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Presence
            },
            ['PowerSupplyChannel'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '电源供电电路，0:主路  1:备路',
                ['validator'] = one_power_intf_types.PowerSupplyChannel
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '序列号',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.SerialNumber
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '部件编码',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.PartNumber
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '电源固件版本',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.FirmwareVersion
            },
            ['Protocol'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Protocol
            },
            ['DeviceLocator'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '物理位置',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.DeviceLocator
            },
            ['ProductionDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '生产日期',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.ProductionDate
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '容器信息',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Position
            },
            ['DMTFPowerSupplyType'] = {
                ['baseType'] = 'U8',
                ['enum'] = {1, 2, 3, 4, 5, 6, 7, 8},
                ['readOnly'] = true,
                ['description'] = 'DMTF电源类型: 1 Other;2 Unknown;3 Linear; 4 Switching; 5 Battery; 6 UPS; 7 Converter; 8 Regulator',
                ['usage'] = {'CSR'},
                ['default'] = 4,
                ['validator'] = one_power_intf_types.DMTFPowerSupplyType
            },
            ['SourceType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '功率读数来源，0：chip（功率传感器芯片，如INA220）; 1：PSU（电源MCU）',
                ['usage'] = {'CSR'},
                ['default'] = 1,
                ['validator'] = one_power_intf_types.SourceType
            },
            ['IsPartOfSysPower'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '是否参与整机功耗计算,true:功耗纳入整机功耗计算,false:功耗不纳入整机功耗计算',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.IsPartOfSysPower
            },
            ['WorkMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '单个电源主备工作模式（主用：Enabled，备用：StandbySpare）',
                ['validator'] = one_power_intf_types.WorkMode
            },
            ['TotalRunningHours'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '总运行时间',
                ['validator'] = one_power_intf_types.TotalRunningHours
            },
            ['RedundancyGroupId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电源冗余组ID，非0值代表此电源冗余，0值代表电源不是冗余电源组的一员',
                ['validator'] = one_power_intf_types.RedundancyGroupId
            },
            ['InputVoltageType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '交直流模式 0:DC; 1:AC',
                ['validator'] = one_power_intf_types.InputVoltageType
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Metrics'] = {
            ['OutputPowerWatts'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '单电源输出功率',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.OutputPowerWatts
            },
            ['InputPowerWatts'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '单电源输入功率',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.InputPowerWatts
            },
            ['InputVoltage'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '输入电压',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.InputVoltage
            },
            ['OutputVoltage'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '输出电压',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.OutputVoltage
            },
            ['InputCurrentAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '输入电流',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.InputCurrentAmps
            },
            ['OutputCurrentAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '输出电流',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.OutputCurrentAmps
            },
            ['Rate'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '额定功率',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.Rate
            },
            ['RatedCurrentAmps'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '额定电流',
                ['validator'] = metrics_intf_types.RatedCurrentAmps
            },
            ['InputFrequencyHz'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '电源频率，交流显示频率 直流显示为0',
                ['validator'] = metrics_intf_types.InputFrequencyHz
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Temperatures'] = {
            ['EnvTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '单个电源的环境温度',
                ['usage'] = {'CSR'},
                ['validator'] = temperatures_intf_types.EnvTemperatureCelsius
            },
            ['PrimaryChipTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '电源内部器件温度（原边）',
                ['usage'] = {'CSR'},
                ['validator'] = temperatures_intf_types.PrimaryChipTemperatureCelsius
            },
            ['SecondaryChipTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '电源内部器件温度（副边）',
                ['usage'] = {'CSR'},
                ['validator'] = temperatures_intf_types.SecondaryChipTemperatureCelsius
            },
            ['InletTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '进风口温度',
                ['validator'] = temperatures_intf_types.InletTemperatureCelsius
            },
            ['InnerTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '出风口温度',
                ['validator'] = temperatures_intf_types.InnerTemperatureCelsius
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Status'] = {
            ['OutputState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电源电压输出状态（0为异常）',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.OutputState
            },
            ['CommunicationStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '电源通信状态，0：正常，1：故障',
                ['usage'] = {'SHM'},
                ['validator'] = status_intf_types.CommunicationStatus
            },
            ['Failure'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电源故障 0:无故障; 1:有故障',
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.Failure
            },
            ['Fan1Fault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '风扇1故障 0:无故障; 1:有故障(pmbus 只有一个风扇状态，pmbus8100 区分Fan1/2)',
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.Fan1Fault
            },
            ['Fan2Fault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '风扇2故障 0:无故障; 1:有故障',
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.Fan2Fault
            },
            ['FanFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '风扇状态（bit7:Fan1_Fault, bit5:Fan1_Warning, bit3:Fan1_Speed_Override）',
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.FanFault
            },
            ['InputVoltageFault'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 32768,
                ['description'] = '电压输入状态（bit7:Vin_Ov_Fault, bit6:Vin_Ov_Warning, bit5:Vin_Uv_Warning, bit4:Vin_Uv_Fault），无效值32768，EVENT不处理',
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.InputVoltageFault
            },
            ['LossOfInput'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '输入故障 0:无故障; 1:有故障',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.LossOfInput
            },
            ['OutputCurrentFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电流输出状态（bit7:Iout_Oc_Fault, bit5:Iout_Oc_Warning）',
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.OutputCurrentFault
            },
            ['OutputVoltageFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电压输出状态（bit7:Vout_Ov_Fault, bit6:Vout_Ov_Warning, bit5:Vout_Uv_Warning, bit4:Vout_Uv_Fault）',
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.OutputVoltageFault
            },
            ['OverTemperature'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '过温故障 0:无故障; 1:有故障',
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.OverTemperature
            },
            ['SleepMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '电源休眠模式(Normal,DeepSleep)',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.SleepMode
            },
            ['DeepSleepEnabled'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电源深度休眠使能(供告警使用) 0:未使能, 1:使能',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.DeepSleepEnabled
            },
            ['InputVoltageStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['enum'] = {0, 1, 2, 3},
                ['description'] = '输入电压过欠压、掉电状态，0x00：表示正常(默认)；0x01：表示过压；0x02：表示欠压；0x03：表示掉电；',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.InputVoltageStatus
            },
            ['ScanStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电源信息采集任务执行情况（bit0：电源功率轮询，bit1：电源输入/输出 电流/电压查询，bit2：电源模式查询）0表示该属性未获取过，1表示获取过',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.ScanStatus
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['description'] = '电源模块状态',
                ['validator'] = status_intf_types.Health
            },
            ['IsUpgrading'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '电源升级标识(false:未升级，true:升级中）',
                ['validator'] = status_intf_types.IsUpgrading
            },
            ['NormalAndRedundancySupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '是否支持N+R(true:支持，false:不支持)',
                ['validator'] = status_intf_types.NormalAndRedundancySupported
            }
        },
        ['bmc.kepler.Metric'] = {},
        ['bmc.kepler.Debug.BlackBox'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.PowerMgmt.OnePower'] = {
            ['SetPowerWorkMode'] = {
                ['description'] = '设置电源工作模式',
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '电源工作模式，1：设置为备用，0：设置为主用',
                        ['param'] = 'PowerWorkMode'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '命令执行结果，0：设置成功，1：设置失败',
                        ['param'] = 'CmdResult'
                    }
                },
                ['privilege'] = {'PowerMgmt'}
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Status'] = {
            ['SetSleepMode'] = {
                ['description'] = '设置电源休眠模式',
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '电源休眠模式：Normal或DeepSleep',
                        ['param'] = 'SleepMode'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '命令执行结果，0：设置成功，1：设置失败',
                        ['param'] = 'CmdResult'
                    }
                },
                ['privilege'] = {'PowerMgmt'}
            }
        },
        ['bmc.kepler.Metric'] = {
            ['GetData'] = {
                ['description'] = '根据MetricName获取采集项数据',
                ['req'] = {{['baseType'] = 'String[]', ['description'] = '采集项名称', ['param'] = 'MetricName'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/DataCollectionItem'},
                        ['description'] = '采集项数据',
                        ['param'] = 'Val'
                    }
                }
            },
            ['GetItems'] = {
                ['description'] = '获取采集项描述信息',
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['description'] = '采集主体名称', ['param'] = 'Component'}, {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/TagProp'},
                        ['description'] = '分类信息',
                        ['param'] = 'Classification'
                    }, {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/TagProp'},
                        ['description'] = '标识信息',
                        ['param'] = 'Identification'
                    }, {['baseType'] = 'String[]', ['description'] = '采集项名称', ['param'] = 'MetricName'}
                }
            },
            ['SynDataAcquisitionEnable'] = {
                ['description'] = '将数据采集开关同步到业务组件',
                ['req'] = {{['baseType'] = 'U8', ['description'] = '数据采集开关', ['param'] = 'Enabled'}},
                ['rsp'] = {}
            }
        },
        ['bmc.kepler.Debug.BlackBox'] = {
            ['DumpPsuBlackbox'] = {
                ['description'] = '收集电源黑匣子日志，异步则通过TaskId返回结果',
                ['rsp'] = {{['baseType'] = 'U32', ['description'] = '任务Id', ['param'] = 'TaskId'}},
                ['privilege'] = {'ReadOnly'}
            }
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['CollectSignal'] = {
                {['baseType'] = 'String', ['param'] = 'MetricName'}, {['baseType'] = 'String', ['param'] = 'TagPath'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/PowerMgmt/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.PowerMgmt.OnePower'] = {
            ['property_defaults'] = {
                ['SlotNumber'] = 0,
                ['Manufacturer'] = one_power_intf_types.Manufacturer.default[1],
                ['Model'] = one_power_intf_types.Model.default[1],
                ['PowerSupplyType'] = 0,
                ['Presence'] = 0,
                ['PowerSupplyChannel'] = 0,
                ['SerialNumber'] = one_power_intf_types.SerialNumber.default[1],
                ['PartNumber'] = one_power_intf_types.PartNumber.default[1],
                ['FirmwareVersion'] = one_power_intf_types.FirmwareVersion.default[1],
                ['Protocol'] = one_power_intf_types.Protocol.default[1],
                ['DeviceLocator'] = one_power_intf_types.DeviceLocator.default[1],
                ['ProductionDate'] = one_power_intf_types.ProductionDate.default[1],
                ['Position'] = one_power_intf_types.Position.default[1],
                ['DMTFPowerSupplyType'] = 4,
                ['SourceType'] = 1,
                ['IsPartOfSysPower'] = true,
                ['WorkMode'] = one_power_intf_types.WorkMode.default[1],
                ['TotalRunningHours'] = one_power_intf_types.TotalRunningHours.default[1],
                ['RedundancyGroupId'] = one_power_intf_types.RedundancyGroupId.default[1],
                ['InputVoltageType'] = one_power_intf_types.InputVoltageType.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['SetPowerWorkMode'] = privilege.PowerMgmt}},
            ['interface_types'] = one_power_intf_types
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Metrics'] = {
            ['property_defaults'] = {
                ['OutputPowerWatts'] = metrics_intf_types.OutputPowerWatts.default[1],
                ['InputPowerWatts'] = metrics_intf_types.InputPowerWatts.default[1],
                ['InputVoltage'] = metrics_intf_types.InputVoltage.default[1],
                ['OutputVoltage'] = metrics_intf_types.OutputVoltage.default[1],
                ['InputCurrentAmps'] = metrics_intf_types.InputCurrentAmps.default[1],
                ['OutputCurrentAmps'] = metrics_intf_types.OutputCurrentAmps.default[1],
                ['Rate'] = metrics_intf_types.Rate.default[1],
                ['RatedCurrentAmps'] = metrics_intf_types.RatedCurrentAmps.default[1],
                ['InputFrequencyHz'] = metrics_intf_types.InputFrequencyHz.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metrics_intf_types
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Temperatures'] = {
            ['property_defaults'] = {
                ['EnvTemperatureCelsius'] = temperatures_intf_types.EnvTemperatureCelsius.default[1],
                ['PrimaryChipTemperatureCelsius'] = temperatures_intf_types.PrimaryChipTemperatureCelsius.default[1],
                ['SecondaryChipTemperatureCelsius'] = temperatures_intf_types.SecondaryChipTemperatureCelsius.default[1],
                ['InletTemperatureCelsius'] = temperatures_intf_types.InletTemperatureCelsius.default[1],
                ['InnerTemperatureCelsius'] = temperatures_intf_types.InnerTemperatureCelsius.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = temperatures_intf_types
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Status'] = {
            ['property_defaults'] = {
                ['OutputState'] = status_intf_types.OutputState.default[1],
                ['CommunicationStatus'] = status_intf_types.CommunicationStatus.default[1],
                ['Failure'] = status_intf_types.Failure.default[1],
                ['Fan1Fault'] = status_intf_types.Fan1Fault.default[1],
                ['Fan2Fault'] = status_intf_types.Fan2Fault.default[1],
                ['FanFault'] = status_intf_types.FanFault.default[1],
                ['InputVoltageFault'] = 32768,
                ['LossOfInput'] = status_intf_types.LossOfInput.default[1],
                ['OutputCurrentFault'] = status_intf_types.OutputCurrentFault.default[1],
                ['OutputVoltageFault'] = status_intf_types.OutputVoltageFault.default[1],
                ['OverTemperature'] = status_intf_types.OverTemperature.default[1],
                ['SleepMode'] = status_intf_types.SleepMode.default[1],
                ['DeepSleepEnabled'] = status_intf_types.DeepSleepEnabled.default[1],
                ['InputVoltageStatus'] = status_intf_types.InputVoltageStatus.default[1],
                ['ScanStatus'] = status_intf_types.ScanStatus.default[1],
                ['Health'] = 255,
                ['IsUpgrading'] = status_intf_types.IsUpgrading.default[1],
                ['NormalAndRedundancySupported'] = status_intf_types.NormalAndRedundancySupported.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['SetSleepMode'] = privilege.PowerMgmt}},
            ['interface_types'] = status_intf_types
        },
        ['bmc.kepler.Metric'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metric_intf_types
        },
        ['bmc.kepler.Debug.BlackBox'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['DumpPsuBlackbox'] = privilege.ReadOnly}},
            ['interface_types'] = black_box_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PowerConverter = {
    ['prop_configs'] = {
        ['PhysicalInterface'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = power_converter_class_types.PhysicalInterface
        },
        ['RefFrudata'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.FrudataService.Frudata',
            ['validator'] = power_converter_class_types.RefFrudata
        },
        ['UnsupportedProperties'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String[]',
            ['validator'] = power_converter_class_types.UnsupportedProperties
        },
        ['AlarmStatus'] = {
            ['usage'] = {},
            ['baseType'] = 'U32',
            ['validator'] = power_converter_class_types.AlarmStatus
        },
        ['PreAlarmStatus'] = {
            ['usage'] = {},
            ['baseType'] = 'U32',
            ['validator'] = power_converter_class_types.PreAlarmStatus
        },
        ['RefSMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = power_converter_class_types.RefSMCChip
        }
    },
    ['default_props'] = {
        ['PhysicalInterface'] = power_converter_class_types.PhysicalInterface.default[1],
        ['RefFrudata'] = power_converter_class_types.RefFrudata.default[1],
        ['UnsupportedProperties'] = power_converter_class_types.UnsupportedProperties.default[1],
        ['AlarmStatus'] = power_converter_class_types.AlarmStatus.default[1],
        ['PreAlarmStatus'] = power_converter_class_types.PreAlarmStatus.default[1],
        ['RefSMCChip'] = power_converter_class_types.RefSMCChip.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.PowerMgmt.OnePower'] = {
            ['SlotNumber'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '槽位号',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.SlotNumber
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '厂商',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Manufacturer
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '电源型号',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Model
            },
            ['PowerSupplyType'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '电源模块的供电类型，0:DC; 1:AC; 2: ACorDC; 3: Unknown',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.PowerSupplyType
            },
            ['Presence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '在位状态',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Presence
            },
            ['PowerSupplyChannel'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['description'] = '电源供电电路，0:主路  1:备路',
                ['validator'] = one_power_intf_types.PowerSupplyChannel
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '序列号',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.SerialNumber
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '部件编码',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.PartNumber
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '电源固件版本',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.FirmwareVersion
            },
            ['Protocol'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Protocol
            },
            ['DeviceLocator'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '物理位置',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.DeviceLocator
            },
            ['ProductionDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '生产日期',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.ProductionDate
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '容器信息',
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Position
            },
            ['WorkMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '单个电源主备工作模式（主用：Enabled，备用：StandbySpare）',
                ['validator'] = one_power_intf_types.WorkMode
            },
            ['TotalRunningHours'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '总运行时间',
                ['validator'] = one_power_intf_types.TotalRunningHours
            },
            ['RedundancyGroupId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电源冗余组ID，非0值代表此电源冗余，0值代表电源不是冗余电源组的一员',
                ['validator'] = one_power_intf_types.RedundancyGroupId
            },
            ['InputVoltageType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '交直流模式 0:DC; 1:AC',
                ['validator'] = one_power_intf_types.InputVoltageType
            },
            ['DMTFPowerSupplyType'] = {
                ['baseType'] = 'U8',
                ['enum'] = {1, 2, 3, 4, 5, 6, 7, 8},
                ['readOnly'] = true,
                ['description'] = 'DMTF电源类型: 1 Other;2 Unknown;3 Linear; 4 Switching; 5 Battery; 6 UPS; 7 Converter; 8 Regulator',
                ['validator'] = one_power_intf_types.DMTFPowerSupplyType
            },
            ['SourceType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '功率读数来源，0：chip（功率传感器芯片，如INA220）; 1：PSU（电源MCU）',
                ['validator'] = one_power_intf_types.SourceType
            },
            ['IsPartOfSysPower'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '是否参与整机功耗计算,true:功耗纳入整机功耗计算,false:功耗不纳入整机功耗计算',
                ['validator'] = one_power_intf_types.IsPartOfSysPower
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Metrics'] = {
            ['OutputPowerWatts'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '单电源输出功率',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.OutputPowerWatts
            },
            ['InputPowerWatts'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '单电源输入功率',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.InputPowerWatts
            },
            ['InputVoltage'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '输入电压',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.InputVoltage
            },
            ['OutputVoltage'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '输出电压',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.OutputVoltage
            },
            ['InputCurrentAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '输入电流',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.InputCurrentAmps
            },
            ['OutputCurrentAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '输出电流',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.OutputCurrentAmps
            },
            ['Rate'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '额定功率',
                ['usage'] = {'CSR'},
                ['validator'] = metrics_intf_types.Rate
            },
            ['RatedCurrentAmps'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '额定电流',
                ['validator'] = metrics_intf_types.RatedCurrentAmps
            },
            ['InputFrequencyHz'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '电源频率，交流显示频率 直流显示为0',
                ['validator'] = metrics_intf_types.InputFrequencyHz
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Temperatures'] = {
            ['EnvTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '单个电源的环境温度',
                ['usage'] = {'CSR'},
                ['validator'] = temperatures_intf_types.EnvTemperatureCelsius
            },
            ['PrimaryChipTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '电源内部器件温度（原边）',
                ['usage'] = {'CSR'},
                ['validator'] = temperatures_intf_types.PrimaryChipTemperatureCelsius
            },
            ['SecondaryChipTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '电源内部器件温度（副边）',
                ['usage'] = {'CSR'},
                ['validator'] = temperatures_intf_types.SecondaryChipTemperatureCelsius
            },
            ['InletTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '进风口温度',
                ['validator'] = temperatures_intf_types.InletTemperatureCelsius
            },
            ['InnerTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['volatile'] = true, ['emitsChangedSignal'] = 'true'},
                ['description'] = '出风口温度',
                ['validator'] = temperatures_intf_types.InnerTemperatureCelsius
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Status'] = {
            ['OutputState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电源电压输出状态（0为异常）',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.OutputState
            },
            ['CommunicationStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['description'] = '电源通信状态，0：正常，1：故障',
                ['validator'] = status_intf_types.CommunicationStatus
            },
            ['Failure'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电源故障 0:无故障; 1:有故障',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.Failure
            },
            ['Fan1Fault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '风扇1故障 0:无故障; 1:有故障(pmbus 只有一个风扇状态，pmbus8100 区分Fan1/2)',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.Fan1Fault
            },
            ['Fan2Fault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '风扇2故障 0:无故障; 1:有故障',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.Fan2Fault
            },
            ['FanFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '风扇状态（bit7:Fan1_Fault, bit5:Fan1_Warning, bit3:Fan1_Speed_Override）',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.FanFault
            },
            ['InputVoltageFault'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 32768,
                ['description'] = '电压输入状态（bit7:Vin_Ov_Fault, bit6:Vin_Ov_Warning, bit5:Vin_Uv_Warning, bit4:Vin_Uv_Fault），无效值32768，EVENT不处理',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.InputVoltageFault
            },
            ['LossOfInput'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '输入故障 0:无故障; 1:有故障',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.LossOfInput
            },
            ['OutputCurrentFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电流输出状态（bit7:Iout_Oc_Fault, bit5:Iout_Oc_Warning）',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.OutputCurrentFault
            },
            ['OutputVoltageFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电压输出状态（bit7:Vout_Ov_Fault, bit6:Vout_Ov_Warning, bit5:Vout_Uv_Warning, bit4:Vout_Uv_Fault）',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.OutputVoltageFault
            },
            ['OverTemperature'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '过温故障 0:无故障; 1:有故障',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.OverTemperature
            },
            ['SleepMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '电源休眠模式(Normal,DeepSleep)',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.SleepMode
            },
            ['DeepSleepEnabled'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电源深度休眠使能(供告警使用) 0:未使能, 1:使能',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.DeepSleepEnabled
            },
            ['InputVoltageStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['enum'] = {0, 1, 2, 3},
                ['description'] = '输入电压过欠压、掉电状态，0x00：表示正常(默认)；0x01：表示过压；0x02：表示欠压；0x03：表示掉电；',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.InputVoltageStatus
            },
            ['ScanStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['description'] = '电源信息采集任务执行情况（bit0：电源功率轮询，bit1：电源输入/输出 电流/电压查询，bit2：电源模式查询）0表示该属性未获取过，1表示获取过',
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.ScanStatus
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['description'] = '电源模块状态',
                ['validator'] = status_intf_types.Health
            },
            ['IsUpgrading'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '电源升级标识(false:未升级，true:升级中）',
                ['validator'] = status_intf_types.IsUpgrading
            },
            ['NormalAndRedundancySupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['description'] = '是否支持N+R(true:支持，false:不支持)',
                ['validator'] = status_intf_types.NormalAndRedundancySupported
            }
        },
        ['bmc.kepler.Metric'] = {},
        ['bmc.kepler.Debug.BlackBox'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.PowerMgmt.OnePower'] = {
            ['SetPowerWorkMode'] = {
                ['description'] = '设置电源工作模式',
                ['req'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '电源工作模式，1：设置为备用，0：设置为主用',
                        ['param'] = 'PowerWorkMode'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '命令执行结果，0：设置成功，1：设置失败',
                        ['param'] = 'CmdResult'
                    }
                },
                ['privilege'] = {'PowerMgmt'}
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Status'] = {
            ['SetSleepMode'] = {
                ['description'] = '设置电源休眠模式',
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['description'] = '电源休眠模式：Normal或DeepSleep',
                        ['param'] = 'SleepMode'
                    }
                },
                ['rsp'] = {
                    {
                        ['baseType'] = 'U8',
                        ['description'] = '命令执行结果，0：设置成功，1：设置失败',
                        ['param'] = 'CmdResult'
                    }
                },
                ['privilege'] = {'PowerMgmt'}
            }
        },
        ['bmc.kepler.Metric'] = {
            ['GetData'] = {
                ['description'] = '根据MetricName获取采集项数据',
                ['req'] = {{['baseType'] = 'String[]', ['description'] = '采集项名称', ['param'] = 'MetricName'}},
                ['rsp'] = {
                    {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/DataCollectionItem'},
                        ['description'] = '采集项数据',
                        ['param'] = 'Val'
                    }
                }
            },
            ['GetItems'] = {
                ['description'] = '获取采集项描述信息',
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['description'] = '采集主体名称', ['param'] = 'Component'}, {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/TagProp'},
                        ['description'] = '分类信息',
                        ['param'] = 'Classification'
                    }, {
                        ['baseType'] = 'Array',
                        ['items'] = {['$ref'] = '#/defs/TagProp'},
                        ['description'] = '标识信息',
                        ['param'] = 'Identification'
                    }, {['baseType'] = 'String[]', ['description'] = '采集项名称', ['param'] = 'MetricName'}
                }
            },
            ['SynDataAcquisitionEnable'] = {
                ['description'] = '将数据采集开关同步到业务组件',
                ['req'] = {{['baseType'] = 'U8', ['description'] = '数据采集开关', ['param'] = 'Enabled'}},
                ['rsp'] = {}
            }
        },
        ['bmc.kepler.Debug.BlackBox'] = {
            ['DumpPsuBlackbox'] = {
                ['description'] = '收集电源黑匣子日志，异步则通过TaskId返回结果',
                ['rsp'] = {{['baseType'] = 'U32', ['description'] = '任务Id', ['param'] = 'TaskId'}},
                ['privilege'] = {'ReadOnly'}
            }
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['CollectSignal'] = {
                {['baseType'] = 'String', ['param'] = 'MetricName'}, {['baseType'] = 'String', ['param'] = 'TagPath'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/PowerConverter/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.PowerMgmt.OnePower'] = {
            ['property_defaults'] = {
                ['SlotNumber'] = 0,
                ['Manufacturer'] = one_power_intf_types.Manufacturer.default[1],
                ['Model'] = one_power_intf_types.Model.default[1],
                ['PowerSupplyType'] = 0,
                ['Presence'] = 0,
                ['PowerSupplyChannel'] = 0,
                ['SerialNumber'] = one_power_intf_types.SerialNumber.default[1],
                ['PartNumber'] = one_power_intf_types.PartNumber.default[1],
                ['FirmwareVersion'] = one_power_intf_types.FirmwareVersion.default[1],
                ['Protocol'] = one_power_intf_types.Protocol.default[1],
                ['DeviceLocator'] = one_power_intf_types.DeviceLocator.default[1],
                ['ProductionDate'] = one_power_intf_types.ProductionDate.default[1],
                ['Position'] = one_power_intf_types.Position.default[1],
                ['WorkMode'] = one_power_intf_types.WorkMode.default[1],
                ['TotalRunningHours'] = one_power_intf_types.TotalRunningHours.default[1],
                ['RedundancyGroupId'] = one_power_intf_types.RedundancyGroupId.default[1],
                ['InputVoltageType'] = one_power_intf_types.InputVoltageType.default[1],
                ['DMTFPowerSupplyType'] = one_power_intf_types.DMTFPowerSupplyType.default[1],
                ['SourceType'] = one_power_intf_types.SourceType.default[1],
                ['IsPartOfSysPower'] = true
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['SetPowerWorkMode'] = privilege.PowerMgmt}},
            ['interface_types'] = one_power_intf_types
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Metrics'] = {
            ['property_defaults'] = {
                ['OutputPowerWatts'] = metrics_intf_types.OutputPowerWatts.default[1],
                ['InputPowerWatts'] = metrics_intf_types.InputPowerWatts.default[1],
                ['InputVoltage'] = metrics_intf_types.InputVoltage.default[1],
                ['OutputVoltage'] = metrics_intf_types.OutputVoltage.default[1],
                ['InputCurrentAmps'] = metrics_intf_types.InputCurrentAmps.default[1],
                ['OutputCurrentAmps'] = metrics_intf_types.OutputCurrentAmps.default[1],
                ['Rate'] = metrics_intf_types.Rate.default[1],
                ['RatedCurrentAmps'] = metrics_intf_types.RatedCurrentAmps.default[1],
                ['InputFrequencyHz'] = metrics_intf_types.InputFrequencyHz.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metrics_intf_types
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Temperatures'] = {
            ['property_defaults'] = {
                ['EnvTemperatureCelsius'] = temperatures_intf_types.EnvTemperatureCelsius.default[1],
                ['PrimaryChipTemperatureCelsius'] = temperatures_intf_types.PrimaryChipTemperatureCelsius.default[1],
                ['SecondaryChipTemperatureCelsius'] = temperatures_intf_types.SecondaryChipTemperatureCelsius.default[1],
                ['InletTemperatureCelsius'] = temperatures_intf_types.InletTemperatureCelsius.default[1],
                ['InnerTemperatureCelsius'] = temperatures_intf_types.InnerTemperatureCelsius.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = temperatures_intf_types
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Status'] = {
            ['property_defaults'] = {
                ['OutputState'] = status_intf_types.OutputState.default[1],
                ['CommunicationStatus'] = status_intf_types.CommunicationStatus.default[1],
                ['Failure'] = status_intf_types.Failure.default[1],
                ['Fan1Fault'] = status_intf_types.Fan1Fault.default[1],
                ['Fan2Fault'] = status_intf_types.Fan2Fault.default[1],
                ['FanFault'] = status_intf_types.FanFault.default[1],
                ['InputVoltageFault'] = 32768,
                ['LossOfInput'] = status_intf_types.LossOfInput.default[1],
                ['OutputCurrentFault'] = status_intf_types.OutputCurrentFault.default[1],
                ['OutputVoltageFault'] = status_intf_types.OutputVoltageFault.default[1],
                ['OverTemperature'] = status_intf_types.OverTemperature.default[1],
                ['SleepMode'] = status_intf_types.SleepMode.default[1],
                ['DeepSleepEnabled'] = status_intf_types.DeepSleepEnabled.default[1],
                ['InputVoltageStatus'] = status_intf_types.InputVoltageStatus.default[1],
                ['ScanStatus'] = status_intf_types.ScanStatus.default[1],
                ['Health'] = 255,
                ['IsUpgrading'] = status_intf_types.IsUpgrading.default[1],
                ['NormalAndRedundancySupported'] = status_intf_types.NormalAndRedundancySupported.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['SetSleepMode'] = privilege.PowerMgmt}},
            ['interface_types'] = status_intf_types
        },
        ['bmc.kepler.Metric'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metric_intf_types
        },
        ['bmc.kepler.Debug.BlackBox'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['DumpPsuBlackbox'] = privilege.ReadOnly}},
            ['interface_types'] = black_box_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PsuSlot = {
    ['table_name'] = 't_psu_slot',
    ['prop_configs'] = {
        ['SlotNumber'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['validator'] = psu_slot_class_types.SlotNumber
        },
        ['SlotI2cAddr'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = psu_slot_class_types.SlotI2cAddr},
        ['FruI2cAddr'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = psu_slot_class_types.FruI2cAddr},
        ['Presence'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['validator'] = psu_slot_class_types.Presence
        },
        ['I2cChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = psu_slot_class_types.I2cChip
        },
        ['PsuChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = psu_slot_class_types.PsuChip
        },
        ['FruChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = psu_slot_class_types.FruChip
        },
        ['OutputState'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = psu_slot_class_types.OutputState},
        ['FruSource'] = {
            ['usage'] = {'CSR'},
            ['enum'] = {0, 1, 2},
            ['baseType'] = 'U8',
            ['validator'] = psu_slot_class_types.FruSource
        }
    },
    ['default_props'] = {
        ['SlotNumber'] = psu_slot_class_types.SlotNumber.default[1],
        ['SlotI2cAddr'] = psu_slot_class_types.SlotI2cAddr.default[1],
        ['FruI2cAddr'] = psu_slot_class_types.FruI2cAddr.default[1],
        ['Presence'] = 255,
        ['I2cChip'] = psu_slot_class_types.I2cChip.default[1],
        ['PsuChip'] = psu_slot_class_types.PsuChip.default[1],
        ['FruChip'] = psu_slot_class_types.FruChip.default[1],
        ['OutputState'] = psu_slot_class_types.OutputState.default[1],
        ['FruSource'] = psu_slot_class_types.FruSource.default[1]
    }
}

local AclostRecordTable = {
    ['table_name'] = 't_aclost_record',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'String',
            ['validator'] = aclost_record_table_class_types.Id
        },
        ['CurTime'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'U32',
            ['validator'] = aclost_record_table_class_types.CurTime
        },
        ['Flag'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'U32',
            ['validator'] = aclost_record_table_class_types.Flag
        },
        ['ResetFlag'] = {
            ['usage'] = {'ResetPer'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = aclost_record_table_class_types.ResetFlag
        }
    },
    ['default_props'] = {
        ['Id'] = aclost_record_table_class_types.Id.default[1],
        ['CurTime'] = aclost_record_table_class_types.CurTime.default[1],
        ['Flag'] = aclost_record_table_class_types.Flag.default[1],
        ['ResetFlag'] = 0
    }
}

local DftPowerSupply = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项类型，1人工自检，2需要人工准备前置条件，3拷机测试，4人工检查结果，5人工操作测试，6与装备交互测试',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '槽位号',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试项传入的参数',
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备名称',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试前交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试完成交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试所需时间',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '当前测试状态',
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '开始装备测试项'},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '停止装备测试项'},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['description'] = '装备测试项状态',
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['description'] = '装备测试项描述', ['param'] = 'Description'}
                },
                ['description'] = '获取装备测试项结果'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/SelfTest/DftPowerSupply/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PowerConfiguration = {
    ['table_name'] = 't_power_configuration',
    ['prop_configs'] = {
        ['SinglePsuSupport'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['description'] = '是否支持单个电源升级标记, 1:支持,0:不支持',
            ['default'] = 0,
            ['validator'] = power_configuration_class_types.SinglePsuSupport
        }
    },
    ['default_props'] = {['SinglePsuSupport'] = 0}
}

local SystemPower = {
    ['table_name'] = 't_syspower_cfg',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['default'] = 'SystemPower',
            ['validator'] = system_power_class_types.Id
        },
        ['PsuFruConfig'] = {
            ['baseType'] = 'U32',
            ['description'] = '电源Fru信息定制化配置',
            ['default'] = 0,
            ['validator'] = system_power_class_types.PsuFruConfig
        }
    },
    ['default_props'] = {['Id'] = 'SystemPower', ['PsuFruConfig'] = 0}
}

local DftCanChannel = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项类型，1人工自检，2需要人工准备前置条件，3拷机测试，4人工检查结果，5人工操作测试，6与装备交互测试',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '装备测试项id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '槽位号',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试项传入的参数',
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备id',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '设备名称',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试前交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试完成交互提示',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '测试所需时间',
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['description'] = '当前测试状态',
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象类名',
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['description'] = '对象名',
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['description'] = '对象标志符',
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '开始装备测试项'},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}, ['description'] = '停止装备测试项'},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'Succeed', 'Failed', 'Non'},
                        ['description'] = '装备测试项状态',
                        ['param'] = 'Status'
                    }, {['baseType'] = 'String', ['description'] = '装备测试项描述', ['param'] = 'Description'}
                },
                ['description'] = '获取装备测试项结果'
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/InteractTest/DftCanChannel/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('PowerSupplies', PowerSupplies):set_bus(bus)
    class('OnePower', OnePower):set_bus(bus)
    class('PowerConverter', PowerConverter):set_bus(bus)
    class('PsuSlot', PsuSlot):set_bus(bus)
    class('AclostRecordTable', AclostRecordTable):set_bus(bus)
    class('DftPowerSupply', DftPowerSupply):set_bus(bus)
    class('PowerConfiguration', PowerConfiguration):set_bus(bus)
    class('SystemPower', SystemPower):set_bus(bus)
    class('DftCanChannel', DftCanChannel):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplPowerSuppliesPowerSuppliesSetPsusFanMinPWM(cb)
    class('PowerSupplies')['bmc.kepler.Chassis.PowerSubsystem.PowerSupplies'].SetPsusFanMinPWM = function(obj, ctx, ...)
        local req = power_supplies_intf_types.SetPsusFanMinPWMReq.new(...):validate(nil, nil, true)
        local rsp = power_supplies_intf_types.SetPsusFanMinPWMRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerOnePowerSetPowerWorkMode(cb)
    class('OnePower')['bmc.kepler.Systems.PowerMgmt.OnePower'].SetPowerWorkMode = function(obj, ctx, ...)
        local req = one_power_intf_types.SetPowerWorkModeReq.new(...):validate(nil, nil, true)
        local rsp = one_power_intf_types.SetPowerWorkModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerStatusSetSleepMode(cb)
    class('OnePower')['bmc.kepler.Systems.PowerMgmt.OnePower.Status'].SetSleepMode = function(obj, ctx, ...)
        local req = status_intf_types.SetSleepModeReq.new(...):validate(nil, nil, true)
        local rsp = status_intf_types.SetSleepModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerMetricGetData(cb)
    class('OnePower')['bmc.kepler.Metric'].GetData = function(obj, ctx, ...)
        local req = metric_intf_types.GetDataReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerMetricGetItems(cb)
    class('OnePower')['bmc.kepler.Metric'].GetItems = function(obj, ctx, ...)
        local req = metric_intf_types.GetItemsReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetItemsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerMetricSynDataAcquisitionEnable(cb)
    class('OnePower')['bmc.kepler.Metric'].SynDataAcquisitionEnable = function(obj, ctx, ...)
        local req = metric_intf_types.SynDataAcquisitionEnableReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.SynDataAcquisitionEnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerBlackBoxDumpPsuBlackbox(cb)
    class('OnePower')['bmc.kepler.Debug.BlackBox'].DumpPsuBlackbox = function(obj, ctx, ...)
        local req = black_box_intf_types.DumpPsuBlackboxReq.new(...):validate(nil, nil, true)
        local rsp = black_box_intf_types.DumpPsuBlackboxRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterOnePowerSetPowerWorkMode(cb)
    class('PowerConverter')['bmc.kepler.Systems.PowerMgmt.OnePower'].SetPowerWorkMode = function(obj, ctx, ...)
        local req = one_power_intf_types.SetPowerWorkModeReq.new(...):validate(nil, nil, true)
        local rsp = one_power_intf_types.SetPowerWorkModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterStatusSetSleepMode(cb)
    class('PowerConverter')['bmc.kepler.Systems.PowerMgmt.OnePower.Status'].SetSleepMode = function(obj, ctx, ...)
        local req = status_intf_types.SetSleepModeReq.new(...):validate(nil, nil, true)
        local rsp = status_intf_types.SetSleepModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterMetricGetData(cb)
    class('PowerConverter')['bmc.kepler.Metric'].GetData = function(obj, ctx, ...)
        local req = metric_intf_types.GetDataReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterMetricGetItems(cb)
    class('PowerConverter')['bmc.kepler.Metric'].GetItems = function(obj, ctx, ...)
        local req = metric_intf_types.GetItemsReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetItemsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterMetricSynDataAcquisitionEnable(cb)
    class('PowerConverter')['bmc.kepler.Metric'].SynDataAcquisitionEnable = function(obj, ctx, ...)
        local req = metric_intf_types.SynDataAcquisitionEnableReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.SynDataAcquisitionEnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterBlackBoxDumpPsuBlackbox(cb)
    class('PowerConverter')['bmc.kepler.Debug.BlackBox'].DumpPsuBlackbox = function(obj, ctx, ...)
        local req = black_box_intf_types.DumpPsuBlackboxReq.new(...):validate(nil, nil, true)
        local rsp = black_box_intf_types.DumpPsuBlackboxRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPowerSupplyManufactureStart(cb)
    class('DftPowerSupply')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPowerSupplyManufactureStop(cb)
    class('DftPowerSupply')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPowerSupplyManufactureGetResult(cb)
    class('DftPowerSupply')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftCanChannelManufactureStart(cb)
    class('DftCanChannel')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftCanChannelManufactureStop(cb)
    class('DftCanChannel')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftCanChannelManufactureGetResult(cb)
    class('DftCanChannel')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
