# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.
from conanbase import ConanBase


class AppConan(ConanBase):
    def package(self):
        super().package()
        self.copy("permissions.ini", src="dist/")

    def package_info(self):
        pass
        
    def _configure_cmake(self):
        super()._configure_cmake()
        defs = {}
        #当存在编译选项chipv2_enable=True时，编译chipv2芯片特性
        if self.options.chipv2_enable:
            defs["CONAN_DEFS_CHIPV2_ENABLE"] = True
        else:
            defs["CONAN_DEFS_CHIPV2_ENABLE"] = False
        self._cmake.configure(args=["--no-warn-unused-cli"], defs=defs)
        return self._cmake
