-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_pcie_card = require 'device.class.pcie_card'

TestPcieCard = {}

function TestPcieCard:test_set_prop()
    local PCIECARD_INTERFACE <const> = 'bmc.kepler.Systems.PCIeDevices.PCIeCard'
    c_pcie_card.mds = {
        LocalProp = 1,
        SameProp = 1,
        [PCIECARD_INTERFACE] = {
            InfProp = 1,
            SameProp = 2
        }
    }
    lu.assertEquals(c_pcie_card:get_prop('SameProp'), 1)
    lu.assertEquals(c_pcie_card:get_prop('SameProp', PCIECARD_INTERFACE), 2)
    lu.assertEquals(c_pcie_card:get_prop('LocalProp'), 1)
    lu.assertEquals(c_pcie_card:get_prop('InfProp', PCIECARD_INTERFACE), 1)
    -- 如果本地属性中不存在，从默认Interface属性中查找
    lu.assertEquals(c_pcie_card:get_prop('InfProp'), 1)

    c_pcie_card:set_prop('SameProp', 10)
    lu.assertEquals(c_pcie_card:get_prop('SameProp'), 10)
    lu.assertEquals(c_pcie_card:get_prop('SameProp', PCIECARD_INTERFACE), 2)
    c_pcie_card:set_prop('SameProp', 11, PCIECARD_INTERFACE)
    lu.assertEquals(c_pcie_card:get_prop('SameProp'), 10)
    lu.assertEquals(c_pcie_card:get_prop('SameProp', PCIECARD_INTERFACE), 11)
    c_pcie_card:set_prop('LocalProp', 12)
    lu.assertEquals(c_pcie_card:get_prop('LocalProp'), 12)
    c_pcie_card:set_prop('InfProp', 13, PCIECARD_INTERFACE)
    lu.assertEquals(c_pcie_card:get_prop('InfProp'), 13, PCIECARD_INTERFACE)
    -- 如果本地属性中不存在，从默认Interface属性中查找
    c_pcie_card:set_prop('InfProp', 14)
    lu.assertEquals(c_pcie_card:get_prop('InfProp'), 14)
    lu.assertEquals(c_pcie_card:get_prop('InfProp'), 14, PCIECARD_INTERFACE)
end
