-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_device_service = require 'device.device_service'
local utils = require 'mc.utils'
local client = require 'pcie_device.client'

TestDeviceService = {}

local DATA_PATH<const> = './test_data/'

function TestDeviceService:test_method_card_info_dump()
    client.GetPackageObjects = function()
        return {}
    end
    local pcie_card_list = {
        [1] = {
            get_prop = function(_, prop)
                local props = {
                    SlotID = 3,
                    LaneOwner = 0,
                    VendorID = 4096,
                    DeviceID = 4322,
                    SubVendorID = 4096,
                    SubDeviceID = 16400,
                    Description = 'MegaRAID 9560-8i',
                    BoardID = 0,
                    PcbVersion = 'N/A',
                    PartNumber = '06030622',
                    Manufacturer = 'Broadcom',
                    Position = 'PCIeRiser1',
                    Name = '9560-8i'
                }
                return props[prop]
            end
        }
    }

    c_device_service.pcie_device_list = {}
    c_device_service.pcie_card_list = pcie_card_list
    c_device_service:method_card_info_dump(nil, utils.realpath(DATA_PATH))
    local test_file_path = DATA_PATH .. 'card_info'
    local file = io.open(test_file_path, 'r')
    local str = file:read()
    file:close()
    lu.assertEquals(str:sub(1, 15), 'Pcie Card Info')
    os.execute('rm -f ' .. test_file_path)
end
