-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local def = require 'biz_topo.def'
local comm = require 'common'
local c_biz_topo_service = require 'biz_topo.biz_topo_service'
local ipmi = require 'ipmi'
local cc = ipmi.types.Cc

TestBizTopoService = {}

local pcie_card_list = {
    [1] = "test_pcie",
    [2] = "test_pcie"
}
local ocp_card_list = {
    [3] = "test_ocp",
    [4] = "test_ocp"
}

local test_topo_service = {
    device_loader = {
        persistent_load_info = {
            [def.device_type.PCIE_CARD] = pcie_card_list,
            [def.device_type.OCP_CARD] = ocp_card_list
        }
    }
}

-- 测试套间执行前调用
function TestBizTopoService:setupClass()
end

-- 测试套件执行后调用
function TestBizTopoService:teardownClass()
end

function TestBizTopoService:test_parse_pcie_card_bdf_data()

end

function TestBizTopoService:test_get_device_present_status()
    -- 1. 测试非法场景 非法的devtype
    local req = {
        DeviceType = 0x3,
    }
    local present = c_biz_topo_service.get_device_present_status(test_topo_service, req)
    lu.assertIsNil(present)

    -- 2. 测试正常场景 获取PCIeCard 在位状态
    req.DeviceType = comm.ipmi_type.IPMI_PCIE_CARD_TYPE
    present = c_biz_topo_service.get_device_present_status(test_topo_service, req)
    lu.assertEquals(present, 3)

    -- 3. 测试正常场景 获取OCPCard 在位状态
    req.DeviceType = comm.ipmi_type.IPMI_OCP_CARD_TYPE
    present = c_biz_topo_service.get_device_present_status(test_topo_service, req)
    lu.assertEquals(present, 12)
end