-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: IPMI Set PCIeAddr Info
local bs = require 'mc.bitstring'
local PKG_IPMI_LOG_RSP = '<<Ret:1/unit:8, ManuId:3/unit:8>>'
local log = require 'mc.logging'

local test_pcie_arrd_info = {}

local function test_set_cpu_no(ipmi_tool)
    local cpu_bus_case = {
        {
            cmd = '0x17 0x01 0x09 0x04 0x00 0x80 0xC0 0xE0 0x80 0x40 0x20 0x20',
            info = 'Set CpuNo'
        }
    }
    for _, case in ipairs(cpu_bus_case) do
        local rsp = ipmi_tool:cmd_test(case)
        local data = bs.new(PKG_IPMI_LOG_RSP):unpack(rsp)
        assert(data, 'data is NULL')
    end
end

local function test_set_pcieaddr_info(ipmi_tool)
    local pcie_addr_case = {
        {
            cmd = '0x17 0x0E 0x07 0x00 0x01 0x02 0x01 0x74 0x04 0x00',
            info = 'Set Integrated PCIe Addr Info'
        }
    }
    for _, case in ipairs(pcie_addr_case) do
        local rsp = ipmi_tool:cmd_test(case)
        local data = bs.new(PKG_IPMI_LOG_RSP):unpack(rsp)
        assert(data, 'data is NULL')
    end
end

function test_pcie_arrd_info:test_set_info_by_ipmi(ipmi_tool)
    test_set_cpu_no(ipmi_tool)
    test_set_pcieaddr_info(ipmi_tool)
end

return test_pcie_arrd_info