-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local class = require 'mc.class'
local c_base = require 'biz_topo.class.base'
local def = require 'biz_topo.def'
local debounce = require 'mc.debounce.debounce'
---@class UnitConfiguration: Base @组件配置
---@field public mds_obj table @MDS对象
---@field public configs Config[] @一个槽位上所支持的插卡配置集合
local c_unit_configuration = class(c_base)

local function configuration_new(UID, Index, SrcPortName, TargetPortID, Slot, Device, Default, BCUIndex)
    return {
        UID = UID,
        Index = Index,
        SrcPortName = SrcPortName,
        TargetPortID = TargetPortID,
        Slot = Slot,
        Device = Device,
        Default = Default,
        BCUIndex = BCUIndex
    }
end

function c_unit_configuration:init()
    local cfg
    if self.mds_obj.Configurations and #self.mds_obj.Configurations ~= 0 and
        #self.mds_obj.Configurations[1] ~= 0 then
        for i, config in ipairs(self.mds_obj.Configurations) do
            self.mds_obj.Configurations[i] = configuration_new(table.unpack(config))
            self.mds_obj.Configurations[i].BCUIndex = config[8]
        end
    end

    -- 初始化 configs
    if self.mds_obj.Configurations and #self.mds_obj.Configurations ~= 0 then
        for i, config in ipairs(self.mds_obj.Configurations) do
            ---@class Config @配置信息
            ---@field public matched_times number @成功匹配次数
            cfg = {
                uid = config.UID,
                index = config.Index,
                src_ports_name = config.SrcPortName,
                target_ports_id = config.TargetPortID,
                matched_times = 0,
                connected_times = 0,
                default = config.Default,
                bcu_index = config.BCUIndex
            }
            self.configs[i] = cfg
        end
    end

    local monitor_status_debounce = {}
    monitor_status_debounce[def.PROP_PORT_LINK_INFO[1]] = debounce['Cont'].new(def.DBD_CONT.CONT_NUM, 255)
    self.monitor_status = monitor_status_debounce
end

function c_unit_configuration:ctor(mds_obj, position)
    self.default_interface = 'bmc.kepler.Systems.UnitConfigError'
    self.mds_obj = mds_obj
    self.position = position
    self.configs = {}
end

return c_unit_configuration