-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local class = require 'mc.class'
local serdes_gen = require 'class.types.SerDes'

---@class SerDes @SerDes
---@field public mds_obj table @MDS对象
---@field public start_lane number @当前SerDes位于所在的SerDes组中的起始lane号
local c_serdes = class()

local function serdes_mode_config_new(Mode, Device, ControllerIndex)
    return {Mode = Mode, Device = Device, ControllerIndex = ControllerIndex}
end

function c_serdes:init()
    if self.mds_obj.ModeConfigs and #self.mds_obj.ModeConfigs ~= 0 and
        #self.mds_obj.ModeConfigs[1] ~= 0 then
        for i, config in ipairs(self.mds_obj.ModeConfigs) do
            self.mds_obj.ModeConfigs[i] = serdes_mode_config_new(table.unpack(config))
        end
    end

    if self.mds_obj.PCIePorts and #self.mds_obj.PCIePorts ~= 0 then
        local tbl = serdes_gen.PCIePorts.new(self.mds_obj.PCIePorts)
        self.mds_obj.PCIePorts = tbl.PCIePorts
    end

    if self.mds_obj.SASPorts and #self.mds_obj.SASPorts ~= 0 then
        local tbl = serdes_gen.SASPorts.new(self.mds_obj.SASPorts)
        self.mds_obj.SASPorts = tbl.SASPorts
    end
end

function c_serdes:ctor(mds_obj, position)
    self.mds_obj = mds_obj
    self.position = position
end

return c_serdes