-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local PCIeDeviceEnum = require 'pcie_device.types.enum'

local PCIeDeviceMsg = {}

---@class PCIeDeviceMsg.SetDiagnosticFaultReq
---@field Segment integer
---@field SocketID integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field Value integer
local TSetDiagnosticFaultReq = {}
TSetDiagnosticFaultReq.__index = TSetDiagnosticFaultReq
TSetDiagnosticFaultReq.group = {}

local function TSetDiagnosticFaultReq_from_obj(obj)
    return setmetatable(obj, TSetDiagnosticFaultReq)
end

function TSetDiagnosticFaultReq.new(Segment, SocketID, Bus, Device, Function, Value)
    return TSetDiagnosticFaultReq_from_obj({
        Segment = Segment,
        SocketID = SocketID,
        Bus = Bus,
        Device = Device,
        Function = Function,
        Value = Value
    })
end
---@param obj PCIeDeviceMsg.SetDiagnosticFaultReq
function TSetDiagnosticFaultReq:init_from_obj(obj)
    self.Segment = obj.Segment
    self.SocketID = obj.SocketID
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
    self.Value = obj.Value
end

function TSetDiagnosticFaultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDiagnosticFaultReq.group)
end

TSetDiagnosticFaultReq.from_obj = TSetDiagnosticFaultReq_from_obj

TSetDiagnosticFaultReq.proto_property = {'Segment', 'SocketID', 'Bus', 'Device', 'Function', 'Value'}

TSetDiagnosticFaultReq.default = {0, 0, 0, 0, 0, 0}

TSetDiagnosticFaultReq.struct = {
    {name = 'Segment', is_array = false, struct = nil}, {name = 'SocketID', is_array = false, struct = nil},
    {name = 'Bus', is_array = false, struct = nil}, {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil}, {name = 'Value', is_array = false, struct = nil}
}

function TSetDiagnosticFaultReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Segment', self.Segment, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'SocketID', self.SocketID, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'Value', self.Value, 'uint8', false, errs, need_convert)

    TSetDiagnosticFaultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDiagnosticFaultReq.proto_property, errs, need_convert)
    return self
end

function TSetDiagnosticFaultReq:unpack(_)
    return self.Segment, self.SocketID, self.Bus, self.Device, self.Function, self.Value
end

PCIeDeviceMsg.SetDiagnosticFaultReq = TSetDiagnosticFaultReq

---@class PCIeDeviceMsg.SetDiagnosticFaultResp
---@field Status integer
local TSetDiagnosticFaultResp = {}
TSetDiagnosticFaultResp.__index = TSetDiagnosticFaultResp
TSetDiagnosticFaultResp.group = {}

local function TSetDiagnosticFaultResp_from_obj(obj)
    return setmetatable(obj, TSetDiagnosticFaultResp)
end

function TSetDiagnosticFaultResp.new(Status)
    return TSetDiagnosticFaultResp_from_obj({Status = Status})
end
---@param obj PCIeDeviceMsg.SetDiagnosticFaultResp
function TSetDiagnosticFaultResp:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetDiagnosticFaultResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDiagnosticFaultResp.group)
end

TSetDiagnosticFaultResp.from_obj = TSetDiagnosticFaultResp_from_obj

TSetDiagnosticFaultResp.proto_property = {'Status'}

TSetDiagnosticFaultResp.default = {0}

TSetDiagnosticFaultResp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetDiagnosticFaultResp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetDiagnosticFaultResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDiagnosticFaultResp.proto_property, errs, need_convert)
    return self
end

function TSetDiagnosticFaultResp:unpack(_)
    return self.Status
end

PCIeDeviceMsg.SetDiagnosticFaultResp = TSetDiagnosticFaultResp

---@class PCIeDeviceMsg.SetPredictiveFaultReq
---@field Segment integer
---@field SocketID integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field Value integer
local TSetPredictiveFaultReq = {}
TSetPredictiveFaultReq.__index = TSetPredictiveFaultReq
TSetPredictiveFaultReq.group = {}

local function TSetPredictiveFaultReq_from_obj(obj)
    return setmetatable(obj, TSetPredictiveFaultReq)
end

function TSetPredictiveFaultReq.new(Segment, SocketID, Bus, Device, Function, Value)
    return TSetPredictiveFaultReq_from_obj({
        Segment = Segment,
        SocketID = SocketID,
        Bus = Bus,
        Device = Device,
        Function = Function,
        Value = Value
    })
end
---@param obj PCIeDeviceMsg.SetPredictiveFaultReq
function TSetPredictiveFaultReq:init_from_obj(obj)
    self.Segment = obj.Segment
    self.SocketID = obj.SocketID
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
    self.Value = obj.Value
end

function TSetPredictiveFaultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPredictiveFaultReq.group)
end

TSetPredictiveFaultReq.from_obj = TSetPredictiveFaultReq_from_obj

TSetPredictiveFaultReq.proto_property = {'Segment', 'SocketID', 'Bus', 'Device', 'Function', 'Value'}

TSetPredictiveFaultReq.default = {0, 0, 0, 0, 0, 0}

TSetPredictiveFaultReq.struct = {
    {name = 'Segment', is_array = false, struct = nil}, {name = 'SocketID', is_array = false, struct = nil},
    {name = 'Bus', is_array = false, struct = nil}, {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil}, {name = 'Value', is_array = false, struct = nil}
}

function TSetPredictiveFaultReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Segment', self.Segment, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'SocketID', self.SocketID, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'Value', self.Value, 'uint8', false, errs, need_convert)

    TSetPredictiveFaultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPredictiveFaultReq.proto_property, errs, need_convert)
    return self
end

function TSetPredictiveFaultReq:unpack(_)
    return self.Segment, self.SocketID, self.Bus, self.Device, self.Function, self.Value
end

PCIeDeviceMsg.SetPredictiveFaultReq = TSetPredictiveFaultReq

---@class PCIeDeviceMsg.SetPredictiveFaultResp
---@field Status integer
local TSetPredictiveFaultResp = {}
TSetPredictiveFaultResp.__index = TSetPredictiveFaultResp
TSetPredictiveFaultResp.group = {}

local function TSetPredictiveFaultResp_from_obj(obj)
    return setmetatable(obj, TSetPredictiveFaultResp)
end

function TSetPredictiveFaultResp.new(Status)
    return TSetPredictiveFaultResp_from_obj({Status = Status})
end
---@param obj PCIeDeviceMsg.SetPredictiveFaultResp
function TSetPredictiveFaultResp:init_from_obj(obj)
    self.Status = obj.Status
end

function TSetPredictiveFaultResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPredictiveFaultResp.group)
end

TSetPredictiveFaultResp.from_obj = TSetPredictiveFaultResp_from_obj

TSetPredictiveFaultResp.proto_property = {'Status'}

TSetPredictiveFaultResp.default = {0}

TSetPredictiveFaultResp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TSetPredictiveFaultResp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)

    TSetPredictiveFaultResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPredictiveFaultResp.proto_property, errs, need_convert)
    return self
end

function TSetPredictiveFaultResp:unpack(_)
    return self.Status
end

PCIeDeviceMsg.SetPredictiveFaultResp = TSetPredictiveFaultResp

---@class PCIeDeviceMsg.GetDeviceNameReq
---@field Segment integer
---@field SocketID integer
---@field Bus integer
---@field Device integer
---@field Function integer
local TGetDeviceNameReq = {}
TGetDeviceNameReq.__index = TGetDeviceNameReq
TGetDeviceNameReq.group = {}

local function TGetDeviceNameReq_from_obj(obj)
    return setmetatable(obj, TGetDeviceNameReq)
end

function TGetDeviceNameReq.new(Segment, SocketID, Bus, Device, Function)
    return TGetDeviceNameReq_from_obj({
        Segment = Segment,
        SocketID = SocketID,
        Bus = Bus,
        Device = Device,
        Function = Function
    })
end
---@param obj PCIeDeviceMsg.GetDeviceNameReq
function TGetDeviceNameReq:init_from_obj(obj)
    self.Segment = obj.Segment
    self.SocketID = obj.SocketID
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
end

function TGetDeviceNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceNameReq.group)
end

TGetDeviceNameReq.from_obj = TGetDeviceNameReq_from_obj

TGetDeviceNameReq.proto_property = {'Segment', 'SocketID', 'Bus', 'Device', 'Function'}

TGetDeviceNameReq.default = {0, 0, 0, 0, 0}

TGetDeviceNameReq.struct = {
    {name = 'Segment', is_array = false, struct = nil}, {name = 'SocketID', is_array = false, struct = nil},
    {name = 'Bus', is_array = false, struct = nil}, {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil}
}

function TGetDeviceNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Segment', self.Segment, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'SocketID', self.SocketID, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)

    TGetDeviceNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceNameReq.proto_property, errs, need_convert)
    return self
end

function TGetDeviceNameReq:unpack(_)
    return self.Segment, self.SocketID, self.Bus, self.Device, self.Function
end

PCIeDeviceMsg.GetDeviceNameReq = TGetDeviceNameReq

---@class PCIeDeviceMsg.GetDeviceNameResp
---@field Status integer
---@field DeviceName string
local TGetDeviceNameResp = {}
TGetDeviceNameResp.__index = TGetDeviceNameResp
TGetDeviceNameResp.group = {}

local function TGetDeviceNameResp_from_obj(obj)
    return setmetatable(obj, TGetDeviceNameResp)
end

function TGetDeviceNameResp.new(Status, DeviceName)
    return TGetDeviceNameResp_from_obj({Status = Status, DeviceName = DeviceName})
end
---@param obj PCIeDeviceMsg.GetDeviceNameResp
function TGetDeviceNameResp:init_from_obj(obj)
    self.Status = obj.Status
    self.DeviceName = obj.DeviceName
end

function TGetDeviceNameResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDeviceNameResp.group)
end

TGetDeviceNameResp.from_obj = TGetDeviceNameResp_from_obj

TGetDeviceNameResp.proto_property = {'Status', 'DeviceName'}

TGetDeviceNameResp.default = {0, ''}

TGetDeviceNameResp.struct = {
    {name = 'Status', is_array = false, struct = nil}, {name = 'DeviceName', is_array = false, struct = nil}
}

function TGetDeviceNameResp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)
    validate.Required(prefix .. 'DeviceName', self.DeviceName, 'string', false, errs, need_convert)

    TGetDeviceNameResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDeviceNameResp.proto_property, errs, need_convert)
    return self
end

function TGetDeviceNameResp:unpack(_)
    return self.Status, self.DeviceName
end

PCIeDeviceMsg.GetDeviceNameResp = TGetDeviceNameResp

---@class PCIeDeviceMsg.GetPCIeCardNumReq
local TGetPCIeCardNumReq = {}
TGetPCIeCardNumReq.__index = TGetPCIeCardNumReq
TGetPCIeCardNumReq.group = {}

local function TGetPCIeCardNumReq_from_obj(obj)
    return setmetatable(obj, TGetPCIeCardNumReq)
end

function TGetPCIeCardNumReq.new()
    return TGetPCIeCardNumReq_from_obj({})
end
---@param obj PCIeDeviceMsg.GetPCIeCardNumReq
function TGetPCIeCardNumReq:init_from_obj(obj)

end

function TGetPCIeCardNumReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPCIeCardNumReq.group)
end

TGetPCIeCardNumReq.from_obj = TGetPCIeCardNumReq_from_obj

TGetPCIeCardNumReq.proto_property = {}

TGetPCIeCardNumReq.default = {}

TGetPCIeCardNumReq.struct = {}

function TGetPCIeCardNumReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetPCIeCardNumReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPCIeCardNumReq.proto_property, errs, need_convert)
    return self
end

function TGetPCIeCardNumReq:unpack(_)
end

PCIeDeviceMsg.GetPCIeCardNumReq = TGetPCIeCardNumReq

---@class PCIeDeviceMsg.GetPCIeCardNumResp
---@field PCIeCardNum integer
local TGetPCIeCardNumResp = {}
TGetPCIeCardNumResp.__index = TGetPCIeCardNumResp
TGetPCIeCardNumResp.group = {}

local function TGetPCIeCardNumResp_from_obj(obj)
    return setmetatable(obj, TGetPCIeCardNumResp)
end

function TGetPCIeCardNumResp.new(PCIeCardNum)
    return TGetPCIeCardNumResp_from_obj({PCIeCardNum = PCIeCardNum})
end
---@param obj PCIeDeviceMsg.GetPCIeCardNumResp
function TGetPCIeCardNumResp:init_from_obj(obj)
    self.PCIeCardNum = obj.PCIeCardNum
end

function TGetPCIeCardNumResp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPCIeCardNumResp.group)
end

TGetPCIeCardNumResp.from_obj = TGetPCIeCardNumResp_from_obj

TGetPCIeCardNumResp.proto_property = {'PCIeCardNum'}

TGetPCIeCardNumResp.default = {0}

TGetPCIeCardNumResp.struct = {{name = 'PCIeCardNum', is_array = false, struct = nil}}

function TGetPCIeCardNumResp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'PCIeCardNum', self.PCIeCardNum, 'uint32', false, errs, need_convert)

    TGetPCIeCardNumResp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPCIeCardNumResp.proto_property, errs, need_convert)
    return self
end

function TGetPCIeCardNumResp:unpack(_)
    return self.PCIeCardNum
end

PCIeDeviceMsg.GetPCIeCardNumResp = TGetPCIeCardNumResp

return PCIeDeviceMsg
