-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local UnitConfigError = {}

---@class UnitConfigError.AbsenceAllowed
---@field AbsenceAllowed integer
local TAbsenceAllowed = {}
TAbsenceAllowed.__index = TAbsenceAllowed
TAbsenceAllowed.group = {}

local function TAbsenceAllowed_from_obj(obj)
    return setmetatable(obj, TAbsenceAllowed)
end

function TAbsenceAllowed.new(AbsenceAllowed)
    return TAbsenceAllowed_from_obj({AbsenceAllowed = AbsenceAllowed or 0})
end
---@param obj UnitConfigError.AbsenceAllowed
function TAbsenceAllowed:init_from_obj(obj)
    self.AbsenceAllowed = obj.AbsenceAllowed or 0
end

function TAbsenceAllowed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAbsenceAllowed.group)
end

TAbsenceAllowed.from_obj = TAbsenceAllowed_from_obj

TAbsenceAllowed.proto_property = {'AbsenceAllowed'}

TAbsenceAllowed.default = {0}

TAbsenceAllowed.struct = {{name = 'AbsenceAllowed', is_array = false, struct = nil}}

function TAbsenceAllowed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AbsenceAllowed', self.AbsenceAllowed, 'uint8', true, errs, need_convert)

    TAbsenceAllowed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAbsenceAllowed.proto_property, errs, need_convert)
    return self
end

function TAbsenceAllowed:unpack(_)
    return self.AbsenceAllowed
end

UnitConfigError.AbsenceAllowed = TAbsenceAllowed

---@class UnitConfigError.Port2Status
---@field Port2Status integer
local TPort2Status = {}
TPort2Status.__index = TPort2Status
TPort2Status.group = {}

local function TPort2Status_from_obj(obj)
    return setmetatable(obj, TPort2Status)
end

function TPort2Status.new(Port2Status)
    return TPort2Status_from_obj({Port2Status = Port2Status or 255})
end
---@param obj UnitConfigError.Port2Status
function TPort2Status:init_from_obj(obj)
    self.Port2Status = obj.Port2Status or 255
end

function TPort2Status:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPort2Status.group)
end

TPort2Status.from_obj = TPort2Status_from_obj

TPort2Status.proto_property = {'Port2Status'}

TPort2Status.default = {0}

TPort2Status.struct = {{name = 'Port2Status', is_array = false, struct = nil}}

function TPort2Status:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Port2Status', self.Port2Status, 'uint8', false, errs, need_convert)

    TPort2Status:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPort2Status.proto_property, errs, need_convert)
    return self
end

function TPort2Status:unpack(_)
    return self.Port2Status
end

UnitConfigError.Port2Status = TPort2Status

---@class UnitConfigError.Port2LinkInfo
---@field Port2LinkInfo string
local TPort2LinkInfo = {}
TPort2LinkInfo.__index = TPort2LinkInfo
TPort2LinkInfo.group = {}

local function TPort2LinkInfo_from_obj(obj)
    return setmetatable(obj, TPort2LinkInfo)
end

function TPort2LinkInfo.new(Port2LinkInfo)
    return TPort2LinkInfo_from_obj({Port2LinkInfo = Port2LinkInfo})
end
---@param obj UnitConfigError.Port2LinkInfo
function TPort2LinkInfo:init_from_obj(obj)
    self.Port2LinkInfo = obj.Port2LinkInfo
end

function TPort2LinkInfo:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPort2LinkInfo.group)
end

TPort2LinkInfo.from_obj = TPort2LinkInfo_from_obj

TPort2LinkInfo.proto_property = {'Port2LinkInfo'}

TPort2LinkInfo.default = {''}

TPort2LinkInfo.struct = {{name = 'Port2LinkInfo', is_array = false, struct = nil}}

function TPort2LinkInfo:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Port2LinkInfo', self.Port2LinkInfo, 'string', false, errs, need_convert)

    TPort2LinkInfo:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPort2LinkInfo.proto_property, errs, need_convert)
    return self
end

function TPort2LinkInfo:unpack(_)
    return self.Port2LinkInfo
end

UnitConfigError.Port2LinkInfo = TPort2LinkInfo

---@class UnitConfigError.Port1Status
---@field Port1Status integer
local TPort1Status = {}
TPort1Status.__index = TPort1Status
TPort1Status.group = {}

local function TPort1Status_from_obj(obj)
    return setmetatable(obj, TPort1Status)
end

function TPort1Status.new(Port1Status)
    return TPort1Status_from_obj({Port1Status = Port1Status or 255})
end
---@param obj UnitConfigError.Port1Status
function TPort1Status:init_from_obj(obj)
    self.Port1Status = obj.Port1Status or 255
end

function TPort1Status:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPort1Status.group)
end

TPort1Status.from_obj = TPort1Status_from_obj

TPort1Status.proto_property = {'Port1Status'}

TPort1Status.default = {0}

TPort1Status.struct = {{name = 'Port1Status', is_array = false, struct = nil}}

function TPort1Status:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Port1Status', self.Port1Status, 'uint8', false, errs, need_convert)

    TPort1Status:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPort1Status.proto_property, errs, need_convert)
    return self
end

function TPort1Status:unpack(_)
    return self.Port1Status
end

UnitConfigError.Port1Status = TPort1Status

---@class UnitConfigError.Port1LinkInfo
---@field Port1LinkInfo string
local TPort1LinkInfo = {}
TPort1LinkInfo.__index = TPort1LinkInfo
TPort1LinkInfo.group = {}

local function TPort1LinkInfo_from_obj(obj)
    return setmetatable(obj, TPort1LinkInfo)
end

function TPort1LinkInfo.new(Port1LinkInfo)
    return TPort1LinkInfo_from_obj({Port1LinkInfo = Port1LinkInfo})
end
---@param obj UnitConfigError.Port1LinkInfo
function TPort1LinkInfo:init_from_obj(obj)
    self.Port1LinkInfo = obj.Port1LinkInfo
end

function TPort1LinkInfo:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPort1LinkInfo.group)
end

TPort1LinkInfo.from_obj = TPort1LinkInfo_from_obj

TPort1LinkInfo.proto_property = {'Port1LinkInfo'}

TPort1LinkInfo.default = {''}

TPort1LinkInfo.struct = {{name = 'Port1LinkInfo', is_array = false, struct = nil}}

function TPort1LinkInfo:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Port1LinkInfo', self.Port1LinkInfo, 'string', false, errs, need_convert)

    TPort1LinkInfo:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPort1LinkInfo.proto_property, errs, need_convert)
    return self
end

function TPort1LinkInfo:unpack(_)
    return self.Port1LinkInfo
end

UnitConfigError.Port1LinkInfo = TPort1LinkInfo

UnitConfigError.interface = mdb.register_interface('bmc.kepler.Systems.UnitConfigError', {
    Port1LinkInfo = {'s', nil, false, nil, false},
    Port1Status = {'y', nil, false, 255, false},
    Port2LinkInfo = {'s', nil, false, nil, false},
    Port2Status = {'y', nil, false, 255, false},
    AbsenceAllowed = {'y', nil, true, 0, false}
}, {}, {})

return UnitConfigError
