-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local RAS = {}

---@class RAS.SystemError
---@field SystemError integer
local TSystemError = {}
TSystemError.__index = TSystemError
TSystemError.group = {}

local function TSystemError_from_obj(obj)
    return setmetatable(obj, TSystemError)
end

function TSystemError.new(SystemError)
    return TSystemError_from_obj({SystemError = SystemError})
end
---@param obj RAS.SystemError
function TSystemError:init_from_obj(obj)
    self.SystemError = obj.SystemError
end

function TSystemError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemError.group)
end

TSystemError.from_obj = TSystemError_from_obj

TSystemError.proto_property = {'SystemError'}

TSystemError.default = {0}

TSystemError.struct = {{name = 'SystemError', is_array = false, struct = nil}}

function TSystemError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemError', self.SystemError, 'uint8', false, errs, need_convert)

    TSystemError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemError.proto_property, errs, need_convert)
    return self
end

function TSystemError:unpack(_)
    return self.SystemError
end

RAS.SystemError = TSystemError

---@class RAS.ParityError
---@field ParityError integer
local TParityError = {}
TParityError.__index = TParityError
TParityError.group = {}

local function TParityError_from_obj(obj)
    return setmetatable(obj, TParityError)
end

function TParityError.new(ParityError)
    return TParityError_from_obj({ParityError = ParityError})
end
---@param obj RAS.ParityError
function TParityError:init_from_obj(obj)
    self.ParityError = obj.ParityError
end

function TParityError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TParityError.group)
end

TParityError.from_obj = TParityError_from_obj

TParityError.proto_property = {'ParityError'}

TParityError.default = {0}

TParityError.struct = {{name = 'ParityError', is_array = false, struct = nil}}

function TParityError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ParityError', self.ParityError, 'uint8', false, errs, need_convert)

    TParityError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TParityError.proto_property, errs, need_convert)
    return self
end

function TParityError:unpack(_)
    return self.ParityError
end

RAS.ParityError = TParityError

---@class RAS.FatalError
---@field FatalError integer
local TFatalError = {}
TFatalError.__index = TFatalError
TFatalError.group = {}

local function TFatalError_from_obj(obj)
    return setmetatable(obj, TFatalError)
end

function TFatalError.new(FatalError)
    return TFatalError_from_obj({FatalError = FatalError})
end
---@param obj RAS.FatalError
function TFatalError:init_from_obj(obj)
    self.FatalError = obj.FatalError
end

function TFatalError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFatalError.group)
end

TFatalError.from_obj = TFatalError_from_obj

TFatalError.proto_property = {'FatalError'}

TFatalError.default = {0}

TFatalError.struct = {{name = 'FatalError', is_array = false, struct = nil}}

function TFatalError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FatalError', self.FatalError, 'uint8', false, errs, need_convert)

    TFatalError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFatalError.proto_property, errs, need_convert)
    return self
end

function TFatalError:unpack(_)
    return self.FatalError
end

RAS.FatalError = TFatalError

---@class RAS.UncorrectableError
---@field UncorrectableError integer
local TUncorrectableError = {}
TUncorrectableError.__index = TUncorrectableError
TUncorrectableError.group = {}

local function TUncorrectableError_from_obj(obj)
    return setmetatable(obj, TUncorrectableError)
end

function TUncorrectableError.new(UncorrectableError)
    return TUncorrectableError_from_obj({UncorrectableError = UncorrectableError})
end
---@param obj RAS.UncorrectableError
function TUncorrectableError:init_from_obj(obj)
    self.UncorrectableError = obj.UncorrectableError
end

function TUncorrectableError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUncorrectableError.group)
end

TUncorrectableError.from_obj = TUncorrectableError_from_obj

TUncorrectableError.proto_property = {'UncorrectableError'}

TUncorrectableError.default = {0}

TUncorrectableError.struct = {{name = 'UncorrectableError', is_array = false, struct = nil}}

function TUncorrectableError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UncorrectableError', self.UncorrectableError, 'uint8', false, errs, need_convert)

    TUncorrectableError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUncorrectableError.proto_property, errs, need_convert)
    return self
end

function TUncorrectableError:unpack(_)
    return self.UncorrectableError
end

RAS.UncorrectableError = TUncorrectableError

---@class RAS.CorrectableError
---@field CorrectableError integer
local TCorrectableError = {}
TCorrectableError.__index = TCorrectableError
TCorrectableError.group = {}

local function TCorrectableError_from_obj(obj)
    return setmetatable(obj, TCorrectableError)
end

function TCorrectableError.new(CorrectableError)
    return TCorrectableError_from_obj({CorrectableError = CorrectableError})
end
---@param obj RAS.CorrectableError
function TCorrectableError:init_from_obj(obj)
    self.CorrectableError = obj.CorrectableError
end

function TCorrectableError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCorrectableError.group)
end

TCorrectableError.from_obj = TCorrectableError_from_obj

TCorrectableError.proto_property = {'CorrectableError'}

TCorrectableError.default = {0}

TCorrectableError.struct = {{name = 'CorrectableError', is_array = false, struct = nil}}

function TCorrectableError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CorrectableError', self.CorrectableError, 'uint8', false, errs, need_convert)

    TCorrectableError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCorrectableError.proto_property, errs, need_convert)
    return self
end

function TCorrectableError:unpack(_)
    return self.CorrectableError
end

RAS.CorrectableError = TCorrectableError

RAS.interface = mdb.register_interface('bmc.kepler.Systems.PCIeDevices.PCIeDevice.RAS', {
    CorrectableError = {'y', nil, false, nil, false},
    UncorrectableError = {'y', nil, false, nil, false},
    FatalError = {'y', nil, false, nil, false},
    ParityError = {'y', nil, false, nil, false},
    SystemError = {'y', nil, false, nil, false}
}, {}, {})

return RAS
