-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NPU = {}

---@class NPU.Slot
---@field Slot integer
local TSlot = {}
TSlot.__index = TSlot
TSlot.group = {}

local function TSlot_from_obj(obj)
    return setmetatable(obj, TSlot)
end

function TSlot.new(Slot)
    return TSlot_from_obj({Slot = Slot})
end
---@param obj NPU.Slot
function TSlot:init_from_obj(obj)
    self.Slot = obj.Slot
end

function TSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlot.group)
end

TSlot.from_obj = TSlot_from_obj

TSlot.proto_property = {'Slot'}

TSlot.default = {0}

TSlot.struct = {{name = 'Slot', is_array = false, struct = nil}}

function TSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', true, errs, need_convert)

    TSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlot.proto_property, errs, need_convert)
    return self
end

function TSlot:unpack(_)
    return self.Slot
end

NPU.Slot = TSlot

---@class NPU.FlashIds
---@field FlashIds integer[]
local TFlashIds = {}
TFlashIds.__index = TFlashIds
TFlashIds.group = {}

local function TFlashIds_from_obj(obj)
    return setmetatable(obj, TFlashIds)
end

function TFlashIds.new(FlashIds)
    return TFlashIds_from_obj({FlashIds = FlashIds})
end
---@param obj NPU.FlashIds
function TFlashIds:init_from_obj(obj)
    self.FlashIds = obj.FlashIds
end

function TFlashIds:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFlashIds.group)
end

TFlashIds.from_obj = TFlashIds_from_obj

TFlashIds.proto_property = {'FlashIds'}

TFlashIds.default = {{}}

TFlashIds.struct = {{name = 'FlashIds', is_array = true, struct = nil}}

function TFlashIds:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'FlashIds', self.FlashIds, 'uint64', true, errs, need_convert)

    TFlashIds:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFlashIds.proto_property, errs, need_convert)
    return self
end

function TFlashIds:unpack(_)
    return self.FlashIds
end

NPU.FlashIds = TFlashIds

---@class NPU.Location
---@field Location string
local TLocation = {}
TLocation.__index = TLocation
TLocation.group = {}

local function TLocation_from_obj(obj)
    return setmetatable(obj, TLocation)
end

function TLocation.new(Location)
    return TLocation_from_obj({Location = Location})
end
---@param obj NPU.Location
function TLocation:init_from_obj(obj)
    self.Location = obj.Location
end

function TLocation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocation.group)
end

TLocation.from_obj = TLocation_from_obj

TLocation.proto_property = {'Location'}

TLocation.default = {''}

TLocation.struct = {{name = 'Location', is_array = false, struct = nil}}

function TLocation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Location', self.Location, 'string', true, errs, need_convert)

    TLocation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocation.proto_property, errs, need_convert)
    return self
end

function TLocation:unpack(_)
    return self.Location
end

NPU.Location = TLocation

---@class NPU.TotalCores
---@field TotalCores integer
local TTotalCores = {}
TTotalCores.__index = TTotalCores
TTotalCores.group = {}

local function TTotalCores_from_obj(obj)
    return setmetatable(obj, TTotalCores)
end

function TTotalCores.new(TotalCores)
    return TTotalCores_from_obj({TotalCores = TotalCores})
end
---@param obj NPU.TotalCores
function TTotalCores:init_from_obj(obj)
    self.TotalCores = obj.TotalCores
end

function TTotalCores:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalCores.group)
end

TTotalCores.from_obj = TTotalCores_from_obj

TTotalCores.proto_property = {'TotalCores'}

TTotalCores.default = {0}

TTotalCores.struct = {{name = 'TotalCores', is_array = false, struct = nil}}

function TTotalCores:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalCores', self.TotalCores, 'uint32', true, errs, need_convert)

    TTotalCores:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalCores.proto_property, errs, need_convert)
    return self
end

function TTotalCores:unpack(_)
    return self.TotalCores
end

NPU.TotalCores = TTotalCores

---@class NPU.PowerCapWatts
---@field PowerCapWatts integer
local TPowerCapWatts = {}
TPowerCapWatts.__index = TPowerCapWatts
TPowerCapWatts.group = {}

local function TPowerCapWatts_from_obj(obj)
    return setmetatable(obj, TPowerCapWatts)
end

function TPowerCapWatts.new(PowerCapWatts)
    return TPowerCapWatts_from_obj({PowerCapWatts = PowerCapWatts})
end
---@param obj NPU.PowerCapWatts
function TPowerCapWatts:init_from_obj(obj)
    self.PowerCapWatts = obj.PowerCapWatts
end

function TPowerCapWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCapWatts.group)
end

TPowerCapWatts.from_obj = TPowerCapWatts_from_obj

TPowerCapWatts.proto_property = {'PowerCapWatts'}

TPowerCapWatts.default = {0}

TPowerCapWatts.struct = {{name = 'PowerCapWatts', is_array = false, struct = nil}}

function TPowerCapWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCapWatts', self.PowerCapWatts, 'uint16', true, errs, need_convert)

    TPowerCapWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCapWatts.proto_property, errs, need_convert)
    return self
end

function TPowerCapWatts:unpack(_)
    return self.PowerCapWatts
end

NPU.PowerCapWatts = TPowerCapWatts

---@class NPU.FaultCode
---@field FaultCode string
local TFaultCode = {}
TFaultCode.__index = TFaultCode
TFaultCode.group = {}

local function TFaultCode_from_obj(obj)
    return setmetatable(obj, TFaultCode)
end

function TFaultCode.new(FaultCode)
    return TFaultCode_from_obj({FaultCode = FaultCode})
end
---@param obj NPU.FaultCode
function TFaultCode:init_from_obj(obj)
    self.FaultCode = obj.FaultCode
end

function TFaultCode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFaultCode.group)
end

TFaultCode.from_obj = TFaultCode_from_obj

TFaultCode.proto_property = {'FaultCode'}

TFaultCode.default = {''}

TFaultCode.struct = {{name = 'FaultCode', is_array = false, struct = nil}}

function TFaultCode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FaultCode', self.FaultCode, 'string', true, errs, need_convert)

    TFaultCode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFaultCode.proto_property, errs, need_convert)
    return self
end

function TFaultCode:unpack(_)
    return self.FaultCode
end

NPU.FaultCode = TFaultCode

---@class NPU.DriverVersion
---@field DriverVersion string
local TDriverVersion = {}
TDriverVersion.__index = TDriverVersion
TDriverVersion.group = {}

local function TDriverVersion_from_obj(obj)
    return setmetatable(obj, TDriverVersion)
end

function TDriverVersion.new(DriverVersion)
    return TDriverVersion_from_obj({DriverVersion = DriverVersion})
end
---@param obj NPU.DriverVersion
function TDriverVersion:init_from_obj(obj)
    self.DriverVersion = obj.DriverVersion
end

function TDriverVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDriverVersion.group)
end

TDriverVersion.from_obj = TDriverVersion_from_obj

TDriverVersion.proto_property = {'DriverVersion'}

TDriverVersion.default = {''}

TDriverVersion.struct = {{name = 'DriverVersion', is_array = false, struct = nil}}

function TDriverVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DriverVersion', self.DriverVersion, 'string', true, errs, need_convert)

    TDriverVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDriverVersion.proto_property, errs, need_convert)
    return self
end

function TDriverVersion:unpack(_)
    return self.DriverVersion
end

NPU.DriverVersion = TDriverVersion

---@class NPU.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj NPU.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', true, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

NPU.Version = TVersion

---@class NPU.VendorID
---@field VendorID integer
local TVendorID = {}
TVendorID.__index = TVendorID
TVendorID.group = {}

local function TVendorID_from_obj(obj)
    return setmetatable(obj, TVendorID)
end

function TVendorID.new(VendorID)
    return TVendorID_from_obj({VendorID = VendorID})
end
---@param obj NPU.VendorID
function TVendorID:init_from_obj(obj)
    self.VendorID = obj.VendorID
end

function TVendorID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVendorID.group)
end

TVendorID.from_obj = TVendorID_from_obj

TVendorID.proto_property = {'VendorID'}

TVendorID.default = {0}

TVendorID.struct = {{name = 'VendorID', is_array = false, struct = nil}}

function TVendorID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VendorID', self.VendorID, 'uint16', true, errs, need_convert)

    TVendorID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVendorID.proto_property, errs, need_convert)
    return self
end

function TVendorID:unpack(_)
    return self.VendorID
end

NPU.VendorID = TVendorID

---@class NPU.IErrFlag
---@field IErrFlag integer
local TIErrFlag = {}
TIErrFlag.__index = TIErrFlag
TIErrFlag.group = {}

local function TIErrFlag_from_obj(obj)
    return setmetatable(obj, TIErrFlag)
end

function TIErrFlag.new(IErrFlag)
    return TIErrFlag_from_obj({IErrFlag = IErrFlag})
end
---@param obj NPU.IErrFlag
function TIErrFlag:init_from_obj(obj)
    self.IErrFlag = obj.IErrFlag
end

function TIErrFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIErrFlag.group)
end

TIErrFlag.from_obj = TIErrFlag_from_obj

TIErrFlag.proto_property = {'IErrFlag'}

TIErrFlag.default = {0}

TIErrFlag.struct = {{name = 'IErrFlag', is_array = false, struct = nil}}

function TIErrFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IErrFlag', self.IErrFlag, 'uint32', true, errs, need_convert)

    TIErrFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIErrFlag.proto_property, errs, need_convert)
    return self
end

function TIErrFlag:unpack(_)
    return self.IErrFlag
end

NPU.IErrFlag = TIErrFlag

---@class NPU.ECCAlarmStatus
---@field ECCAlarmStatus integer
local TECCAlarmStatus = {}
TECCAlarmStatus.__index = TECCAlarmStatus
TECCAlarmStatus.group = {}

local function TECCAlarmStatus_from_obj(obj)
    return setmetatable(obj, TECCAlarmStatus)
end

function TECCAlarmStatus.new(ECCAlarmStatus)
    return TECCAlarmStatus_from_obj({ECCAlarmStatus = ECCAlarmStatus})
end
---@param obj NPU.ECCAlarmStatus
function TECCAlarmStatus:init_from_obj(obj)
    self.ECCAlarmStatus = obj.ECCAlarmStatus
end

function TECCAlarmStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TECCAlarmStatus.group)
end

TECCAlarmStatus.from_obj = TECCAlarmStatus_from_obj

TECCAlarmStatus.proto_property = {'ECCAlarmStatus'}

TECCAlarmStatus.default = {0}

TECCAlarmStatus.struct = {{name = 'ECCAlarmStatus', is_array = false, struct = nil}}

function TECCAlarmStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ECCAlarmStatus', self.ECCAlarmStatus, 'uint8', true, errs, need_convert)

    TECCAlarmStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TECCAlarmStatus.proto_property, errs, need_convert)
    return self
end

function TECCAlarmStatus:unpack(_)
    return self.ECCAlarmStatus
end

NPU.ECCAlarmStatus = TECCAlarmStatus

---@class NPU.DiagnosticFault
---@field DiagnosticFault integer
local TDiagnosticFault = {}
TDiagnosticFault.__index = TDiagnosticFault
TDiagnosticFault.group = {}

local function TDiagnosticFault_from_obj(obj)
    return setmetatable(obj, TDiagnosticFault)
end

function TDiagnosticFault.new(DiagnosticFault)
    return TDiagnosticFault_from_obj({DiagnosticFault = DiagnosticFault})
end
---@param obj NPU.DiagnosticFault
function TDiagnosticFault:init_from_obj(obj)
    self.DiagnosticFault = obj.DiagnosticFault
end

function TDiagnosticFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiagnosticFault.group)
end

TDiagnosticFault.from_obj = TDiagnosticFault_from_obj

TDiagnosticFault.proto_property = {'DiagnosticFault'}

TDiagnosticFault.default = {0}

TDiagnosticFault.struct = {{name = 'DiagnosticFault', is_array = false, struct = nil}}

function TDiagnosticFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiagnosticFault', self.DiagnosticFault, 'uint8', false, errs, need_convert)

    TDiagnosticFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiagnosticFault.proto_property, errs, need_convert)
    return self
end

function TDiagnosticFault:unpack(_)
    return self.DiagnosticFault
end

NPU.DiagnosticFault = TDiagnosticFault

---@class NPU.PredictiveFault
---@field PredictiveFault integer
local TPredictiveFault = {}
TPredictiveFault.__index = TPredictiveFault
TPredictiveFault.group = {}

local function TPredictiveFault_from_obj(obj)
    return setmetatable(obj, TPredictiveFault)
end

function TPredictiveFault.new(PredictiveFault)
    return TPredictiveFault_from_obj({PredictiveFault = PredictiveFault})
end
---@param obj NPU.PredictiveFault
function TPredictiveFault:init_from_obj(obj)
    self.PredictiveFault = obj.PredictiveFault
end

function TPredictiveFault:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPredictiveFault.group)
end

TPredictiveFault.from_obj = TPredictiveFault_from_obj

TPredictiveFault.proto_property = {'PredictiveFault'}

TPredictiveFault.default = {0}

TPredictiveFault.struct = {{name = 'PredictiveFault', is_array = false, struct = nil}}

function TPredictiveFault:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PredictiveFault', self.PredictiveFault, 'uint8', false, errs, need_convert)

    TPredictiveFault:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPredictiveFault.proto_property, errs, need_convert)
    return self
end

function TPredictiveFault:unpack(_)
    return self.PredictiveFault
end

NPU.PredictiveFault = TPredictiveFault

---@class NPU.Ierr
---@field Ierr integer
local TIerr = {}
TIerr.__index = TIerr
TIerr.group = {}

local function TIerr_from_obj(obj)
    return setmetatable(obj, TIerr)
end

function TIerr.new(Ierr)
    return TIerr_from_obj({Ierr = Ierr})
end
---@param obj NPU.Ierr
function TIerr:init_from_obj(obj)
    self.Ierr = obj.Ierr
end

function TIerr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIerr.group)
end

TIerr.from_obj = TIerr_from_obj

TIerr.proto_property = {'Ierr'}

TIerr.default = {0}

TIerr.struct = {{name = 'Ierr', is_array = false, struct = nil}}

function TIerr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Ierr', self.Ierr, 'uint8', true, errs, need_convert)

    TIerr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIerr.proto_property, errs, need_convert)
    return self
end

function TIerr:unpack(_)
    return self.Ierr
end

NPU.Ierr = TIerr

---@class NPU.ReadingCelsius
---@field ReadingCelsius integer
local TReadingCelsius = {}
TReadingCelsius.__index = TReadingCelsius
TReadingCelsius.group = {}

local function TReadingCelsius_from_obj(obj)
    return setmetatable(obj, TReadingCelsius)
end

function TReadingCelsius.new(ReadingCelsius)
    return TReadingCelsius_from_obj({ReadingCelsius = ReadingCelsius})
end
---@param obj NPU.ReadingCelsius
function TReadingCelsius:init_from_obj(obj)
    self.ReadingCelsius = obj.ReadingCelsius
end

function TReadingCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadingCelsius.group)
end

TReadingCelsius.from_obj = TReadingCelsius_from_obj

TReadingCelsius.proto_property = {'ReadingCelsius'}

TReadingCelsius.default = {0}

TReadingCelsius.struct = {{name = 'ReadingCelsius', is_array = false, struct = nil}}

function TReadingCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadingCelsius', self.ReadingCelsius, 'uint16', true, errs, need_convert)

    TReadingCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadingCelsius.proto_property, errs, need_convert)
    return self
end

function TReadingCelsius:unpack(_)
    return self.ReadingCelsius
end

NPU.ReadingCelsius = TReadingCelsius

---@class NPU.MemoryBandWidth
---@field MemoryBandWidth integer
local TMemoryBandWidth = {}
TMemoryBandWidth.__index = TMemoryBandWidth
TMemoryBandWidth.group = {}

local function TMemoryBandWidth_from_obj(obj)
    return setmetatable(obj, TMemoryBandWidth)
end

function TMemoryBandWidth.new(MemoryBandWidth)
    return TMemoryBandWidth_from_obj({MemoryBandWidth = MemoryBandWidth})
end
---@param obj NPU.MemoryBandWidth
function TMemoryBandWidth:init_from_obj(obj)
    self.MemoryBandWidth = obj.MemoryBandWidth
end

function TMemoryBandWidth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMemoryBandWidth.group)
end

TMemoryBandWidth.from_obj = TMemoryBandWidth_from_obj

TMemoryBandWidth.proto_property = {'MemoryBandWidth'}

TMemoryBandWidth.default = {0}

TMemoryBandWidth.struct = {{name = 'MemoryBandWidth', is_array = false, struct = nil}}

function TMemoryBandWidth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MemoryBandWidth', self.MemoryBandWidth, 'uint32', true, errs, need_convert)

    TMemoryBandWidth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMemoryBandWidth.proto_property, errs, need_convert)
    return self
end

function TMemoryBandWidth:unpack(_)
    return self.MemoryBandWidth
end

NPU.MemoryBandWidth = TMemoryBandWidth

---@class NPU.RootBDF
---@field RootBDF string
local TRootBDF = {}
TRootBDF.__index = TRootBDF
TRootBDF.group = {}

local function TRootBDF_from_obj(obj)
    return setmetatable(obj, TRootBDF)
end

function TRootBDF.new(RootBDF)
    return TRootBDF_from_obj({RootBDF = RootBDF})
end
---@param obj NPU.RootBDF
function TRootBDF:init_from_obj(obj)
    self.RootBDF = obj.RootBDF
end

function TRootBDF:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRootBDF.group)
end

TRootBDF.from_obj = TRootBDF_from_obj

TRootBDF.proto_property = {'RootBDF'}

TRootBDF.default = {''}

TRootBDF.struct = {{name = 'RootBDF', is_array = false, struct = nil}}

function TRootBDF:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RootBDF', self.RootBDF, 'string', true, errs, need_convert)

    TRootBDF:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRootBDF.proto_property, errs, need_convert)
    return self
end

function TRootBDF:unpack(_)
    return self.RootBDF
end

NPU.RootBDF = TRootBDF

---@class NPU.BDF
---@field BDF string
local TBDF = {}
TBDF.__index = TBDF
TBDF.group = {}

local function TBDF_from_obj(obj)
    return setmetatable(obj, TBDF)
end

function TBDF.new(BDF)
    return TBDF_from_obj({BDF = BDF})
end
---@param obj NPU.BDF
function TBDF:init_from_obj(obj)
    self.BDF = obj.BDF
end

function TBDF:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBDF.group)
end

TBDF.from_obj = TBDF_from_obj

TBDF.proto_property = {'BDF'}

TBDF.default = {''}

TBDF.struct = {{name = 'BDF', is_array = false, struct = nil}}

function TBDF:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BDF', self.BDF, 'string', true, errs, need_convert)

    TBDF:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBDF.proto_property, errs, need_convert)
    return self
end

function TBDF:unpack(_)
    return self.BDF
end

NPU.BDF = TBDF

---@class NPU.VRDChipTemp
---@field VRDChipTemp integer
local TVRDChipTemp = {}
TVRDChipTemp.__index = TVRDChipTemp
TVRDChipTemp.group = {}

local function TVRDChipTemp_from_obj(obj)
    return setmetatable(obj, TVRDChipTemp)
end

function TVRDChipTemp.new(VRDChipTemp)
    return TVRDChipTemp_from_obj({VRDChipTemp = VRDChipTemp})
end
---@param obj NPU.VRDChipTemp
function TVRDChipTemp:init_from_obj(obj)
    self.VRDChipTemp = obj.VRDChipTemp
end

function TVRDChipTemp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVRDChipTemp.group)
end

TVRDChipTemp.from_obj = TVRDChipTemp_from_obj

TVRDChipTemp.proto_property = {'VRDChipTemp'}

TVRDChipTemp.default = {0}

TVRDChipTemp.struct = {{name = 'VRDChipTemp', is_array = false, struct = nil}}

function TVRDChipTemp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VRDChipTemp', self.VRDChipTemp, 'uint16', true, errs, need_convert)

    TVRDChipTemp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVRDChipTemp.proto_property, errs, need_convert)
    return self
end

function TVRDChipTemp:unpack(_)
    return self.VRDChipTemp
end

NPU.VRDChipTemp = TVRDChipTemp

---@class NPU.Power
---@field Power integer
local TPower = {}
TPower.__index = TPower
TPower.group = {}

local function TPower_from_obj(obj)
    return setmetatable(obj, TPower)
end

function TPower.new(Power)
    return TPower_from_obj({Power = Power})
end
---@param obj NPU.Power
function TPower:init_from_obj(obj)
    self.Power = obj.Power
end

function TPower:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPower.group)
end

TPower.from_obj = TPower_from_obj

TPower.proto_property = {'Power'}

TPower.default = {0}

TPower.struct = {{name = 'Power', is_array = false, struct = nil}}

function TPower:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Power', self.Power, 'uint16', true, errs, need_convert)

    TPower:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPower.proto_property, errs, need_convert)
    return self
end

function TPower:unpack(_)
    return self.Power
end

NPU.Power = TPower

---@class NPU.Volt
---@field Volt integer
local TVolt = {}
TVolt.__index = TVolt
TVolt.group = {}

local function TVolt_from_obj(obj)
    return setmetatable(obj, TVolt)
end

function TVolt.new(Volt)
    return TVolt_from_obj({Volt = Volt})
end
---@param obj NPU.Volt
function TVolt:init_from_obj(obj)
    self.Volt = obj.Volt
end

function TVolt:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVolt.group)
end

TVolt.from_obj = TVolt_from_obj

TVolt.proto_property = {'Volt'}

TVolt.default = {0}

TVolt.struct = {{name = 'Volt', is_array = false, struct = nil}}

function TVolt:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Volt', self.Volt, 'uint32', true, errs, need_convert)

    TVolt:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVolt.proto_property, errs, need_convert)
    return self
end

function TVolt:unpack(_)
    return self.Volt
end

NPU.Volt = TVolt

---@class NPU.PowerConsumedWatts
---@field PowerConsumedWatts integer
local TPowerConsumedWatts = {}
TPowerConsumedWatts.__index = TPowerConsumedWatts
TPowerConsumedWatts.group = {}

local function TPowerConsumedWatts_from_obj(obj)
    return setmetatable(obj, TPowerConsumedWatts)
end

function TPowerConsumedWatts.new(PowerConsumedWatts)
    return TPowerConsumedWatts_from_obj({PowerConsumedWatts = PowerConsumedWatts})
end
---@param obj NPU.PowerConsumedWatts
function TPowerConsumedWatts:init_from_obj(obj)
    self.PowerConsumedWatts = obj.PowerConsumedWatts
end

function TPowerConsumedWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerConsumedWatts.group)
end

TPowerConsumedWatts.from_obj = TPowerConsumedWatts_from_obj

TPowerConsumedWatts.proto_property = {'PowerConsumedWatts'}

TPowerConsumedWatts.default = {0}

TPowerConsumedWatts.struct = {{name = 'PowerConsumedWatts', is_array = false, struct = nil}}

function TPowerConsumedWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerConsumedWatts', self.PowerConsumedWatts, 'uint16', true, errs, need_convert)

    TPowerConsumedWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerConsumedWatts.proto_property, errs, need_convert)
    return self
end

function TPowerConsumedWatts:unpack(_)
    return self.PowerConsumedWatts
end

NPU.PowerConsumedWatts = TPowerConsumedWatts

---@class NPU.PowerCapacityWatts
---@field PowerCapacityWatts integer
local TPowerCapacityWatts = {}
TPowerCapacityWatts.__index = TPowerCapacityWatts
TPowerCapacityWatts.group = {}

local function TPowerCapacityWatts_from_obj(obj)
    return setmetatable(obj, TPowerCapacityWatts)
end

function TPowerCapacityWatts.new(PowerCapacityWatts)
    return TPowerCapacityWatts_from_obj({PowerCapacityWatts = PowerCapacityWatts})
end
---@param obj NPU.PowerCapacityWatts
function TPowerCapacityWatts:init_from_obj(obj)
    self.PowerCapacityWatts = obj.PowerCapacityWatts
end

function TPowerCapacityWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCapacityWatts.group)
end

TPowerCapacityWatts.from_obj = TPowerCapacityWatts_from_obj

TPowerCapacityWatts.proto_property = {'PowerCapacityWatts'}

TPowerCapacityWatts.default = {0}

TPowerCapacityWatts.struct = {{name = 'PowerCapacityWatts', is_array = false, struct = nil}}

function TPowerCapacityWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCapacityWatts', self.PowerCapacityWatts, 'uint32', true, errs, need_convert)

    TPowerCapacityWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCapacityWatts.proto_property, errs, need_convert)
    return self
end

function TPowerCapacityWatts:unpack(_)
    return self.PowerCapacityWatts
end

NPU.PowerCapacityWatts = TPowerCapacityWatts

---@class NPU.PowerState
---@field PowerState string
local TPowerState = {}
TPowerState.__index = TPowerState
TPowerState.group = {}

local function TPowerState_from_obj(obj)
    return setmetatable(obj, TPowerState)
end

function TPowerState.new(PowerState)
    return TPowerState_from_obj({PowerState = PowerState})
end
---@param obj NPU.PowerState
function TPowerState:init_from_obj(obj)
    self.PowerState = obj.PowerState
end

function TPowerState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerState.group)
end

TPowerState.from_obj = TPowerState_from_obj

TPowerState.proto_property = {'PowerState'}

TPowerState.default = {''}

TPowerState.struct = {{name = 'PowerState', is_array = false, struct = nil}}

function TPowerState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerState', self.PowerState, 'string', true, errs, need_convert)

    TPowerState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerState.proto_property, errs, need_convert)
    return self
end

function TPowerState:unpack(_)
    return self.PowerState
end

NPU.PowerState = TPowerState

---@class NPU.PowerOn
---@field PowerOn integer
local TPowerOn = {}
TPowerOn.__index = TPowerOn
TPowerOn.group = {}

local function TPowerOn_from_obj(obj)
    return setmetatable(obj, TPowerOn)
end

function TPowerOn.new(PowerOn)
    return TPowerOn_from_obj({PowerOn = PowerOn})
end
---@param obj NPU.PowerOn
function TPowerOn:init_from_obj(obj)
    self.PowerOn = obj.PowerOn
end

function TPowerOn:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerOn.group)
end

TPowerOn.from_obj = TPowerOn_from_obj

TPowerOn.proto_property = {'PowerOn'}

TPowerOn.default = {0}

TPowerOn.struct = {{name = 'PowerOn', is_array = false, struct = nil}}

function TPowerOn:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerOn', self.PowerOn, 'uint8', true, errs, need_convert)

    TPowerOn:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerOn.proto_property, errs, need_convert)
    return self
end

function TPowerOn:unpack(_)
    return self.PowerOn
end

NPU.PowerOn = TPowerOn

---@class NPU.HBMTemp
---@field HBMTemp integer
local THBMTemp = {}
THBMTemp.__index = THBMTemp
THBMTemp.group = {}

local function THBMTemp_from_obj(obj)
    return setmetatable(obj, THBMTemp)
end

function THBMTemp.new(HBMTemp)
    return THBMTemp_from_obj({HBMTemp = HBMTemp})
end
---@param obj NPU.HBMTemp
function THBMTemp:init_from_obj(obj)
    self.HBMTemp = obj.HBMTemp
end

function THBMTemp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THBMTemp.group)
end

THBMTemp.from_obj = THBMTemp_from_obj

THBMTemp.proto_property = {'HBMTemp'}

THBMTemp.default = {0}

THBMTemp.struct = {{name = 'HBMTemp', is_array = false, struct = nil}}

function THBMTemp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HBMTemp', self.HBMTemp, 'uint16', true, errs, need_convert)

    THBMTemp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THBMTemp.proto_property, errs, need_convert)
    return self
end

function THBMTemp:unpack(_)
    return self.HBMTemp
end

NPU.HBMTemp = THBMTemp

---@class NPU.AiCoreTemp
---@field AiCoreTemp integer
local TAiCoreTemp = {}
TAiCoreTemp.__index = TAiCoreTemp
TAiCoreTemp.group = {}

local function TAiCoreTemp_from_obj(obj)
    return setmetatable(obj, TAiCoreTemp)
end

function TAiCoreTemp.new(AiCoreTemp)
    return TAiCoreTemp_from_obj({AiCoreTemp = AiCoreTemp})
end
---@param obj NPU.AiCoreTemp
function TAiCoreTemp:init_from_obj(obj)
    self.AiCoreTemp = obj.AiCoreTemp
end

function TAiCoreTemp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAiCoreTemp.group)
end

TAiCoreTemp.from_obj = TAiCoreTemp_from_obj

TAiCoreTemp.proto_property = {'AiCoreTemp'}

TAiCoreTemp.default = {0}

TAiCoreTemp.struct = {{name = 'AiCoreTemp', is_array = false, struct = nil}}

function TAiCoreTemp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AiCoreTemp', self.AiCoreTemp, 'uint16', true, errs, need_convert)

    TAiCoreTemp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAiCoreTemp.proto_property, errs, need_convert)
    return self
end

function TAiCoreTemp:unpack(_)
    return self.AiCoreTemp
end

NPU.AiCoreTemp = TAiCoreTemp

---@class NPU.NimBusTemp
---@field NimBusTemp integer
local TNimBusTemp = {}
TNimBusTemp.__index = TNimBusTemp
TNimBusTemp.group = {}

local function TNimBusTemp_from_obj(obj)
    return setmetatable(obj, TNimBusTemp)
end

function TNimBusTemp.new(NimBusTemp)
    return TNimBusTemp_from_obj({NimBusTemp = NimBusTemp})
end
---@param obj NPU.NimBusTemp
function TNimBusTemp:init_from_obj(obj)
    self.NimBusTemp = obj.NimBusTemp
end

function TNimBusTemp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNimBusTemp.group)
end

TNimBusTemp.from_obj = TNimBusTemp_from_obj

TNimBusTemp.proto_property = {'NimBusTemp'}

TNimBusTemp.default = {0}

TNimBusTemp.struct = {{name = 'NimBusTemp', is_array = false, struct = nil}}

function TNimBusTemp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NimBusTemp', self.NimBusTemp, 'uint16', true, errs, need_convert)

    TNimBusTemp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNimBusTemp.proto_property, errs, need_convert)
    return self
end

function TNimBusTemp:unpack(_)
    return self.NimBusTemp
end

NPU.NimBusTemp = TNimBusTemp

---@class NPU.ComputeCapability
---@field ComputeCapability string
local TComputeCapability = {}
TComputeCapability.__index = TComputeCapability
TComputeCapability.group = {}

local function TComputeCapability_from_obj(obj)
    return setmetatable(obj, TComputeCapability)
end

function TComputeCapability.new(ComputeCapability)
    return TComputeCapability_from_obj({ComputeCapability = ComputeCapability})
end
---@param obj NPU.ComputeCapability
function TComputeCapability:init_from_obj(obj)
    self.ComputeCapability = obj.ComputeCapability
end

function TComputeCapability:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TComputeCapability.group)
end

TComputeCapability.from_obj = TComputeCapability_from_obj

TComputeCapability.proto_property = {'ComputeCapability'}

TComputeCapability.default = {''}

TComputeCapability.struct = {{name = 'ComputeCapability', is_array = false, struct = nil}}

function TComputeCapability:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComputeCapability', self.ComputeCapability, 'string', true, errs, need_convert)

    TComputeCapability:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TComputeCapability.proto_property, errs, need_convert)
    return self
end

function TComputeCapability:unpack(_)
    return self.ComputeCapability
end

NPU.ComputeCapability = TComputeCapability

---@class NPU.CtrlCPUUsagePercent
---@field CtrlCPUUsagePercent integer
local TCtrlCPUUsagePercent = {}
TCtrlCPUUsagePercent.__index = TCtrlCPUUsagePercent
TCtrlCPUUsagePercent.group = {}

local function TCtrlCPUUsagePercent_from_obj(obj)
    return setmetatable(obj, TCtrlCPUUsagePercent)
end

function TCtrlCPUUsagePercent.new(CtrlCPUUsagePercent)
    return TCtrlCPUUsagePercent_from_obj({CtrlCPUUsagePercent = CtrlCPUUsagePercent})
end
---@param obj NPU.CtrlCPUUsagePercent
function TCtrlCPUUsagePercent:init_from_obj(obj)
    self.CtrlCPUUsagePercent = obj.CtrlCPUUsagePercent
end

function TCtrlCPUUsagePercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCtrlCPUUsagePercent.group)
end

TCtrlCPUUsagePercent.from_obj = TCtrlCPUUsagePercent_from_obj

TCtrlCPUUsagePercent.proto_property = {'CtrlCPUUsagePercent'}

TCtrlCPUUsagePercent.default = {0}

TCtrlCPUUsagePercent.struct = {{name = 'CtrlCPUUsagePercent', is_array = false, struct = nil}}

function TCtrlCPUUsagePercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CtrlCPUUsagePercent', self.CtrlCPUUsagePercent, 'uint16', true, errs, need_convert)

    TCtrlCPUUsagePercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCtrlCPUUsagePercent.proto_property, errs, need_convert)
    return self
end

function TCtrlCPUUsagePercent:unpack(_)
    return self.CtrlCPUUsagePercent
end

NPU.CtrlCPUUsagePercent = TCtrlCPUUsagePercent

---@class NPU.AiCoreCurrentSpeedMHz
---@field AiCoreCurrentSpeedMHz integer
local TAiCoreCurrentSpeedMHz = {}
TAiCoreCurrentSpeedMHz.__index = TAiCoreCurrentSpeedMHz
TAiCoreCurrentSpeedMHz.group = {}

local function TAiCoreCurrentSpeedMHz_from_obj(obj)
    return setmetatable(obj, TAiCoreCurrentSpeedMHz)
end

function TAiCoreCurrentSpeedMHz.new(AiCoreCurrentSpeedMHz)
    return TAiCoreCurrentSpeedMHz_from_obj({AiCoreCurrentSpeedMHz = AiCoreCurrentSpeedMHz})
end
---@param obj NPU.AiCoreCurrentSpeedMHz
function TAiCoreCurrentSpeedMHz:init_from_obj(obj)
    self.AiCoreCurrentSpeedMHz = obj.AiCoreCurrentSpeedMHz
end

function TAiCoreCurrentSpeedMHz:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAiCoreCurrentSpeedMHz.group)
end

TAiCoreCurrentSpeedMHz.from_obj = TAiCoreCurrentSpeedMHz_from_obj

TAiCoreCurrentSpeedMHz.proto_property = {'AiCoreCurrentSpeedMHz'}

TAiCoreCurrentSpeedMHz.default = {0}

TAiCoreCurrentSpeedMHz.struct = {{name = 'AiCoreCurrentSpeedMHz', is_array = false, struct = nil}}

function TAiCoreCurrentSpeedMHz:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AiCoreCurrentSpeedMHz', self.AiCoreCurrentSpeedMHz, 'uint16', true, errs, need_convert)

    TAiCoreCurrentSpeedMHz:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAiCoreCurrentSpeedMHz.proto_property, errs, need_convert)
    return self
end

function TAiCoreCurrentSpeedMHz:unpack(_)
    return self.AiCoreCurrentSpeedMHz
end

NPU.AiCoreCurrentSpeedMHz = TAiCoreCurrentSpeedMHz

---@class NPU.AiCoreMaxSpeedMHz
---@field AiCoreMaxSpeedMHz integer
local TAiCoreMaxSpeedMHz = {}
TAiCoreMaxSpeedMHz.__index = TAiCoreMaxSpeedMHz
TAiCoreMaxSpeedMHz.group = {}

local function TAiCoreMaxSpeedMHz_from_obj(obj)
    return setmetatable(obj, TAiCoreMaxSpeedMHz)
end

function TAiCoreMaxSpeedMHz.new(AiCoreMaxSpeedMHz)
    return TAiCoreMaxSpeedMHz_from_obj({AiCoreMaxSpeedMHz = AiCoreMaxSpeedMHz})
end
---@param obj NPU.AiCoreMaxSpeedMHz
function TAiCoreMaxSpeedMHz:init_from_obj(obj)
    self.AiCoreMaxSpeedMHz = obj.AiCoreMaxSpeedMHz
end

function TAiCoreMaxSpeedMHz:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAiCoreMaxSpeedMHz.group)
end

TAiCoreMaxSpeedMHz.from_obj = TAiCoreMaxSpeedMHz_from_obj

TAiCoreMaxSpeedMHz.proto_property = {'AiCoreMaxSpeedMHz'}

TAiCoreMaxSpeedMHz.default = {0}

TAiCoreMaxSpeedMHz.struct = {{name = 'AiCoreMaxSpeedMHz', is_array = false, struct = nil}}

function TAiCoreMaxSpeedMHz:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AiCoreMaxSpeedMHz', self.AiCoreMaxSpeedMHz, 'uint16', true, errs, need_convert)

    TAiCoreMaxSpeedMHz:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAiCoreMaxSpeedMHz.proto_property, errs, need_convert)
    return self
end

function TAiCoreMaxSpeedMHz:unpack(_)
    return self.AiCoreMaxSpeedMHz
end

NPU.AiCoreMaxSpeedMHz = TAiCoreMaxSpeedMHz

---@class NPU.AiCoreUsagePercent
---@field AiCoreUsagePercent integer
local TAiCoreUsagePercent = {}
TAiCoreUsagePercent.__index = TAiCoreUsagePercent
TAiCoreUsagePercent.group = {}

local function TAiCoreUsagePercent_from_obj(obj)
    return setmetatable(obj, TAiCoreUsagePercent)
end

function TAiCoreUsagePercent.new(AiCoreUsagePercent)
    return TAiCoreUsagePercent_from_obj({AiCoreUsagePercent = AiCoreUsagePercent})
end
---@param obj NPU.AiCoreUsagePercent
function TAiCoreUsagePercent:init_from_obj(obj)
    self.AiCoreUsagePercent = obj.AiCoreUsagePercent
end

function TAiCoreUsagePercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAiCoreUsagePercent.group)
end

TAiCoreUsagePercent.from_obj = TAiCoreUsagePercent_from_obj

TAiCoreUsagePercent.proto_property = {'AiCoreUsagePercent'}

TAiCoreUsagePercent.default = {0}

TAiCoreUsagePercent.struct = {{name = 'AiCoreUsagePercent', is_array = false, struct = nil}}

function TAiCoreUsagePercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AiCoreUsagePercent', self.AiCoreUsagePercent, 'uint16', true, errs, need_convert)

    TAiCoreUsagePercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAiCoreUsagePercent.proto_property, errs, need_convert)
    return self
end

function TAiCoreUsagePercent:unpack(_)
    return self.AiCoreUsagePercent
end

NPU.AiCoreUsagePercent = TAiCoreUsagePercent

---@class NPU.MemUsagePercent
---@field MemUsagePercent integer
local TMemUsagePercent = {}
TMemUsagePercent.__index = TMemUsagePercent
TMemUsagePercent.group = {}

local function TMemUsagePercent_from_obj(obj)
    return setmetatable(obj, TMemUsagePercent)
end

function TMemUsagePercent.new(MemUsagePercent)
    return TMemUsagePercent_from_obj({MemUsagePercent = MemUsagePercent})
end
---@param obj NPU.MemUsagePercent
function TMemUsagePercent:init_from_obj(obj)
    self.MemUsagePercent = obj.MemUsagePercent
end

function TMemUsagePercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMemUsagePercent.group)
end

TMemUsagePercent.from_obj = TMemUsagePercent_from_obj

TMemUsagePercent.proto_property = {'MemUsagePercent'}

TMemUsagePercent.default = {0}

TMemUsagePercent.struct = {{name = 'MemUsagePercent', is_array = false, struct = nil}}

function TMemUsagePercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MemUsagePercent', self.MemUsagePercent, 'uint16', true, errs, need_convert)

    TMemUsagePercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMemUsagePercent.proto_property, errs, need_convert)
    return self
end

function TMemUsagePercent:unpack(_)
    return self.MemUsagePercent
end

NPU.MemUsagePercent = TMemUsagePercent

---@class NPU.HBMUsagePercent
---@field HBMUsagePercent integer
local THBMUsagePercent = {}
THBMUsagePercent.__index = THBMUsagePercent
THBMUsagePercent.group = {}

local function THBMUsagePercent_from_obj(obj)
    return setmetatable(obj, THBMUsagePercent)
end

function THBMUsagePercent.new(HBMUsagePercent)
    return THBMUsagePercent_from_obj({HBMUsagePercent = HBMUsagePercent})
end
---@param obj NPU.HBMUsagePercent
function THBMUsagePercent:init_from_obj(obj)
    self.HBMUsagePercent = obj.HBMUsagePercent
end

function THBMUsagePercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THBMUsagePercent.group)
end

THBMUsagePercent.from_obj = THBMUsagePercent_from_obj

THBMUsagePercent.proto_property = {'HBMUsagePercent'}

THBMUsagePercent.default = {0}

THBMUsagePercent.struct = {{name = 'HBMUsagePercent', is_array = false, struct = nil}}

function THBMUsagePercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HBMUsagePercent', self.HBMUsagePercent, 'uint16', true, errs, need_convert)

    THBMUsagePercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THBMUsagePercent.proto_property, errs, need_convert)
    return self
end

function THBMUsagePercent:unpack(_)
    return self.HBMUsagePercent
end

NPU.HBMUsagePercent = THBMUsagePercent

---@class NPU.MemBWUsagePercent
---@field MemBWUsagePercent integer
local TMemBWUsagePercent = {}
TMemBWUsagePercent.__index = TMemBWUsagePercent
TMemBWUsagePercent.group = {}

local function TMemBWUsagePercent_from_obj(obj)
    return setmetatable(obj, TMemBWUsagePercent)
end

function TMemBWUsagePercent.new(MemBWUsagePercent)
    return TMemBWUsagePercent_from_obj({MemBWUsagePercent = MemBWUsagePercent})
end
---@param obj NPU.MemBWUsagePercent
function TMemBWUsagePercent:init_from_obj(obj)
    self.MemBWUsagePercent = obj.MemBWUsagePercent
end

function TMemBWUsagePercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMemBWUsagePercent.group)
end

TMemBWUsagePercent.from_obj = TMemBWUsagePercent_from_obj

TMemBWUsagePercent.proto_property = {'MemBWUsagePercent'}

TMemBWUsagePercent.default = {0}

TMemBWUsagePercent.struct = {{name = 'MemBWUsagePercent', is_array = false, struct = nil}}

function TMemBWUsagePercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MemBWUsagePercent', self.MemBWUsagePercent, 'uint16', true, errs, need_convert)

    TMemBWUsagePercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMemBWUsagePercent.proto_property, errs, need_convert)
    return self
end

function TMemBWUsagePercent:unpack(_)
    return self.MemBWUsagePercent
end

NPU.MemBWUsagePercent = TMemBWUsagePercent

---@class NPU.HBMBWUsagePercent
---@field HBMBWUsagePercent integer
local THBMBWUsagePercent = {}
THBMBWUsagePercent.__index = THBMBWUsagePercent
THBMBWUsagePercent.group = {}

local function THBMBWUsagePercent_from_obj(obj)
    return setmetatable(obj, THBMBWUsagePercent)
end

function THBMBWUsagePercent.new(HBMBWUsagePercent)
    return THBMBWUsagePercent_from_obj({HBMBWUsagePercent = HBMBWUsagePercent})
end
---@param obj NPU.HBMBWUsagePercent
function THBMBWUsagePercent:init_from_obj(obj)
    self.HBMBWUsagePercent = obj.HBMBWUsagePercent
end

function THBMBWUsagePercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THBMBWUsagePercent.group)
end

THBMBWUsagePercent.from_obj = THBMBWUsagePercent_from_obj

THBMBWUsagePercent.proto_property = {'HBMBWUsagePercent'}

THBMBWUsagePercent.default = {0}

THBMBWUsagePercent.struct = {{name = 'HBMBWUsagePercent', is_array = false, struct = nil}}

function THBMBWUsagePercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HBMBWUsagePercent', self.HBMBWUsagePercent, 'uint16', true, errs, need_convert)

    THBMBWUsagePercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THBMBWUsagePercent.proto_property, errs, need_convert)
    return self
end

function THBMBWUsagePercent:unpack(_)
    return self.HBMBWUsagePercent
end

NPU.HBMBWUsagePercent = THBMBWUsagePercent

---@class NPU.AiCPUUsagePercent
---@field AiCPUUsagePercent integer
local TAiCPUUsagePercent = {}
TAiCPUUsagePercent.__index = TAiCPUUsagePercent
TAiCPUUsagePercent.group = {}

local function TAiCPUUsagePercent_from_obj(obj)
    return setmetatable(obj, TAiCPUUsagePercent)
end

function TAiCPUUsagePercent.new(AiCPUUsagePercent)
    return TAiCPUUsagePercent_from_obj({AiCPUUsagePercent = AiCPUUsagePercent})
end
---@param obj NPU.AiCPUUsagePercent
function TAiCPUUsagePercent:init_from_obj(obj)
    self.AiCPUUsagePercent = obj.AiCPUUsagePercent
end

function TAiCPUUsagePercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAiCPUUsagePercent.group)
end

TAiCPUUsagePercent.from_obj = TAiCPUUsagePercent_from_obj

TAiCPUUsagePercent.proto_property = {'AiCPUUsagePercent'}

TAiCPUUsagePercent.default = {0}

TAiCPUUsagePercent.struct = {{name = 'AiCPUUsagePercent', is_array = false, struct = nil}}

function TAiCPUUsagePercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AiCPUUsagePercent', self.AiCPUUsagePercent, 'uint16', true, errs, need_convert)

    TAiCPUUsagePercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAiCPUUsagePercent.proto_property, errs, need_convert)
    return self
end

function TAiCPUUsagePercent:unpack(_)
    return self.AiCPUUsagePercent
end

NPU.AiCPUUsagePercent = TAiCPUUsagePercent

---@class NPU.SingleBitEcc
---@field SingleBitEcc string
local TSingleBitEcc = {}
TSingleBitEcc.__index = TSingleBitEcc
TSingleBitEcc.group = {}

local function TSingleBitEcc_from_obj(obj)
    return setmetatable(obj, TSingleBitEcc)
end

function TSingleBitEcc.new(SingleBitEcc)
    return TSingleBitEcc_from_obj({SingleBitEcc = SingleBitEcc})
end
---@param obj NPU.SingleBitEcc
function TSingleBitEcc:init_from_obj(obj)
    self.SingleBitEcc = obj.SingleBitEcc
end

function TSingleBitEcc:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSingleBitEcc.group)
end

TSingleBitEcc.from_obj = TSingleBitEcc_from_obj

TSingleBitEcc.proto_property = {'SingleBitEcc'}

TSingleBitEcc.default = {''}

TSingleBitEcc.struct = {{name = 'SingleBitEcc', is_array = false, struct = nil}}

function TSingleBitEcc:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SingleBitEcc', self.SingleBitEcc, 'string', true, errs, need_convert)

    TSingleBitEcc:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSingleBitEcc.proto_property, errs, need_convert)
    return self
end

function TSingleBitEcc:unpack(_)
    return self.SingleBitEcc
end

NPU.SingleBitEcc = TSingleBitEcc

---@class NPU.MultiBitEcc
---@field MultiBitEcc string
local TMultiBitEcc = {}
TMultiBitEcc.__index = TMultiBitEcc
TMultiBitEcc.group = {}

local function TMultiBitEcc_from_obj(obj)
    return setmetatable(obj, TMultiBitEcc)
end

function TMultiBitEcc.new(MultiBitEcc)
    return TMultiBitEcc_from_obj({MultiBitEcc = MultiBitEcc})
end
---@param obj NPU.MultiBitEcc
function TMultiBitEcc:init_from_obj(obj)
    self.MultiBitEcc = obj.MultiBitEcc
end

function TMultiBitEcc:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMultiBitEcc.group)
end

TMultiBitEcc.from_obj = TMultiBitEcc_from_obj

TMultiBitEcc.proto_property = {'MultiBitEcc'}

TMultiBitEcc.default = {''}

TMultiBitEcc.struct = {{name = 'MultiBitEcc', is_array = false, struct = nil}}

function TMultiBitEcc:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MultiBitEcc', self.MultiBitEcc, 'string', true, errs, need_convert)

    TMultiBitEcc:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMultiBitEcc.proto_property, errs, need_convert)
    return self
end

function TMultiBitEcc:unpack(_)
    return self.MultiBitEcc
end

NPU.MultiBitEcc = TMultiBitEcc

---@class NPU.MemoryCapacityKiB
---@field MemoryCapacityKiB integer
local TMemoryCapacityKiB = {}
TMemoryCapacityKiB.__index = TMemoryCapacityKiB
TMemoryCapacityKiB.group = {}

local function TMemoryCapacityKiB_from_obj(obj)
    return setmetatable(obj, TMemoryCapacityKiB)
end

function TMemoryCapacityKiB.new(MemoryCapacityKiB)
    return TMemoryCapacityKiB_from_obj({MemoryCapacityKiB = MemoryCapacityKiB})
end
---@param obj NPU.MemoryCapacityKiB
function TMemoryCapacityKiB:init_from_obj(obj)
    self.MemoryCapacityKiB = obj.MemoryCapacityKiB
end

function TMemoryCapacityKiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMemoryCapacityKiB.group)
end

TMemoryCapacityKiB.from_obj = TMemoryCapacityKiB_from_obj

TMemoryCapacityKiB.proto_property = {'MemoryCapacityKiB'}

TMemoryCapacityKiB.default = {0}

TMemoryCapacityKiB.struct = {{name = 'MemoryCapacityKiB', is_array = false, struct = nil}}

function TMemoryCapacityKiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MemoryCapacityKiB', self.MemoryCapacityKiB, 'uint32', true, errs, need_convert)

    TMemoryCapacityKiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMemoryCapacityKiB.proto_property, errs, need_convert)
    return self
end

function TMemoryCapacityKiB:unpack(_)
    return self.MemoryCapacityKiB
end

NPU.MemoryCapacityKiB = TMemoryCapacityKiB

---@class NPU.CapabilitySupportMask
---@field CapabilitySupportMask integer
local TCapabilitySupportMask = {}
TCapabilitySupportMask.__index = TCapabilitySupportMask
TCapabilitySupportMask.group = {}

local function TCapabilitySupportMask_from_obj(obj)
    return setmetatable(obj, TCapabilitySupportMask)
end

function TCapabilitySupportMask.new(CapabilitySupportMask)
    return TCapabilitySupportMask_from_obj({CapabilitySupportMask = CapabilitySupportMask})
end
---@param obj NPU.CapabilitySupportMask
function TCapabilitySupportMask:init_from_obj(obj)
    self.CapabilitySupportMask = obj.CapabilitySupportMask
end

function TCapabilitySupportMask:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCapabilitySupportMask.group)
end

TCapabilitySupportMask.from_obj = TCapabilitySupportMask_from_obj

TCapabilitySupportMask.proto_property = {'CapabilitySupportMask'}

TCapabilitySupportMask.default = {0}

TCapabilitySupportMask.struct = {{name = 'CapabilitySupportMask', is_array = false, struct = nil}}

function TCapabilitySupportMask:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CapabilitySupportMask', self.CapabilitySupportMask, 'uint32', true, errs, need_convert)

    TCapabilitySupportMask:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCapabilitySupportMask.proto_property, errs, need_convert)
    return self
end

function TCapabilitySupportMask:unpack(_)
    return self.CapabilitySupportMask
end

NPU.CapabilitySupportMask = TCapabilitySupportMask

---@class NPU.MemoryFreeKiB
---@field MemoryFreeKiB integer
local TMemoryFreeKiB = {}
TMemoryFreeKiB.__index = TMemoryFreeKiB
TMemoryFreeKiB.group = {}

local function TMemoryFreeKiB_from_obj(obj)
    return setmetatable(obj, TMemoryFreeKiB)
end

function TMemoryFreeKiB.new(MemoryFreeKiB)
    return TMemoryFreeKiB_from_obj({MemoryFreeKiB = MemoryFreeKiB})
end
---@param obj NPU.MemoryFreeKiB
function TMemoryFreeKiB:init_from_obj(obj)
    self.MemoryFreeKiB = obj.MemoryFreeKiB
end

function TMemoryFreeKiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMemoryFreeKiB.group)
end

TMemoryFreeKiB.from_obj = TMemoryFreeKiB_from_obj

TMemoryFreeKiB.proto_property = {'MemoryFreeKiB'}

TMemoryFreeKiB.default = {0}

TMemoryFreeKiB.struct = {{name = 'MemoryFreeKiB', is_array = false, struct = nil}}

function TMemoryFreeKiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MemoryFreeKiB', self.MemoryFreeKiB, 'uint32', true, errs, need_convert)

    TMemoryFreeKiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMemoryFreeKiB.proto_property, errs, need_convert)
    return self
end

function TMemoryFreeKiB:unpack(_)
    return self.MemoryFreeKiB
end

NPU.MemoryFreeKiB = TMemoryFreeKiB

---@class NPU.MemoryUsageKiB
---@field MemoryUsageKiB integer
local TMemoryUsageKiB = {}
TMemoryUsageKiB.__index = TMemoryUsageKiB
TMemoryUsageKiB.group = {}

local function TMemoryUsageKiB_from_obj(obj)
    return setmetatable(obj, TMemoryUsageKiB)
end

function TMemoryUsageKiB.new(MemoryUsageKiB)
    return TMemoryUsageKiB_from_obj({MemoryUsageKiB = MemoryUsageKiB})
end
---@param obj NPU.MemoryUsageKiB
function TMemoryUsageKiB:init_from_obj(obj)
    self.MemoryUsageKiB = obj.MemoryUsageKiB
end

function TMemoryUsageKiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMemoryUsageKiB.group)
end

TMemoryUsageKiB.from_obj = TMemoryUsageKiB_from_obj

TMemoryUsageKiB.proto_property = {'MemoryUsageKiB'}

TMemoryUsageKiB.default = {0}

TMemoryUsageKiB.struct = {{name = 'MemoryUsageKiB', is_array = false, struct = nil}}

function TMemoryUsageKiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MemoryUsageKiB', self.MemoryUsageKiB, 'uint32', true, errs, need_convert)

    TMemoryUsageKiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMemoryUsageKiB.proto_property, errs, need_convert)
    return self
end

function TMemoryUsageKiB:unpack(_)
    return self.MemoryUsageKiB
end

NPU.MemoryUsageKiB = TMemoryUsageKiB

---@class NPU.TotalMemoryKiB
---@field TotalMemoryKiB integer
local TTotalMemoryKiB = {}
TTotalMemoryKiB.__index = TTotalMemoryKiB
TTotalMemoryKiB.group = {}

local function TTotalMemoryKiB_from_obj(obj)
    return setmetatable(obj, TTotalMemoryKiB)
end

function TTotalMemoryKiB.new(TotalMemoryKiB)
    return TTotalMemoryKiB_from_obj({TotalMemoryKiB = TotalMemoryKiB})
end
---@param obj NPU.TotalMemoryKiB
function TTotalMemoryKiB:init_from_obj(obj)
    self.TotalMemoryKiB = obj.TotalMemoryKiB
end

function TTotalMemoryKiB:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTotalMemoryKiB.group)
end

TTotalMemoryKiB.from_obj = TTotalMemoryKiB_from_obj

TTotalMemoryKiB.proto_property = {'TotalMemoryKiB'}

TTotalMemoryKiB.default = {0}

TTotalMemoryKiB.struct = {{name = 'TotalMemoryKiB', is_array = false, struct = nil}}

function TTotalMemoryKiB:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TotalMemoryKiB', self.TotalMemoryKiB, 'uint32', true, errs, need_convert)

    TTotalMemoryKiB:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTotalMemoryKiB.proto_property, errs, need_convert)
    return self
end

function TTotalMemoryKiB:unpack(_)
    return self.TotalMemoryKiB
end

NPU.TotalMemoryKiB = TTotalMemoryKiB

---@class NPU.GetEccInfoRsp
---@field SingleBitEcc string
---@field MultiBitEcc string
---@field SingleBitIsolatedPages string
---@field MultiBitIsolatedPages string
local TGetEccInfoRsp = {}
TGetEccInfoRsp.__index = TGetEccInfoRsp
TGetEccInfoRsp.group = {}

local function TGetEccInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetEccInfoRsp)
end

function TGetEccInfoRsp.new(SingleBitEcc, MultiBitEcc, SingleBitIsolatedPages, MultiBitIsolatedPages)
    return TGetEccInfoRsp_from_obj({
        SingleBitEcc = SingleBitEcc,
        MultiBitEcc = MultiBitEcc,
        SingleBitIsolatedPages = SingleBitIsolatedPages,
        MultiBitIsolatedPages = MultiBitIsolatedPages
    })
end
---@param obj NPU.GetEccInfoRsp
function TGetEccInfoRsp:init_from_obj(obj)
    self.SingleBitEcc = obj.SingleBitEcc
    self.MultiBitEcc = obj.MultiBitEcc
    self.SingleBitIsolatedPages = obj.SingleBitIsolatedPages
    self.MultiBitIsolatedPages = obj.MultiBitIsolatedPages
end

function TGetEccInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEccInfoRsp.group)
end

TGetEccInfoRsp.from_obj = TGetEccInfoRsp_from_obj

TGetEccInfoRsp.proto_property = {'SingleBitEcc', 'MultiBitEcc', 'SingleBitIsolatedPages', 'MultiBitIsolatedPages'}

TGetEccInfoRsp.default = {'', '', '', ''}

TGetEccInfoRsp.struct = {
    {name = 'SingleBitEcc', is_array = false, struct = nil}, {name = 'MultiBitEcc', is_array = false, struct = nil},
    {name = 'SingleBitIsolatedPages', is_array = false, struct = nil},
    {name = 'MultiBitIsolatedPages', is_array = false, struct = nil}
}

function TGetEccInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SingleBitEcc', self.SingleBitEcc, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'MultiBitEcc', self.MultiBitEcc, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SingleBitIsolatedPages', self.SingleBitIsolatedPages, 'string', false, errs,
        need_convert)
    validate.Optional(prefix .. 'MultiBitIsolatedPages', self.MultiBitIsolatedPages, 'string', false, errs, need_convert)

    TGetEccInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEccInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetEccInfoRsp:unpack(_)
    return self.SingleBitEcc, self.MultiBitEcc, self.SingleBitIsolatedPages, self.MultiBitIsolatedPages
end

NPU.GetEccInfoRsp = TGetEccInfoRsp

---@class NPU.GetEccInfoReq
---@field Id integer
local TGetEccInfoReq = {}
TGetEccInfoReq.__index = TGetEccInfoReq
TGetEccInfoReq.group = {}

local function TGetEccInfoReq_from_obj(obj)
    return setmetatable(obj, TGetEccInfoReq)
end

function TGetEccInfoReq.new(Id)
    return TGetEccInfoReq_from_obj({Id = Id})
end
---@param obj NPU.GetEccInfoReq
function TGetEccInfoReq:init_from_obj(obj)
    self.Id = obj.Id
end

function TGetEccInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEccInfoReq.group)
end

TGetEccInfoReq.from_obj = TGetEccInfoReq_from_obj

TGetEccInfoReq.proto_property = {'Id'}

TGetEccInfoReq.default = {0}

TGetEccInfoReq.struct = {{name = 'Id', is_array = false, struct = nil}}

function TGetEccInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TGetEccInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEccInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetEccInfoReq:unpack(_)
    return self.Id
end

NPU.GetEccInfoReq = TGetEccInfoReq

NPU.interface = mdb.register_interface('bmc.kepler.Systems.Processor.NPU', {
    TotalMemoryKiB = {'u', nil, true, nil, false},
    MemoryUsageKiB = {'u', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    MemoryFreeKiB = {'u', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    CapabilitySupportMask = {'u', nil, true, nil, false},
    MemoryCapacityKiB = {'u', nil, true, nil, false},
    MultiBitEcc = {'s', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    SingleBitEcc = {'s', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    AiCPUUsagePercent = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    HBMBWUsagePercent = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    MemBWUsagePercent = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    HBMUsagePercent = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    MemUsagePercent = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    AiCoreUsagePercent = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    AiCoreMaxSpeedMHz = {'q', nil, true, nil, false},
    AiCoreCurrentSpeedMHz = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    CtrlCPUUsagePercent = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    ComputeCapability = {'s', nil, true, nil, false},
    NimBusTemp = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    AiCoreTemp = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    HBMTemp = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    PowerOn = {'y', nil, true, nil, false},
    PowerState = {'s', nil, true, nil, false},
    PowerCapacityWatts = {'u', nil, true, nil, false},
    PowerConsumedWatts = {'q', nil, true, nil, false},
    Volt = {'u', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    Power = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    VRDChipTemp = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    BDF = {'s', nil, true, nil, false},
    RootBDF = {'s', nil, true, nil, false},
    MemoryBandWidth = {'u', nil, true, nil, false},
    ReadingCelsius = {'q', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    Ierr = {'y', nil, true, nil, false},
    PredictiveFault = {'y', nil, false, nil, false},
    DiagnosticFault = {'y', nil, false, nil, false},
    ECCAlarmStatus = {'y', nil, true, nil, false},
    IErrFlag = {'u', nil, true, nil, false},
    VendorID = {'q', nil, true, nil, false},
    Version = {'s', nil, true, nil, false},
    DriverVersion = {'s', nil, true, nil, false},
    FaultCode = {'s', nil, true, nil, false},
    PowerCapWatts = {'q', nil, true, nil, false},
    TotalCores = {'u', nil, true, nil, false},
    Location = {'s', nil, true, nil, false},
    FlashIds = {'at', nil, true, nil, false},
    Slot = {'y', nil, true, nil, false}
}, {GetEccInfo = {'a{ss}y', 'ssss', TGetEccInfoReq, TGetEccInfoRsp}}, {})

return NPU
