--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPCIeDevPresentStatus = {}

---@class PcieDevice.GetPCIeDevPresentStatusReq
---@field ManufactureId integer
---@field DeviceType integer
local TGetPCIeDevPresentStatusReq = {}
TGetPCIeDevPresentStatusReq.__index = TGetPCIeDevPresentStatusReq
TGetPCIeDevPresentStatusReq.group = {}

local function TGetPCIeDevPresentStatusReq_from_obj(obj)
    return setmetatable(obj, TGetPCIeDevPresentStatusReq)
end

function TGetPCIeDevPresentStatusReq.new(ManufactureId, DeviceType)
    return TGetPCIeDevPresentStatusReq_from_obj({ManufactureId = ManufactureId, DeviceType = DeviceType})
end
---@param obj PcieDevice.GetPCIeDevPresentStatusReq
function TGetPCIeDevPresentStatusReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.DeviceType = obj.DeviceType
end

function TGetPCIeDevPresentStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPCIeDevPresentStatusReq.group)
end

TGetPCIeDevPresentStatusReq.from_obj = TGetPCIeDevPresentStatusReq_from_obj

TGetPCIeDevPresentStatusReq.proto_property = {'ManufactureId', 'DeviceType'}

TGetPCIeDevPresentStatusReq.default = {0, 0}

TGetPCIeDevPresentStatusReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'DeviceType', is_array = false, struct = nil}
}

function TGetPCIeDevPresentStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceType', self.DeviceType, 'uint8', false, errs, need_convert)

    TGetPCIeDevPresentStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPCIeDevPresentStatusReq.proto_property, errs, need_convert)
    return self
end

function TGetPCIeDevPresentStatusReq:unpack(_)
    return self.ManufactureId, self.DeviceType
end

GetPCIeDevPresentStatus.GetPCIeDevPresentStatusReq = TGetPCIeDevPresentStatusReq

---@class PcieDevice.GetPCIeDevPresentStatusRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data integer
local TGetPCIeDevPresentStatusRsp = {}
TGetPCIeDevPresentStatusRsp.__index = TGetPCIeDevPresentStatusRsp
TGetPCIeDevPresentStatusRsp.group = {}

local function TGetPCIeDevPresentStatusRsp_from_obj(obj)
    return setmetatable(obj, TGetPCIeDevPresentStatusRsp)
end

function TGetPCIeDevPresentStatusRsp.new(CompletionCode, ManufactureId, Data)
    return TGetPCIeDevPresentStatusRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Data = Data
    })
end
---@param obj PcieDevice.GetPCIeDevPresentStatusRsp
function TGetPCIeDevPresentStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetPCIeDevPresentStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPCIeDevPresentStatusRsp.group)
end

TGetPCIeDevPresentStatusRsp.from_obj = TGetPCIeDevPresentStatusRsp_from_obj

TGetPCIeDevPresentStatusRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Data'}

TGetPCIeDevPresentStatusRsp.default = {0, 0, 0}

TGetPCIeDevPresentStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetPCIeDevPresentStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'uint32', false, errs, need_convert)

    TGetPCIeDevPresentStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPCIeDevPresentStatusRsp.proto_property, errs, need_convert)
    return self
end

function TGetPCIeDevPresentStatusRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetPCIeDevPresentStatus.GetPCIeDevPresentStatusRsp = TGetPCIeDevPresentStatusRsp

return GetPCIeDevPresentStatus
