-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPcieAddrInfo = {}

---@class MPcieAddrInfo.MultihostPresence
---@field MultihostPresence integer
local TMultihostPresence = {}
TMultihostPresence.__index = TMultihostPresence
TMultihostPresence.group = {}

local function TMultihostPresence_from_obj(obj)
    return setmetatable(obj, TMultihostPresence)
end

function TMultihostPresence.new(MultihostPresence)
    return TMultihostPresence_from_obj({MultihostPresence = MultihostPresence})
end
---@param obj MPcieAddrInfo.MultihostPresence
function TMultihostPresence:init_from_obj(obj)
    self.MultihostPresence = obj.MultihostPresence
end

function TMultihostPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMultihostPresence.group)
end

TMultihostPresence.from_obj = TMultihostPresence_from_obj

TMultihostPresence.proto_property = {'MultihostPresence'}

TMultihostPresence.default = {0}

TMultihostPresence.struct = {{name = 'MultihostPresence', is_array = false, struct = nil}}

function TMultihostPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MultihostPresence', self.MultihostPresence, 'uint32', false, errs, need_convert)

    TMultihostPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMultihostPresence.proto_property, errs, need_convert)
    return self
end

function TMultihostPresence:unpack(_)
    return self.MultihostPresence
end

MPcieAddrInfo.MultihostPresence = TMultihostPresence

---@class MPcieAddrInfo.GroupPosition
---@field GroupPosition string
local TGroupPosition = {}
TGroupPosition.__index = TGroupPosition
TGroupPosition.group = {}

local function TGroupPosition_from_obj(obj)
    return setmetatable(obj, TGroupPosition)
end

function TGroupPosition.new(GroupPosition)
    return TGroupPosition_from_obj({GroupPosition = GroupPosition})
end
---@param obj MPcieAddrInfo.GroupPosition
function TGroupPosition:init_from_obj(obj)
    self.GroupPosition = obj.GroupPosition
end

function TGroupPosition:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGroupPosition.group)
end

TGroupPosition.from_obj = TGroupPosition_from_obj

TGroupPosition.proto_property = {'GroupPosition'}

TGroupPosition.default = {''}

TGroupPosition.struct = {{name = 'GroupPosition', is_array = false, struct = nil}}

function TGroupPosition:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'GroupPosition', self.GroupPosition, 'string', false, errs, need_convert)

    TGroupPosition:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGroupPosition.proto_property, errs, need_convert)
    return self
end

function TGroupPosition:unpack(_)
    return self.GroupPosition
end

MPcieAddrInfo.GroupPosition = TGroupPosition

---@class MPcieAddrInfo.DevFunction
---@field DevFunction integer
local TDevFunction = {}
TDevFunction.__index = TDevFunction
TDevFunction.group = {}

local function TDevFunction_from_obj(obj)
    return setmetatable(obj, TDevFunction)
end

function TDevFunction.new(DevFunction)
    return TDevFunction_from_obj({DevFunction = DevFunction})
end
---@param obj MPcieAddrInfo.DevFunction
function TDevFunction:init_from_obj(obj)
    self.DevFunction = obj.DevFunction
end

function TDevFunction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevFunction.group)
end

TDevFunction.from_obj = TDevFunction_from_obj

TDevFunction.proto_property = {'DevFunction'}

TDevFunction.default = {0}

TDevFunction.struct = {{name = 'DevFunction', is_array = false, struct = nil}}

function TDevFunction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevFunction', self.DevFunction, 'uint8', true, errs, need_convert)

    TDevFunction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevFunction.proto_property, errs, need_convert)
    return self
end

function TDevFunction:unpack(_)
    return self.DevFunction
end

MPcieAddrInfo.DevFunction = TDevFunction

---@class MPcieAddrInfo.DevDevice
---@field DevDevice integer
local TDevDevice = {}
TDevDevice.__index = TDevDevice
TDevDevice.group = {}

local function TDevDevice_from_obj(obj)
    return setmetatable(obj, TDevDevice)
end

function TDevDevice.new(DevDevice)
    return TDevDevice_from_obj({DevDevice = DevDevice})
end
---@param obj MPcieAddrInfo.DevDevice
function TDevDevice:init_from_obj(obj)
    self.DevDevice = obj.DevDevice
end

function TDevDevice:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevDevice.group)
end

TDevDevice.from_obj = TDevDevice_from_obj

TDevDevice.proto_property = {'DevDevice'}

TDevDevice.default = {0}

TDevDevice.struct = {{name = 'DevDevice', is_array = false, struct = nil}}

function TDevDevice:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevDevice', self.DevDevice, 'uint8', true, errs, need_convert)

    TDevDevice:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevDevice.proto_property, errs, need_convert)
    return self
end

function TDevDevice:unpack(_)
    return self.DevDevice
end

MPcieAddrInfo.DevDevice = TDevDevice

---@class MPcieAddrInfo.DevBus
---@field DevBus integer
local TDevBus = {}
TDevBus.__index = TDevBus
TDevBus.group = {}

local function TDevBus_from_obj(obj)
    return setmetatable(obj, TDevBus)
end

function TDevBus.new(DevBus)
    return TDevBus_from_obj({DevBus = DevBus})
end
---@param obj MPcieAddrInfo.DevBus
function TDevBus:init_from_obj(obj)
    self.DevBus = obj.DevBus
end

function TDevBus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevBus.group)
end

TDevBus.from_obj = TDevBus_from_obj

TDevBus.proto_property = {'DevBus'}

TDevBus.default = {0}

TDevBus.struct = {{name = 'DevBus', is_array = false, struct = nil}}

function TDevBus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevBus', self.DevBus, 'uint8', true, errs, need_convert)

    TDevBus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevBus.proto_property, errs, need_convert)
    return self
end

function TDevBus:unpack(_)
    return self.DevBus
end

MPcieAddrInfo.DevBus = TDevBus

---@class MPcieAddrInfo.ContainerSlot
---@field ContainerSlot integer
local TContainerSlot = {}
TContainerSlot.__index = TContainerSlot
TContainerSlot.group = {}

local function TContainerSlot_from_obj(obj)
    return setmetatable(obj, TContainerSlot)
end

function TContainerSlot.new(ContainerSlot)
    return TContainerSlot_from_obj({ContainerSlot = ContainerSlot})
end
---@param obj MPcieAddrInfo.ContainerSlot
function TContainerSlot:init_from_obj(obj)
    self.ContainerSlot = obj.ContainerSlot
end

function TContainerSlot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TContainerSlot.group)
end

TContainerSlot.from_obj = TContainerSlot_from_obj

TContainerSlot.proto_property = {'ContainerSlot'}

TContainerSlot.default = {0}

TContainerSlot.struct = {{name = 'ContainerSlot', is_array = false, struct = nil}}

function TContainerSlot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ContainerSlot', self.ContainerSlot, 'uint8', true, errs, need_convert)

    TContainerSlot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TContainerSlot.proto_property, errs, need_convert)
    return self
end

function TContainerSlot:unpack(_)
    return self.ContainerSlot
end

MPcieAddrInfo.ContainerSlot = TContainerSlot

---@class MPcieAddrInfo.Location
---@field Location string
local TLocation = {}
TLocation.__index = TLocation
TLocation.group = {}

local function TLocation_from_obj(obj)
    return setmetatable(obj, TLocation)
end

function TLocation.new(Location)
    return TLocation_from_obj({Location = Location})
end
---@param obj MPcieAddrInfo.Location
function TLocation:init_from_obj(obj)
    self.Location = obj.Location
end

function TLocation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLocation.group)
end

TLocation.from_obj = TLocation_from_obj

TLocation.proto_property = {'Location'}

TLocation.default = {''}

TLocation.struct = {{name = 'Location', is_array = false, struct = nil}}

function TLocation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Location', self.Location, 'string', true, errs, need_convert)

    TLocation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLocation.proto_property, errs, need_convert)
    return self
end

function TLocation:unpack(_)
    return self.Location
end

MPcieAddrInfo.Location = TLocation

---@class MPcieAddrInfo.ContainerUnitType
---@field ContainerUnitType string
local TContainerUnitType = {}
TContainerUnitType.__index = TContainerUnitType
TContainerUnitType.group = {}

local function TContainerUnitType_from_obj(obj)
    return setmetatable(obj, TContainerUnitType)
end

function TContainerUnitType.new(ContainerUnitType)
    return TContainerUnitType_from_obj({ContainerUnitType = ContainerUnitType})
end
---@param obj MPcieAddrInfo.ContainerUnitType
function TContainerUnitType:init_from_obj(obj)
    self.ContainerUnitType = obj.ContainerUnitType
end

function TContainerUnitType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TContainerUnitType.group)
end

TContainerUnitType.from_obj = TContainerUnitType_from_obj

TContainerUnitType.proto_property = {'ContainerUnitType'}

TContainerUnitType.default = {''}

TContainerUnitType.struct = {{name = 'ContainerUnitType', is_array = false, struct = nil}}

function TContainerUnitType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ContainerUnitType', self.ContainerUnitType, 'string', true, errs, need_convert)

    TContainerUnitType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TContainerUnitType.proto_property, errs, need_convert)
    return self
end

function TContainerUnitType:unpack(_)
    return self.ContainerUnitType
end

MPcieAddrInfo.ContainerUnitType = TContainerUnitType

---@class MPcieAddrInfo.ContainerUID
---@field ContainerUID string
local TContainerUID = {}
TContainerUID.__index = TContainerUID
TContainerUID.group = {}

local function TContainerUID_from_obj(obj)
    return setmetatable(obj, TContainerUID)
end

function TContainerUID.new(ContainerUID)
    return TContainerUID_from_obj({ContainerUID = ContainerUID})
end
---@param obj MPcieAddrInfo.ContainerUID
function TContainerUID:init_from_obj(obj)
    self.ContainerUID = obj.ContainerUID
end

function TContainerUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TContainerUID.group)
end

TContainerUID.from_obj = TContainerUID_from_obj

TContainerUID.proto_property = {'ContainerUID'}

TContainerUID.default = {''}

TContainerUID.struct = {{name = 'ContainerUID', is_array = false, struct = nil}}

function TContainerUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ContainerUID', self.ContainerUID, 'string', true, errs, need_convert)

    TContainerUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TContainerUID.proto_property, errs, need_convert)
    return self
end

function TContainerUID:unpack(_)
    return self.ContainerUID
end

MPcieAddrInfo.ContainerUID = TContainerUID

return MPcieAddrInfo
