-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPCIeLoadInfoBackup = {}

---@class MPCIeLoadInfoBackup.RecoverFlag
---@field RecoverFlag integer
local TRecoverFlag = {}
TRecoverFlag.__index = TRecoverFlag
TRecoverFlag.group = {}

local function TRecoverFlag_from_obj(obj)
    return setmetatable(obj, TRecoverFlag)
end

function TRecoverFlag.new(RecoverFlag)
    return TRecoverFlag_from_obj({RecoverFlag = RecoverFlag or 0})
end
---@param obj MPCIeLoadInfoBackup.RecoverFlag
function TRecoverFlag:init_from_obj(obj)
    self.RecoverFlag = obj.RecoverFlag or 0
end

function TRecoverFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRecoverFlag.group)
end

TRecoverFlag.from_obj = TRecoverFlag_from_obj

TRecoverFlag.proto_property = {'RecoverFlag'}

TRecoverFlag.default = {0}

TRecoverFlag.struct = {{name = 'RecoverFlag', is_array = false, struct = nil}}

function TRecoverFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RecoverFlag', self.RecoverFlag, 'uint8', false, errs, need_convert)

    TRecoverFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRecoverFlag.proto_property, errs, need_convert)
    return self
end

function TRecoverFlag:unpack(_)
    return self.RecoverFlag
end

MPCIeLoadInfoBackup.RecoverFlag = TRecoverFlag

---@class MPCIeLoadInfoBackup.MultihostPresence
---@field MultihostPresence integer
local TMultihostPresence = {}
TMultihostPresence.__index = TMultihostPresence
TMultihostPresence.group = {}

local function TMultihostPresence_from_obj(obj)
    return setmetatable(obj, TMultihostPresence)
end

function TMultihostPresence.new(MultihostPresence)
    return TMultihostPresence_from_obj({MultihostPresence = MultihostPresence or 1})
end
---@param obj MPCIeLoadInfoBackup.MultihostPresence
function TMultihostPresence:init_from_obj(obj)
    self.MultihostPresence = obj.MultihostPresence or 1
end

function TMultihostPresence:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMultihostPresence.group)
end

TMultihostPresence.from_obj = TMultihostPresence_from_obj

TMultihostPresence.proto_property = {'MultihostPresence'}

TMultihostPresence.default = {0}

TMultihostPresence.struct = {{name = 'MultihostPresence', is_array = false, struct = nil}}

function TMultihostPresence:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MultihostPresence', self.MultihostPresence, 'uint32', false, errs, need_convert)

    TMultihostPresence:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMultihostPresence.proto_property, errs, need_convert)
    return self
end

function TMultihostPresence:unpack(_)
    return self.MultihostPresence
end

MPCIeLoadInfoBackup.MultihostPresence = TMultihostPresence

---@class MPCIeLoadInfoBackup.DevFunction
---@field DevFunction integer
local TDevFunction = {}
TDevFunction.__index = TDevFunction
TDevFunction.group = {}

local function TDevFunction_from_obj(obj)
    return setmetatable(obj, TDevFunction)
end

function TDevFunction.new(DevFunction)
    return TDevFunction_from_obj({DevFunction = DevFunction or 0})
end
---@param obj MPCIeLoadInfoBackup.DevFunction
function TDevFunction:init_from_obj(obj)
    self.DevFunction = obj.DevFunction or 0
end

function TDevFunction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevFunction.group)
end

TDevFunction.from_obj = TDevFunction_from_obj

TDevFunction.proto_property = {'DevFunction'}

TDevFunction.default = {0}

TDevFunction.struct = {{name = 'DevFunction', is_array = false, struct = nil}}

function TDevFunction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevFunction', self.DevFunction, 'uint8', false, errs, need_convert)

    TDevFunction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevFunction.proto_property, errs, need_convert)
    return self
end

function TDevFunction:unpack(_)
    return self.DevFunction
end

MPCIeLoadInfoBackup.DevFunction = TDevFunction

---@class MPCIeLoadInfoBackup.DevDevice
---@field DevDevice integer
local TDevDevice = {}
TDevDevice.__index = TDevDevice
TDevDevice.group = {}

local function TDevDevice_from_obj(obj)
    return setmetatable(obj, TDevDevice)
end

function TDevDevice.new(DevDevice)
    return TDevDevice_from_obj({DevDevice = DevDevice or 0})
end
---@param obj MPCIeLoadInfoBackup.DevDevice
function TDevDevice:init_from_obj(obj)
    self.DevDevice = obj.DevDevice or 0
end

function TDevDevice:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevDevice.group)
end

TDevDevice.from_obj = TDevDevice_from_obj

TDevDevice.proto_property = {'DevDevice'}

TDevDevice.default = {0}

TDevDevice.struct = {{name = 'DevDevice', is_array = false, struct = nil}}

function TDevDevice:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevDevice', self.DevDevice, 'uint8', false, errs, need_convert)

    TDevDevice:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevDevice.proto_property, errs, need_convert)
    return self
end

function TDevDevice:unpack(_)
    return self.DevDevice
end

MPCIeLoadInfoBackup.DevDevice = TDevDevice

---@class MPCIeLoadInfoBackup.DevBus
---@field DevBus integer
local TDevBus = {}
TDevBus.__index = TDevBus
TDevBus.group = {}

local function TDevBus_from_obj(obj)
    return setmetatable(obj, TDevBus)
end

function TDevBus.new(DevBus)
    return TDevBus_from_obj({DevBus = DevBus or 0})
end
---@param obj MPCIeLoadInfoBackup.DevBus
function TDevBus:init_from_obj(obj)
    self.DevBus = obj.DevBus or 0
end

function TDevBus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevBus.group)
end

TDevBus.from_obj = TDevBus_from_obj

TDevBus.proto_property = {'DevBus'}

TDevBus.default = {0}

TDevBus.struct = {{name = 'DevBus', is_array = false, struct = nil}}

function TDevBus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevBus', self.DevBus, 'uint8', false, errs, need_convert)

    TDevBus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevBus.proto_property, errs, need_convert)
    return self
end

function TDevBus:unpack(_)
    return self.DevBus
end

MPCIeLoadInfoBackup.DevBus = TDevBus

---@class MPCIeLoadInfoBackup.SocketID
---@field SocketID integer
local TSocketID = {}
TSocketID.__index = TSocketID
TSocketID.group = {}

local function TSocketID_from_obj(obj)
    return setmetatable(obj, TSocketID)
end

function TSocketID.new(SocketID)
    return TSocketID_from_obj({SocketID = SocketID or 0})
end
---@param obj MPCIeLoadInfoBackup.SocketID
function TSocketID:init_from_obj(obj)
    self.SocketID = obj.SocketID or 0
end

function TSocketID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSocketID.group)
end

TSocketID.from_obj = TSocketID_from_obj

TSocketID.proto_property = {'SocketID'}

TSocketID.default = {0}

TSocketID.struct = {{name = 'SocketID', is_array = false, struct = nil}}

function TSocketID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SocketID', self.SocketID, 'uint8', false, errs, need_convert)

    TSocketID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSocketID.proto_property, errs, need_convert)
    return self
end

function TSocketID:unpack(_)
    return self.SocketID
end

MPCIeLoadInfoBackup.SocketID = TSocketID

---@class MPCIeLoadInfoBackup.Segment
---@field Segment integer
local TSegment = {}
TSegment.__index = TSegment
TSegment.group = {}

local function TSegment_from_obj(obj)
    return setmetatable(obj, TSegment)
end

function TSegment.new(Segment)
    return TSegment_from_obj({Segment = Segment or 0})
end
---@param obj MPCIeLoadInfoBackup.Segment
function TSegment:init_from_obj(obj)
    self.Segment = obj.Segment or 0
end

function TSegment:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSegment.group)
end

TSegment.from_obj = TSegment_from_obj

TSegment.proto_property = {'Segment'}

TSegment.default = {0}

TSegment.struct = {{name = 'Segment', is_array = false, struct = nil}}

function TSegment:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Segment', self.Segment, 'uint8', false, errs, need_convert)

    TSegment:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSegment.proto_property, errs, need_convert)
    return self
end

function TSegment:unpack(_)
    return self.Segment
end

MPCIeLoadInfoBackup.Segment = TSegment

---@class MPCIeLoadInfoBackup.AuxID
---@field AuxID integer
local TAuxID = {}
TAuxID.__index = TAuxID
TAuxID.group = {}

local function TAuxID_from_obj(obj)
    return setmetatable(obj, TAuxID)
end

function TAuxID.new(AuxID)
    return TAuxID_from_obj({AuxID = AuxID or 0})
end
---@param obj MPCIeLoadInfoBackup.AuxID
function TAuxID:init_from_obj(obj)
    self.AuxID = obj.AuxID or 0
end

function TAuxID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAuxID.group)
end

TAuxID.from_obj = TAuxID_from_obj

TAuxID.proto_property = {'AuxID'}

TAuxID.default = {0}

TAuxID.struct = {{name = 'AuxID', is_array = false, struct = nil}}

function TAuxID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AuxID', self.AuxID, 'uint32', false, errs, need_convert)

    TAuxID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAuxID.proto_property, errs, need_convert)
    return self
end

function TAuxID:unpack(_)
    return self.AuxID
end

MPCIeLoadInfoBackup.AuxID = TAuxID

---@class MPCIeLoadInfoBackup.ID
---@field ID integer
local TID = {}
TID.__index = TID
TID.group = {}

local function TID_from_obj(obj)
    return setmetatable(obj, TID)
end

function TID.new(ID)
    return TID_from_obj({ID = ID or 0})
end
---@param obj MPCIeLoadInfoBackup.ID
function TID:init_from_obj(obj)
    self.ID = obj.ID or 0
end

function TID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TID.group)
end

TID.from_obj = TID_from_obj

TID.proto_property = {'ID'}

TID.default = {0}

TID.struct = {{name = 'ID', is_array = false, struct = nil}}

function TID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ID', self.ID, 'uint32', false, errs, need_convert)

    TID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TID.proto_property, errs, need_convert)
    return self
end

function TID:unpack(_)
    return self.ID
end

MPCIeLoadInfoBackup.ID = TID

---@class MPCIeLoadInfoBackup.SlotID
---@field SlotID integer
local TSlotID = {}
TSlotID.__index = TSlotID
TSlotID.group = {}

local function TSlotID_from_obj(obj)
    return setmetatable(obj, TSlotID)
end

function TSlotID.new(SlotID)
    return TSlotID_from_obj({SlotID = SlotID or 0})
end
---@param obj MPCIeLoadInfoBackup.SlotID
function TSlotID:init_from_obj(obj)
    self.SlotID = obj.SlotID or 0
end

function TSlotID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotID.group)
end

TSlotID.from_obj = TSlotID_from_obj

TSlotID.proto_property = {'SlotID'}

TSlotID.default = {0}

TSlotID.struct = {{name = 'SlotID', is_array = false, struct = nil}}

function TSlotID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SlotID', self.SlotID, 'uint8', false, errs, need_convert)

    TSlotID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotID.proto_property, errs, need_convert)
    return self
end

function TSlotID:unpack(_)
    return self.SlotID
end

MPCIeLoadInfoBackup.SlotID = TSlotID

---@class MPCIeLoadInfoBackup.Type
---@field Type string
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type or [=[NA]=]})
end
---@param obj MPCIeLoadInfoBackup.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type or [=[NA]=]
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {''}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

MPCIeLoadInfoBackup.Type = TType

return MPCIeLoadInfoBackup
