-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local c_network_adapter = require 'device.class.network_adapter'

TEST_oobm= {}

-- 数据为空不更新
function TEST_oobm:test_update_fw_ver_null()
    c_network_adapter.smbus_schedulers = {}
    c_network_adapter.smbus_config_obj = {
        FirmwareVersion = function()
            return {
                on_data_change = {
                    on = function(data)
                    end
                },
                on_error = {
                    on = function()
                    end
                },
                start = function()
                end
            }
        end
    }
    c_network_adapter:update_fw_ver({})
    lu.assertIsTrue(c_network_adapter.update_fw_ver_abnormal)
    c_network_adapter.update_fw_ver_abnormal = false
    c_network_adapter:update_fw_ver_on_data_change(nil, {})
    lu.assertIsFalse(c_network_adapter.update_fw_ver_abnormal)
end

-- 标志更新到成功,更新版本
function TEST_oobm:test_update_fw_ver_success()
    local target_val = '1.68.6'
    local port = {
        {
            get_firmware_version = function()
                return ''
            end,
            set_firmware_version = function()
            end
        }
    }
    c_network_adapter.FirmwareVersion = '5.36'
    c_network_adapter.update_fw_ver_abnormal = true
    c_network_adapter:update_fw_ver_on_data_change(target_val, port)
    lu.assertEquals(c_network_adapter.FirmwareVersion, target_val)
    lu.assertIsFalse(c_network_adapter.update_fw_ver_abnormal)
    c_network_adapter.FirmwareVersion = '3.0.0.21' -- 另一个UT的初始值，需要修改回去否则会报错
end

-- 标志更新到失败
function TEST_oobm:test_update_fw_ver_fail()
    c_network_adapter.update_fw_ver_abnormal = false
    c_network_adapter:update_fw_ver_on_error()
    lu.assertIsTrue(c_network_adapter.update_fw_ver_abnormal)
end