-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local EthernetInterface = [[{
    "@odata.context": "/redfish/v1/$metadata#Systems/Members/1/EthernetInterfaces/Members/$entity",
    "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:bc:00.0_0000:bd:00.0",
    "@odata.type": "#EthernetInterface.v1_0_2.EthernetInterface",
    "AutoNeg": true,
    "Description": "Huawei Technologies Co., Ltd. HNS GE/10GE/25GE/50GE RDMA Network Controller (rev 21)",
    "FullDuplex": true,
    "IPv4Addresses": [
        {
            "Address": "196.128.0.81",
            "AddressOrigin": "Static",
            "Gateway": [
                "196.128.0.1"
            ],
            "SubnetMask": "255.255.0.0"
        }
    ],
    "IPv6Addresses": [
        {
            "Address": "7676:1871:1:0:f40:3935:cf5c:adff",
            "AddressOrigin": "SLAAC",
            "AddressState": "Deprecated",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:f:0:9996:f54a:171e:bd39",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:e:0:877c:8c42:3a89:66b1",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:d:0:a0f1:959e:9ffb:f2d3",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:c:0:2913:8c68:464:be49",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:b:0:f150:4ed4:7ca1:3f7b",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:a:0:4bc2:dec2:49db:3673",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:9:0:89df:54dd:e29c:dcf",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:8:0:3e3a:f264:80be:6275",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:7:0:78b1:7eae:2e94:9765",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:6:0:1fa2:b973:26dd:7dc4",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:5:0:efba:555e:4ada:10aa",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:4:0:f42c:4935:e159:a19b",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:3:0:5d04:429:ead0:d0d5",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:2:0:ca11:a6a0:9633:6feb",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "7676:1899:1:0:189a:a5e4:970d:d5e8",
            "AddressOrigin": "SLAAC",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        },
        {
            "Address": "fec0:75:1001::f6c9",
            "AddressOrigin": "DHCPv6",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "128"
        },
        {
            "Address": "fe80::9415:57a2:91f:cf2f",
            "AddressOrigin": "LinkLocal",
            "AddressState": "Preferred",
            "Gateway": [
                "fe80::1fab:ab3d:5f00:1418",
                "fe80::f6e5:f2ff:fe49:a1c6",
                "fe80::e4e5:7c42:d64d:b11a"
            ],
            "PrefixLength": "64"
        }
    ],
    "Id": "0000:bc:00.0_0000:bd:00.0",
    "LinkStatus": "LinkUp",
    "MACAddress": "8c:2a:8e:7e:83:9a",
    "MTUSize": 1500,
    "Manufacturer": "Huawei Technologies Co., Ltd",
    "Name": "enp189s0f0",
    "OAM": {
        "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:bc:00.0_0000:bd:00.0/OAM"
    },
    "Oem": {
        "Huawei": {
            "BDFNumber": {
                "BDF": "0000:bd:00.0",
                "PortNum": null,
                "RootBDF": "0000:bc:00.0"
            },
            "DeviceID": "0xa224",
            "DeviceLocation": null,
            "DeviceName": null,
            "DeviceSilkScreen": null,
            "DiagnosticStatus": 0,
            "DriverInfo": {
                "DriverName": "hns3",
                "DriverVersion": "4.14.0-115.el7a.0.1.aarch64 SMP"
            },
            "FirmwareVersion": "0x010a0006",
            "Model": null,
            "NICName": "enp189s0f0",
            "PCIePath": "/sys/devices/pci0000:bc/0000:bc:00.0/0000:bd:00.0",
            "PortType": "Physical",
            "SubsystemDeviceID": "0x04cc",
            "SubsystemVendorID": "0x19e5",
            "VendorID": "0x19e5"
        }
    },
    "Sff": {},
    "SpeedMbps": 1000,
    "Statistics": {
        "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:bc:00.0_0000:bd:00.0/Statistics"
    },
    "VLANs": {
        "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:bc:00.0_0000:bd:00.0/VLANs"
    }
}]]

local VLanNetworkInterface = [[{
    "@odata.context": "/redfish/v1/$metadata#Systems/Members/1/EthernetInterfaces/Members/ethX/VLANs/Members/$entity",
    "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:bc:00.0_0000:bd:00.0/VLANs/4",
    "@odata.type": "#VLanNetworkInterface.v1_0_2.VLanNetworkInterface",
    "AutoNeg": true,
    "FullDuplex": true,
    "IPv4Addresses": [
        {
            "Address": "127.6.3.138",
            "AddressOrigin": "Static",
            "Gateway": [],
            "SubnetMask": "255.255.255.0"
        }
    ],
    "IPv6Addresses": [
        {
            "Address": "fe80::8e2a:8eff:fe7e:839a",
            "AddressOrigin": "LinkLocal",
            "AddressState": "Preferred",
            "Gateway": [],
            "PrefixLength": "64"
        }
    ],
    "Id": "4",
    "LinkStatus": "LinkUp",
    "MACAddress": "8c:2a:8e:7e:83:9a",
    "MTUSize": 1500,
    "Name": "vlan4",
    "Oem": {
        "Huawei": {
            "DriverInfo": {
                "DriverName": null,
                "DriverVersion": null
            },
            "NICName": "vlan4",
            "PortType": "Virtual",
            "VLANPriority": "Disable"
        }
    },
    "SpeedMbps": 1000,
    "Statistics": {
        "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:bc:00.0_0000:bd:00.0/VLANs/4/Statistics"
    },
    "VLANEnable": true,
    "VLANId": 4
}
]]

local Team = [[{
    "@odata.type": "#EthernetInterface.v1_0_2.EthernetInterface",
    "Id": "team00",
    "Name": "teamA",
    "MACAddress": "1a:de:75:9e:d3:e1",
    "SpeedMbps": null,
    "FullDuplex": null,
    "AutoNeg": null,
    "MTUSize": 1500,
    "Ports": [
        null
    ],
    "IPv4Addresses": [],
    "IPv6Addresses": [],
    "LinkStatus": "LinkDown",
    "Oem": {
        "Huawei": {
            "URLId": "team00",
            "NICName": "teamA",
            "WorkMode": null,
            "DriverInfo": {
                "DriverName": null,
                "DriverVersion": null
            },
            "PortType": "Virtual",
            "MIILinkMonitoringFrequencyMS": null
        }
    },
    "VLANs": {
        "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/Team/team00/VLANs"
    },
    "Statistics": {
        "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/Team/team00/Statistics"
    },
    "@odata.context": "/redfish/v1/$metadata#Systems/Members/1/EthernetInterfaces/Members/Team/Members/$entity",
    "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/Team/team00"
}
]]
return {EthernetInterface = EthernetInterface, VLanNetworkInterface = VLanNetworkInterface, Team = Team}
