-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local lu = require 'luaunit'
local c_device_manager = require 'device.device_manager'
local task_mgmt = require 'mc.mdb.task_mgmt'
local file_sec = require 'utils.file'
local utils = require 'mc.utils'
local client = require 'network_adapter.client'
local skynet = require 'skynet'
local file_sec = require 'utils.file'
local vos = require 'utils.vos'
local utils_core = require 'utils.core'
local c_network_adapter = require 'device.class.network_adapter'
TEST_device_manager = {}

mock_func = {}

local function mock_backup()
    mock_func.chmod_s = utils_core.chmod_s
    mock_func.fork_once = skynet.fork_once
    mock_func.system_s = vos.system_s
    mock_func.remove_file = utils.remove_file
    mock_func.check_realpath_before_open_s = file_sec.check_realpath_before_open_s
    mock_func.check_real_path = file_sec.check_real_path
    mock_func.get_file_name_s = file_sec.get_file_name_s
    mock_func.check_real_path_s = file_sec.check_real_path_s
    mock_func.get_file_accessible = vos.get_file_accessible
    mock_func.GetDPUCardObjects = client.GetDPUCardObjects
    mock_func.get_power_status = c_device_manager.get_power_status
    mock_func.chown_s = utils_core.chown_s 
    mock_func.update_task = task_mgmt.update_task
    mock_func.update_code = task_mgmt.update_code
    mock_func.is_dir = utils_core.is_dir
    mock_func.start_blackbox_coroutine = c_device_manager.start_blackbox_coroutine
    mock_func.collection = c_network_adapter.collection
    mock_func.create_code = task_mgmt.create_code
end

local function mock_restore()
    utils_core.chmod_s = mock_func.chmod_s
    skynet.fork_once = mock_func.fork_once
    vos.system_s = mock_func.system_s
    vos.remove_file = mock_func.remove_file
    file_sec.check_realpath_before_open_s = mock_func.check_realpath_before_open_s
    file_sec.check_real_path = mock_func.check_real_path
    file_sec.get_file_name_s = mock_func.get_file_name_s
    file_sec.check_real_path_s = mock_func.check_real_path_s
    vos.get_file_accessible = mock_func.get_file_accessible
    client.GetDPUCardObjects = mock_func.GetDPUCardObjects
    c_device_manager.get_power_status = mock_func.get_power_status
    utils_core.chown_s = mock_func.chown_s 
    task_mgmt.update_task = mock_func.update_task
    task_mgmt.update_code = mock_func.update_code
    utils_core.is_dir = mock_func.is_dir
    c_device_manager.start_blackbox_coroutine = mock_func.start_blackbox_coroutine
    c_network_adapter.collection = mock_func.collection
    task_mgmt.create_code = mock_func.create_code
end

local function mock_prepare_1()
    client.GetDPUCardObjects = function()
        return {}
    end
    task_mgmt.create_code = { TASK_CREATE_SUCCESSFUL = 1 }
    task_mgmt.create_task = function()
        return 2, 0, 1
    end
end
local function mock_prepare_2()
    skynet.fork_once = function(cb, id , card, path, ctx)
        cb(id, card, path, ctx)
    end

    file_sec.check_realpath_before_open_s = function()
        return 1
    end
    vos.system_s = function(cmd, flag1, path, flag2, src_dir, dest_dir)
        return true
    end
    utils.remove_file = function(dir)
        return dir
    end
    utils.realpath = function(obj)
        return false
    end
    utils_core.chmod_s = function()
        
    end
    utils_core.chown_s = function()
        
    end
    task_mgmt.update_task = function()
        return 1
    end
    task_mgmt.update_code = {TASK_UPDATE_SUCCESSFUL = 1}
end
function TEST_device_manager:test_start_blackbox_coroutine()
    mock_backup()
    mock_prepare_1()
    local obj = { path = "test" }
    
    c_network_adapter.collection = {}
    local cards = {{SlotNumber = 1, Name = "test", pldm_config_obj = {BlackBox = function()
        return {value = function()  return {data = 1, length = 1} end} 
    end}}}

    local ctx = {
        get_initiator = function()
            return "test"
        end
    }
    c_network_adapter.collection.fetch = function()
        return {}
    end
    -- 测试 create_blackbox_task
    local ok, _ = pcall(c_device_manager.start_blackbox_coroutine, c_device_manager, obj, nil, ctx)
    lu.assertEquals(ok, false)

    mock_prepare_2()
    task_mgmt.create_code.TASK_CREATE_SUCCESSFUL = 2
    --测试 dump_func, compress_file_to_path
    ok, _ = pcall(c_device_manager.start_blackbox_coroutine, c_device_manager, obj, nil, ctx)
    lu.assertEquals(ok, true)
    c_network_adapter.collection.fetch = function()
        return cards
    end
    local open_s = file_sec.open_s 
    file_sec.open_s = function()
        return false
    end
    -- local c_device_manager_tmp = c_device_manager
    -- --测试 dump_one_card_blackbox_by_pldm， dump_one_card_blackbox_by_rmii， write_blackbox_to_file
    pcall(c_device_manager.start_blackbox_coroutine, c_device_manager, obj, nil, ctx)
    cards[1].pldm_config_obj.BlackBox = function()
        return {value = function()  return nil end} 
    end
    pcall(c_device_manager.start_blackbox_coroutine, c_device_manager, obj, nil, ctx)
 
    file_sec.open_s = open_s
    mock_restore()
end

function TEST_device_manager:test_method_dump_black_box()
    mock_backup()
    c_device_manager.get_power_status = function()
        return "OFF"
    end
    local ctx = {get_initiator = function()
        return 'test'
    end}
    
    -- 测试 method_dump_black_box 749行
    local ok, _ = pcall(c_device_manager.method_dump_black_box, c_device_manager,  {"test"}, ctx, path)
    lu.assertEquals(ok, false)
    c_device_manager.get_power_status = function()
        return "ON"
    end
    -- 测试 method_dump_black_box 757行
    local path = string.rep('1', 256)
    ok, _ = pcall(c_device_manager.method_dump_black_box, c_device_manager,  {"test"}, ctx, path)
    lu.assertEquals(ok, false)
    mock_restore()
end

function TEST_device_manager:test_method_dump_black_box_2()
    mock_restore()
    local true_func = function()
        return true
    end
    c_device_manager.start_blackbox_coroutine = function ()
        return false, 1
    end

    file_sec.check_realpath_before_open_s = true_func
    file_sec.get_file_name_s = function() return "test" end
    file_sec.check_real_path_s = true_func
    vos.get_file_accessible = function()
        return false
    end
    local path = string.rep('1', 10)
    c_device_manager.get_power_status = function()
        return "ON"
    end
    -- 测试 method_dump_black_box 757
    utils_core.is_dir = true_func
    local ok, _ = pcall(c_device_manager.method_dump_black_box, c_device_manager,  {"test"}, ctx, path)
    lu.assertEquals(ok, false)

    -- 测试 method_dump_black_box 770行
    utils_core.is_dir = function ()
        return false 
    end
    c_device_manager.start_blackbox_coroutine = function ()
        return false, 1
    end
    ok, _ = pcall(c_device_manager.method_dump_black_box, c_device_manager,  {"test"}, ctx, path)
    lu.assertEquals(ok, false)

    utils_core.is_dir = function ()
        return false 
    end
    -- 测试 method_dump_black_box   行
    ok, _ = pcall(c_device_manager.method_dump_black_box, c_device_manager,  {"test"}, ctx, path)
    lu.assertEquals(ok, false)
    mock_restore()
end
