-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local skynet = require 'skynet'
local lu = require 'luaunit'
local context = require 'mc.context'
local json = require 'cjson'
local mdb = require 'mc.mdb'
local ctx = require 'mc.context'
require 'network_adapter.json_types.Metrics'

local service = 'bmc.kepler.network_adapter'
local optical_module_path = 
    '/bmc/kepler/Systems/1/NetworkAdapters/NetworkAdapter_2_010101/Ports/NetworkPort_0_010101/OpticalModule'
local metric_intf = 'bmc.kepler.Metric'

local cases = {}

local function test_metric_items(bus)
    log:info('==> test metric get items start ...')
    local component, classification, identification, metricName = bus:call(service, optical_module_path, 
        metric_intf, 'GetItems', 'a{ss}', context.new())

    lu.assertEquals(component, 'OpticalModule')
    lu.assertEquals(classification[1][1], 'VendorName')
    lu.assertEquals(classification[2][1], 'SerialNumber')
    lu.assertEquals(classification[3][1], 'TransceiverType')
    lu.assertEquals(identification[1][1], 'Location')
    lu.assertEquals(identification[2][1], 'SerialNumber')
    lu.assertEquals(metricName[1], 'opticalmodule.metric')
    log:info('==> test metric get items completed')
    return metricName
end

local function test_metric_datas(bus, metricName)
    log:info('==> test metric get items start ...')
    local val = bus:call(service, optical_module_path, metric_intf, 'GetData', 'a{ss}as', context.new(), metricName)
    lu.assertEquals(val[1][1], 'opticalmodule.metric')

    -- 采集项
    local metric_props = {'RxPowerMilliWatts', 'TxPowerMilliWatts', 'BiasCurrentMilliAmps', 'TemperatureCel',
        'VoltageMilliVoltage', 'RxLoss', 'TxLoss', 'MacRxFcsErrPktNum', 'MacRxTotalPktNum', 'RxLossOfLock',
        'TxLossOfLock', 'LaserRuntimeSeconds', 'UptimeSeconds', 'PowerOnCount', 'PowerStatus',
        'OdspDieTemperatureCelsius', 'OdspHighTempRuntimeSeconds', 'LaserTemperatureCelsius'}

    local datas = json.decode(val[1][2][1])

    for _, prop in pairs(metric_props) do
        assert(datas[prop] ~= nil, 'prop no exist: ' .. prop)
    end
    log:info('==> test metric get items completed')
end

function cases.test_entry(bus)
    log:info('==> test optical module start ...')
    test_metric_datas(bus, test_metric_items(bus))
    log:info('==> test optical module completed')

end

return cases