-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bs = require 'mc.bitstring'
local response_parser = require 'libmgmt_protocol'

local TestData = {
    protocol_dependencies = {
        smbus = {
            ref_chip = nil,
            buffer_len = 64
        },
    },
    properties = {
        ChipTemp = {
            protocol = 'smbus',
            action = 'on_schedule',
            period_in_sec = 2,
            request = {
                opcode = 0x3,
                expect_data_len = 2,
            },
            response = function(data)
                return bs.new([[<<temp:16>>]]):unpack(data, true).temp
            end
        },
        MacAddr = {
            protocol = 'smbus',
            action = 'on_demand',
            request = {
                opcode = 0x404
            },
            response = function(data)
                local parser = response_parser.create_array_parser([[<<port:8, PF_VF:16, addr:1/MAC_ADDRESS>>]], 9)
                local r = parser(data)
                if not r then
                    return r
                end
                for _, d in ipairs(r) do
                    d.addr = d.addr.mac_address
                end
                return r
            end
        }
    }
}

return TestData