-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


---导入依赖包
local mdb = require 'mc.mdb'
local ctx = require 'mc.context'
local create_enum_type = require 'mc.enum'
local dtframe = require 'dtframe'

local FuzzMDB = {}
bus = {}
local PROJECT_DIR = os.getenv('PROJECT_DIR')
if PROJECT_DIR == nil then
    error("PROJECT_DIR does not exist!")
end

local cf = {
    ["corpus_folder"] = PROJECT_DIR..'/test/fuzz/.dtframe/fuzz_corpus/',
    ["report_file"] = PROJECT_DIR..'/test/fuzz/.dtframe/fuzz_report.log',
    ["mds_path"] = PROJECT_DIR..'/test/fuzz/.dtframe/fuzz_mds/fuzz_model.json',
    ["fuzz_count"] = 10000
}

local function fuzz_process(func, func_name)
    local count = cf["fuzz_count"]
    print("================start fuzz "..func_name.."====================")
    dtframe.fuzz_start(func_name)
    for i = 1, count do
        dtframe.fuzz_for_start(i-1)
        dtframe.fuzz_run(func)
        if (dtframe.fuzz_for_end()) == 1 then
            print("break\n")
            break
        end
    end
    dtframe.fuzz_end()
    print("================complete fuzz "..func_name.."====================")
end

---开始处理mdb_interface methods

local function fuzz_NetworkAdapters_GetNetCardPortNum()

    local obj = mdb.get_object(bus, '/bmc/kepler/Systems/:SystemId/NetworkAdapters',
        'bmc.kepler.Systems.NetworkAdapters')
    local data = dtframe.fuzz_set_get_mdb_interface('NetworkAdapters',
        'bmc.kepler.Systems.NetworkAdapters', 'GetNetCardPortNum')

    Type = data[1]

    SystemID = data[2]

    SlotID = data[3]

    obj:GetNetCardPortNum(ctx.new("Fuzz", "NA" , "NA"), Type ,SystemID ,SlotID)

end
local function fuzz_NetworkAdapters_GetPortSpeed()

    local obj = mdb.get_object(bus, '/bmc/kepler/Systems/:SystemId/NetworkAdapters',
        'bmc.kepler.Systems.NetworkAdapters')
    local data = dtframe.fuzz_set_get_mdb_interface('NetworkAdapters',
        'bmc.kepler.Systems.NetworkAdapters', 'GetPortSpeed')

    Type = data[1]

    Slot = data[2]

    PortID = data[3]

    obj:GetPortSpeed(ctx.new("Fuzz", "NA" , "NA"), Type ,Slot ,PortID)

end

local function fuzz_NetworkAdapter_StartRemovingDevice()

    local obj = mdb.get_object(bus, '/bmc/kepler/Systems/:SystemID/NetworkAdapters/:ID',
        'bmc.kepler.Systems.NetworkAdapter')
    local data = dtframe.fuzz_set_get_mdb_interface('NetworkAdapter',
        'bmc.kepler.Systems.NetworkAdapter', 'StartRemovingDevice')

    ID = data[1]

    obj:StartRemovingDevice(ctx.new("Fuzz", "NA" , "NA"), ID)

end

local function fuzz_NCSI_SendCmdOverMCTP()

    local obj = mdb.get_object(bus, '/bmc/kepler/Debug/Systems/${SystemId}/NCSI', 'bmc.kepler.Debug.Systems.NCSI')
    local data = dtframe.fuzz_set_get_mdb_interface('NCSI', 'bmc.kepler.Debug.Systems.NCSI', 'SendCmdOverMCTP')

    NodeId = data[1]

    Command = data[2]

    Payload = data[3]

    obj:SendCmdOverMCTP(ctx.new("Fuzz", "NA" , "NA"), NodeId ,Command ,Payload)

end

---开始循环run cases

function FuzzMDB.fuzz_test(b)
    bus = b
    dtframe.fuzz_updateconfig(cf)
    fuzz_process(fuzz_NetworkAdapters_GetNetCardPortNum, "fuzz_NetworkAdapters_GetNetCardPortNum")
    fuzz_process(fuzz_NetworkAdapters_GetPortSpeed, "fuzz_NetworkAdapters_GetPortSpeed")
    fuzz_process(fuzz_NetworkAdapter_StartRemovingDevice, "fuzz_NetworkAdapter_StartRemovingDevice")
    fuzz_process(fuzz_NCSI_SendCmdOverMCTP, "fuzz_NCSI_SendCmdOverMCTP")
end

return FuzzMDB

