-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
require 'skynet.manager'
local log = require 'mc.logging'
local network_adapter_app = require 'network_adapter_app'

local CMD = {}
local app

local function change_debuglog_path(option)
    if not option then
        return
    end
    log:setLevel(log.DEBUG)
    local old_info = log.info
    log.info = function(self, fmt, ...)
        skynet.error('INFO', string.format(fmt, ...))
        old_info(self, fmt, ...)
    end
    local old_error = log.error
    log.error = function(self, fmt, ...)
        skynet.error('ERROR', string.format(fmt, ...))
        old_error(self, fmt, ...)
    end
    local old_debug = log.debug
    log.debug = function(self, fmt, ...)
        skynet.error('DEBUG', string.format(fmt, ...))
        old_debug(self, fmt, ...)
    end
end

change_debuglog_path(false)

function CMD.exit()
    skynet.timeout(0, function()
        log:info('[network_adapter] service exit')
        skynet.exit()
    end)
end

skynet.start(function()
    skynet.uniqueservice('sd_bus')
    skynet.register('network_adapter')
    app = network_adapter_app.new()
    local ok, handler = pcall(require, 'network_adapter_manufacture_app')
    if ok then
        local manufacture = handler.new(app)
        manufacture:init()
    end
    skynet.dispatch('lua', function(_, _, cmd, ...)
        local f = assert(CMD[cmd])
        skynet.ret(skynet.pack(f(...)))
    end)
end)
